/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openl.rules.ruleservice.core.OpenLService;
import org.openl.rules.ruleservice.core.RuleServiceDeployException;
import org.openl.rules.ruleservice.core.RuleServiceUndeployException;
import org.openl.rules.ruleservice.publish.RuleServicePublisher;
import org.openl.rules.ruleservice.publish.URLHelper;
import org.openl.rules.ruleservice.publish.rmi.RmiEnhancerHelper;
import org.openl.rules.ruleservice.rmi.DefaultRmiHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiRuleServicePublisher
implements RuleServicePublisher {
    private final Logger log = LoggerFactory.getLogger(RmiRuleServicePublisher.class);
    private final Map<OpenLService, ServiceServer> runningServices = new HashMap<OpenLService, ServiceServer>();
    private int rmiPort = 1099;
    private String rmiHost = "127.0.0.1";

    public void setRmiPort(int rmiPort) {
        this.rmiPort = rmiPort;
    }

    public int getRmiPort() {
        return this.rmiPort;
    }

    public String getRmiHost() {
        return this.rmiHost;
    }

    public void setRmiHost(String rmiHost) {
        this.rmiHost = rmiHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Registry getRegistry() throws RemoteException {
        Class<LocateRegistry> clazz = LocateRegistry.class;
        synchronized (LocateRegistry.class) {
            try {
                Registry reg = LocateRegistry.getRegistry(this.getRmiPort());
                reg.list();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return reg;
            }
            catch (RemoteException ex) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return LocateRegistry.createRegistry(this.getRmiPort());
            }
        }
    }

    protected DefaultRmiHandler enhanceServiceBeanWithDynamicRmiHandler(OpenLService service) throws Exception {
        return RmiEnhancerHelper.decorateBeanWithDynamicRmiHandler(service.getServiceBean(), service);
    }

    protected Remote enhanceServiceBeanWithStaticRmiHandler(OpenLService service) throws Exception {
        return RmiEnhancerHelper.decorateBeanWithStaticRmiHandler(service.getServiceBean(), service);
    }

    public void deploy(OpenLService service) throws RuleServiceDeployException {
        Objects.requireNonNull(service, "service cannot be null");
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(service.getClassLoader());
            Registry registry = this.getRegistry();
            String rmiName = service.getRmiName() != null ? service.getRmiName() : URLHelper.processURL((String)service.getUrl());
            Object rmiHandler = service.getRmiServiceClass() == null ? this.enhanceServiceBeanWithDynamicRmiHandler(service) : this.enhanceServiceBeanWithStaticRmiHandler(service);
            Remote stub = UnicastRemoteObject.exportObject((Remote)rmiHandler, 0);
            registry.bind(rmiName, stub);
            ServiceServer serviceServer = new ServiceServer(rmiName, (Remote)rmiHandler);
            this.runningServices.put(service, serviceServer);
            this.log.info("Service '{}' has been exposed with RMI deploy path '{}'.", (Object)service.getDeployPath(), (Object)rmiName);
        }
        catch (Exception t) {
            throw new RuleServiceDeployException(String.format("Failed to deploy service '%s'.", service.getDeployPath()), (Throwable)t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public OpenLService getServiceByDeploy(String deployPath) {
        Objects.requireNonNull(deployPath, "deployPath cannot be null");
        for (OpenLService service : this.runningServices.keySet()) {
            if (!service.getDeployPath().equals(deployPath)) continue;
            return service;
        }
        return null;
    }

    public void undeploy(OpenLService service) throws RuleServiceUndeployException {
        Objects.requireNonNull(service, "service cannot be null");
        ServiceServer server = this.runningServices.get(service);
        if (server == null) {
            throw new RuleServiceUndeployException(String.format("There is no running service with deploy path '%s'.", service.getDeployPath()));
        }
        try {
            this.getRegistry().unbind(server.getName());
            UnicastRemoteObject.unexportObject(server.getRmiHandler(), true);
            this.runningServices.remove(service);
            this.log.info("Service '{}' has been undeployed succesfully.", (Object)service.getDeployPath());
        }
        catch (Exception t) {
            throw new RuleServiceUndeployException(String.format("Failed to undeploy service '%s'.", service.getDeployPath()), (Throwable)t);
        }
    }

    public String getUrl(OpenLService service) {
        return "rmi://" + this.getRmiHost() + ":" + this.getRmiPort() + "/" + URLHelper.processURL((String)service.getUrl());
    }

    public String name() {
        return "RMI";
    }

    private static class ServiceServer {
        private final String name;
        private final Remote rmiHandler;

        public ServiceServer(String name, Remote rmiHandler) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            this.rmiHandler = Objects.requireNonNull(rmiHandler, "rmiHandler cannot be null");
        }

        public String getName() {
            return this.name;
        }

        public Remote getRmiHandler() {
            return this.rmiHandler;
        }
    }
}

