/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.deployer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.openl.rules.repository.RepositoryInstatiator;
import org.openl.rules.repository.api.ChangesetType;
import org.openl.rules.repository.api.FileData;
import org.openl.rules.repository.api.FileItem;
import org.openl.rules.repository.api.FolderItem;
import org.openl.rules.repository.api.FolderRepository;
import org.openl.rules.repository.api.Repository;
import org.openl.rules.repository.folder.FileChangesFromZip;
import org.openl.rules.ruleservice.deployer.DeploymentUtils;
import org.openl.util.IOUtils;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class RulesDeployerService
implements Closeable {
    private static final String RULES_XML = "rules.xml";
    private static final String DEFAULT_DEPLOYMENT_NAME = "openl_rules_";
    static final String DEFAULT_AUTHOR_NAME = "OpenL_Deployer";
    private static final String DEPLOYMENT_DESCRIPTOR_FILE_NAME = "deployment";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Repository deployRepo;
    private final String deployPath;

    public RulesDeployerService(Repository repository, String deployPath) {
        this.deployRepo = repository;
        this.deployPath = deployPath.isEmpty() || deployPath.endsWith("/") ? deployPath : deployPath + "/";
    }

    public RulesDeployerService(Properties properties) {
        String deployPath = properties.getProperty("production-repository.base.path");
        this.deployPath = deployPath.isEmpty() || deployPath.endsWith("/") ? deployPath : deployPath + "/";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uri", properties.getProperty("production-repository.uri"));
        params.put("login", properties.getProperty("production-repository.login"));
        params.put("password", properties.getProperty("production-repository.password"));
        params.put("bucketName", properties.getProperty("production-repository.bucket-name"));
        params.put("regionName", properties.getProperty("production-repository.region-name"));
        params.put("accessKey", properties.getProperty("production-repository.access-key"));
        params.put("secretKey", properties.getProperty("production-repository.secret-key"));
        params.put("localRepositoryPath", properties.getProperty("production-repository.local-repository-path"));
        params.put("branch", properties.getProperty("production-repository.branch"));
        params.put("tagPrefix", properties.getProperty("production-repository.tag-prefix"));
        params.put("commentTemplate", properties.getProperty("production-repository.comment-template"));
        params.put("connection-timeout", properties.getProperty("production-repository.connection-timeout"));
        params.put("listener-timer-period", properties.getProperty("production-repository.listener-timer-period"));
        this.deployRepo = RepositoryInstatiator.newRepository((String)properties.getProperty("production-repository.factory"), params);
    }

    public void deploy(String name, InputStream in, boolean overridable) throws Exception {
        this.deployInternal(name, in, overridable);
    }

    public void deploy(InputStream in, boolean overridable) throws Exception {
        this.deployInternal(null, in, overridable);
    }

    private void deployInternal(String originalName, InputStream in, boolean overridable) throws Exception {
        String name;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copyAndClose((InputStream)in, (OutputStream)baos);
        if (baos.size() == 0) {
            throw new RuntimeException("Zip file input stream is empty");
        }
        Map<String, byte[]> zipEntries = DeploymentUtils.unzip(new ByteArrayInputStream(baos.toByteArray()));
        String deploymentName = this.getDeploymentName(zipEntries);
        String string = name = originalName != null ? originalName : DEFAULT_DEPLOYMENT_NAME + System.currentTimeMillis();
        if (deploymentName == null) {
            FileData dest = this.createFileData(zipEntries, null, name, overridable);
            if (dest != null) {
                this.doDeploy(dest, baos.size(), new ByteArrayInputStream(baos.toByteArray()));
            }
        } else {
            List<FileItem> fileItems = this.splitMultipleDeployment(zipEntries, deploymentName, name, overridable);
            if (this.deployRepo.supports().folders()) {
                List folderItems = fileItems.stream().map(fi -> {
                    FileData data = fi.getData();
                    FileChangesFromZip files = new FileChangesFromZip(new ZipInputStream(fi.getStream()), data.getName());
                    return new FolderItem(data, (Iterable)files);
                }).collect(Collectors.toList());
                ((FolderRepository)this.deployRepo).save(folderItems, ChangesetType.FULL);
            } else {
                this.deployRepo.save(fileItems);
            }
        }
    }

    private List<FileItem> splitMultipleDeployment(Map<String, byte[]> zipEntries, String deploymentName, String name, boolean overridable) throws Exception {
        HashSet<String> projectFolders = new HashSet<String>();
        String rulesXml = "/rules.xml";
        for (String fileName : zipEntries.keySet()) {
            int last = fileName.lastIndexOf(rulesXml);
            if (last <= 0) continue;
            String projectFolder = fileName.substring(0, last + 1);
            projectFolders.add(projectFolder);
        }
        if (projectFolders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        for (String projectFolder : projectFolders) {
            HashMap<String, byte[]> newProjectEntries = new HashMap<String, byte[]>();
            for (Map.Entry<String, byte[]> entry : zipEntries.entrySet()) {
                String originalPath = entry.getKey();
                if (!originalPath.startsWith(projectFolder)) continue;
                String newPath = originalPath.substring(projectFolder.length());
                newProjectEntries.put(newPath, entry.getValue());
            }
            if (newProjectEntries.isEmpty()) continue;
            FileData dest = this.createFileData(newProjectEntries, deploymentName, name, overridable);
            if (dest == null) {
                return Collections.emptyList();
            }
            ByteArrayOutputStream zipbaos = DeploymentUtils.archiveAsZip(newProjectEntries);
            if (!this.deployRepo.supports().folders()) {
                dest.setSize((long)zipbaos.size());
            }
            fileItems.add(new FileItem(dest, (InputStream)new ByteArrayInputStream(zipbaos.toByteArray())));
        }
        if (fileItems.isEmpty()) {
            throw new RuntimeException("Invalid deployment structure! Cannot detect projects.");
        }
        return fileItems;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDeploymentName(Map<String, byte[]> zipEntries) {
        String deploymentName = DEFAULT_DEPLOYMENT_NAME + System.currentTimeMillis();
        if (zipEntries.get("deployment.xml") != null) {
            return deploymentName;
        }
        byte[] bytes = zipEntries.get("deployment.yaml");
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream fileStream = new ByteArrayInputStream(bytes);){
            Yaml yaml = new Yaml();
            Map properties = (Map)yaml.loadAs((InputStream)fileStream, Map.class);
            String string = Optional.ofNullable(properties.get("name")).map(Object::toString).filter(StringUtils::isNotBlank).orElse(deploymentName);
            return string;
        }
        catch (IOException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            return deploymentName;
        }
    }

    private FileData createFileData(Map<String, byte[]> zipEntries, String defaultDeploymentName, String defaultName, boolean overridable) throws Exception {
        String deploymentName;
        String projectName = this.readProjectName(zipEntries.get(RULES_XML), defaultName);
        String apiVersion = this.readApiVersion(zipEntries.get("rules-deploy.xml"));
        String string = deploymentName = defaultDeploymentName == null ? projectName : defaultDeploymentName;
        if (apiVersion != null && !apiVersion.isEmpty()) {
            deploymentName = deploymentName + "_V" + apiVersion;
        }
        if (!overridable && this.isRulesDeployed(deploymentName)) {
            this.log.info("Module '{}' is skipped for deploy because it has been already deployed.", (Object)deploymentName);
            return null;
        }
        FileData dest = new FileData();
        dest.setName(this.deployPath + deploymentName + '/' + projectName);
        dest.setAuthor(DEFAULT_AUTHOR_NAME);
        return dest;
    }

    private String readProjectName(byte[] bytes, String defaultName) {
        if (bytes == null) {
            return null;
        }
        String name = DeploymentUtils.getProjectName(new ByteArrayInputStream(bytes));
        return name == null || name.isEmpty() ? defaultName : name;
    }

    private String readApiVersion(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return DeploymentUtils.getApiVersion(new ByteArrayInputStream(bytes));
    }

    private void doDeploy(FileData dest, Integer contentSize, InputStream inputStream) throws IOException {
        if (this.deployRepo.supports().folders()) {
            ((FolderRepository)this.deployRepo).save(dest, (Iterable)new FileChangesFromZip(new ZipInputStream(inputStream), dest.getName()), ChangesetType.FULL);
        } else {
            dest.setSize((long)contentSize.intValue());
            this.deployRepo.save(dest, inputStream);
        }
    }

    private boolean isRulesDeployed(String deploymentName) throws IOException {
        List deployments = this.deployRepo.list(this.deployPath + deploymentName + "/");
        return !deployments.isEmpty();
    }

    @Override
    public void close() {
        if (this.deployRepo instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)this.deployRepo));
        }
    }
}

