/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.generation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.openl.types.IOpenClass;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceTransformer {
    public static final Function<Integer, Integer> IGNORE_PARAMETER_ANNOTATIONS = index -> -1;
    public static final Function<Integer, Integer> ADD_FIRST_PARAMETER = index -> index + 1;
    public static final Function<Integer, Integer> REMOVE_FIRST_PARAMETER = index -> index - 1;
    private final Logger log = LoggerFactory.getLogger(InterfaceTransformer.class);
    private final Class<?> classToTransform;
    private final String className;
    private final Function<Integer, Integer> methodParameterAdaptor;
    private static final Comparator<java.lang.reflect.Method> METHOD_COMPARATOR = Comparator.comparing(java.lang.reflect.Method::getName).thenComparingInt(java.lang.reflect.Method::getParameterCount).thenComparing(java.lang.reflect.Method::getParameterTypes, InterfaceTransformer::compareNames);

    private static int compareNames(Class<?>[] p1, Class<?>[] p2) {
        for (int i = 0; i < p1.length; ++i) {
            String name2;
            String name1 = p1[i].getName();
            int cmp = name1.compareTo(name2 = p2[i].getName());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public InterfaceTransformer(Class<?> interfaceToTransform, String className) {
        this.classToTransform = interfaceToTransform;
        this.className = className;
        this.methodParameterAdaptor = e -> e;
    }

    public InterfaceTransformer(Class<?> interfaceToTransform, String className, Function<Integer, Integer> methodParameterAdaptor) {
        this.classToTransform = interfaceToTransform;
        this.className = className;
        this.methodParameterAdaptor = methodParameterAdaptor;
    }

    public void accept(ClassVisitor classVisitor) {
        classVisitor.visit(52, this.classToTransform.isInterface() ? this.classToTransform.getModifiers() : this.classToTransform.getModifiers() | 0x400, this.className.replace('.', '/'), null, Object.class.getName().replace('.', '/'), (String[])Arrays.stream(this.classToTransform.getInterfaces()).map(e -> e.getName().replace('.', '/')).toArray(String[]::new));
        for (Annotation annotation : this.classToTransform.getAnnotations()) {
            AnnotationVisitor av = classVisitor.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true);
            InterfaceTransformer.processAnnotation(annotation, av);
        }
        HashSet<String> usedFields = new HashSet<String>();
        HashSet<Class> usedClasses = new HashSet<Class>();
        HashSet<MethodKey> usedMethods = new HashSet<MethodKey>();
        LinkedList queue = new LinkedList();
        LinkedList interfacesQueue = new LinkedList();
        queue.add(this.classToTransform);
        while (!queue.isEmpty()) {
            Class x = (Class)queue.poll();
            if (x.isSynthetic() || usedClasses.contains(x)) continue;
            usedClasses.add(x);
            Field[] declaredFields = x.getDeclaredFields();
            Arrays.sort(declaredFields, Comparator.comparing(Field::getName));
            for (Field field : declaredFields) {
                if (field.isSynthetic() || usedFields.contains(field.getName())) continue;
                usedFields.add(field.getName());
                try {
                    FieldVisitor fieldVisitor = classVisitor.visitField(field.getModifiers(), field.getName(), Type.getDescriptor(field.getType()), null, InterfaceTransformer.isConstantField(field) ? field.get(null) : null);
                    if (fieldVisitor == null) continue;
                    for (Annotation annotation : field.getAnnotations()) {
                        AnnotationVisitor av = fieldVisitor.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true);
                        InterfaceTransformer.processAnnotation(annotation, av);
                    }
                }
                catch (Exception e2) {
                    this.log.error("Failed to process field '{}'.", (Object)field.getName(), (Object)e2);
                }
            }
            java.lang.reflect.Method[] declaredMethods = x.getDeclaredMethods();
            Arrays.sort(declaredMethods, METHOD_COMPARATOR);
            for (java.lang.reflect.Method method : declaredMethods) {
                MethodKey methodKey;
                if (method.isSynthetic() || usedMethods.contains(methodKey = new MethodKey(method.getName(), (IOpenClass[])Arrays.stream(method.getParameterTypes()).map(JavaOpenClass::getOpenClass).toArray(JavaOpenClass[]::new)))) continue;
                usedMethods.add(methodKey);
                String ruleName = method.getName();
                MethodVisitor methodVisitor = classVisitor.visitMethod(x.isInterface() ? method.getModifiers() : method.getModifiers() | 0x400, ruleName, Type.getMethodDescriptor((java.lang.reflect.Method)method), null, null);
                this.processAnnotationsOnExecutable(methodVisitor, method);
                if (methodVisitor == null) continue;
                methodVisitor.visitEnd();
            }
            if (x.isInterface()) {
                queue.addAll(Arrays.asList(x.getInterfaces()));
                continue;
            }
            if (x.getSuperclass() == Object.class) {
                queue = interfacesQueue;
                continue;
            }
            queue.add(x.getSuperclass());
            interfacesQueue.addAll(Arrays.asList(x.getInterfaces()));
        }
        if (!this.classToTransform.isInterface()) {
            for (Constructor<?> constructor : this.classToTransform.getDeclaredConstructors()) {
                if (constructor.isSynthetic()) continue;
                GeneratorAdapter mg = new GeneratorAdapter(constructor.getModifiers(), Method.getMethod(constructor), null, null, classVisitor);
                this.processAnnotationsOnExecutable((MethodVisitor)mg, constructor);
                mg.visitCode();
                mg.loadThis();
                mg.invokeConstructor(Type.getType(this.classToTransform.getSuperclass()), Method.getMethod((String)"void <init> ()"));
                mg.visitInsn(177);
                int i = 1;
                for (Class<?> paramType : constructor.getParameterTypes()) {
                    if (Long.TYPE == paramType || Double.TYPE == paramType) {
                        i += 2;
                        continue;
                    }
                    ++i;
                }
                mg.visitMaxs(1, i);
                mg.visitEnd();
            }
        }
    }

    private void processAnnotationsOnExecutable(MethodVisitor methodVisitor, Executable executable) {
        if (methodVisitor != null) {
            for (Annotation annotation : executable.getAnnotations()) {
                AnnotationVisitor av = methodVisitor.visitAnnotation(Type.getDescriptor(annotation.annotationType()), true);
                InterfaceTransformer.processAnnotation(annotation, av);
            }
            int index = 0;
            for (Annotation[] annotations : executable.getParameterAnnotations()) {
                int i = this.methodParameterAdaptor.apply(index);
                if (i >= 0 && i < executable.getParameterCount()) {
                    for (Annotation annotation : annotations) {
                        String descriptor = Type.getDescriptor(annotation.annotationType());
                        AnnotationVisitor av = methodVisitor.visitParameterAnnotation(i, descriptor, true);
                        InterfaceTransformer.processAnnotation(annotation, av);
                    }
                }
                ++index;
            }
        }
    }

    private static boolean isConstantField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public static void processAnnotation(Annotation annotation, AnnotationVisitor av) {
        if (av != null) {
            for (java.lang.reflect.Method m : annotation.annotationType().getDeclaredMethods()) {
                try {
                    Object attributeValue = m.invoke((Object)annotation, new Object[0]);
                    Class<?> attributeType = attributeValue.getClass();
                    if (attributeType.isArray()) {
                        Object[] array;
                        AnnotationVisitor arrayVisitor = av.visitArray(m.getName());
                        for (Object o : array = (Object[])attributeValue) {
                            InterfaceTransformer.visitNonArrayAnnotationAttribute(arrayVisitor, null, o);
                        }
                        arrayVisitor.visitEnd();
                        continue;
                    }
                    InterfaceTransformer.visitNonArrayAnnotationAttribute(av, m.getName(), attributeValue);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            av.visitEnd();
        }
    }

    private static void visitNonArrayAnnotationAttribute(AnnotationVisitor av, String attributeName, Object attributeValue) {
        Class<?> attributeType = attributeValue.getClass();
        if (attributeValue instanceof Class) {
            av.visit(attributeName, (Object)Type.getType((Class)((Class)attributeValue)));
        } else if (attributeType.isEnum()) {
            av.visitEnum(attributeName, Type.getDescriptor(attributeType), attributeValue.toString());
        } else if (attributeValue instanceof Annotation) {
            Annotation annotation = (Annotation)attributeValue;
            AnnotationVisitor av1 = av.visitAnnotation(attributeName, Type.getDescriptor(annotation.annotationType()));
            InterfaceTransformer.processAnnotation(annotation, av1);
        } else {
            av.visit(attributeName, attributeValue);
        }
    }

    public Class<?> getClassToTransform() {
        return this.classToTransform;
    }

    public String getClassName() {
        return this.className;
    }
}

