/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectResolver {
    private static final ProjectResolver INSTANCE = new ProjectResolver();
    private final Logger log = LoggerFactory.getLogger(ProjectResolver.class);

    public static ProjectResolver getInstance() {
        return INSTANCE;
    }

    public ResolvingStrategy isRulesProject(Path folder) {
        ServiceLoader<ResolvingStrategy> strategies = ServiceLoader.load(ResolvingStrategy.class);
        for (ResolvingStrategy strategy : strategies) {
            if (!strategy.isRulesProject(folder)) continue;
            return strategy;
        }
        return null;
    }

    public ResolvingStrategy isRulesProject(File folder) {
        return this.isRulesProject(folder.toPath());
    }

    public ProjectDescriptor resolve(Path file) throws ProjectResolvingException {
        ResolvingStrategy strategy = this.isRulesProject(file);
        if (strategy != null) {
            return strategy.resolveProject(file);
        }
        return null;
    }

    public ProjectDescriptor resolve(File file) throws ProjectResolvingException {
        return this.resolve(file.toPath());
    }

    public List<ProjectDescriptor> resolve(File ... files) {
        ArrayList<ProjectDescriptor> projectDescriptors = new ArrayList<ProjectDescriptor>();
        for (File file : files) {
            try {
                ProjectDescriptor project = this.resolve(file);
                if (project == null) continue;
                projectDescriptors.add(project);
            }
            catch (Exception ex) {
                this.log.warn("Failed to resolve project in {}", (Object)file, (Object)ex);
            }
        }
        return projectDescriptors;
    }
}

