/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.OpenAPI;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDependencyDescriptor;
import org.openl.rules.project.xml.XmlProjectDescriptorSerializer;
import org.openl.util.FileUtils;
import org.openl.util.RuntimeExceptionWrapper;
import org.springframework.util.AntPathMatcher;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="project")
public class ProjectDescriptor {
    @XmlTransient
    private String id;
    @XmlJavaTypeAdapter(value=XmlProjectDescriptorSerializer.CollapsedStringAdapter2.class)
    private String name;
    private String comment;
    @XmlTransient
    private Path projectFolder;
    @XmlElementWrapper(name="modules")
    @XmlElement(name="module")
    private List<Module> modules;
    @XmlElementWrapper(name="classpath")
    @XmlElement(name="entry")
    private List<PathEntry> classpath;
    private OpenAPI openapi;
    @XmlElementWrapper(name="dependencies")
    @XmlElement(name="dependency")
    private List<ProjectDependencyDescriptor> dependencies;
    @XmlElement(name="properties-file-name-pattern")
    private String[] propertiesFileNamePatterns;
    @XmlElement(name="properties-file-name-processor")
    private String propertiesFileNameProcessor;
    @XmlTransient
    private volatile URL[] classPathUrls;

    public String[] getPropertiesFileNamePatterns() {
        return this.propertiesFileNamePatterns;
    }

    public void setPropertiesFileNamePatterns(String[] propertiesFileNamePatterns) {
        this.propertiesFileNamePatterns = propertiesFileNamePatterns;
    }

    public String getPropertiesFileNameProcessor() {
        return this.propertiesFileNameProcessor;
    }

    public void setPropertiesFileNameProcessor(String propertiesFileNameProcessor) {
        this.propertiesFileNameProcessor = propertiesFileNameProcessor;
    }

    public List<ProjectDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ProjectDependencyDescriptor> dependencies) {
        this.dependencies = dependencies;
    }

    public Path getProjectFolder() {
        return this.projectFolder;
    }

    public void setProjectFolder(Path projectRoot) {
        this.projectFolder = projectRoot;
    }

    public String getRelativeUri() {
        Path parent = this.projectFolder.getParent();
        if (parent == null) {
            return this.projectFolder.toUri().toString();
        }
        return parent.toUri().relativize(this.projectFolder.toUri()).toString();
    }

    @Deprecated
    public String getId() {
        return this.id;
    }

    @Deprecated
    public void setId(String id) {
        this.id = id;
    }

    public OpenAPI getOpenapi() {
        return this.openapi;
    }

    public void setOpenapi(OpenAPI openapi) {
        this.openapi = openapi;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<Module> getModules() {
        return this.modules != null ? this.modules : new ArrayList<Module>();
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public List<PathEntry> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List<PathEntry> classpath) {
        this.classpath = classpath;
    }

    private URI fixJarURI(URI jarURI) {
        if ("jar".equals(jarURI.getScheme())) {
            URI uriToZip = jarURI;
            if (uriToZip.getSchemeSpecificPart().contains("%")) {
                try {
                    uriToZip = new URI(uriToZip.getScheme() + ":" + uriToZip.getSchemeSpecificPart());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return uriToZip;
        }
        return jarURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getClassPathUrls() {
        URL projectUrl;
        if (this.projectFolder == null) {
            return new URL[0];
        }
        try {
            String file;
            projectUrl = this.fixJarURI(this.projectFolder.toUri()).normalize().toURL();
            if ("jar".equals(projectUrl.getProtocol()) && !(file = projectUrl.getPath()).endsWith("/")) {
                String suffix = null;
                suffix = file.contains("!/") ? "/" : "!/";
                projectUrl = new URL(projectUrl.getProtocol(), projectUrl.getHost(), projectUrl.getPort(), projectUrl.getPath() + suffix, null);
            }
        }
        catch (MalformedURLException e) {
            return new URL[0];
        }
        if (this.classpath == null) {
            return new URL[]{projectUrl};
        }
        if (this.classPathUrls == null) {
            ProjectDescriptor projectDescriptor = this;
            synchronized (projectDescriptor) {
                if (this.classPathUrls == null) {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    urls.add(projectUrl);
                    ArrayList<URL> originalUrls = new ArrayList<URL>(urls);
                    for (String path : this.processClasspathPathPatterns()) {
                        URL originalUrl;
                        URL url;
                        block25: {
                            path = path.replaceAll("\\\\", "/");
                            try {
                                originalUrl = url = new URL((String)(path.startsWith("/") ? "file://" + path : path)).toURI().normalize().toURL();
                            }
                            catch (MalformedURLException | URISyntaxException e1) {
                                try {
                                    originalUrl = url = new URL(projectUrl.getProtocol(), projectUrl.getHost(), projectUrl.getPort(), projectUrl.getPath() + (projectUrl.getPath().endsWith("/") ? "" : "/") + path, null).toURI().normalize().toURL();
                                    if (!"jar".equals(url.getProtocol()) || !"jar".equals(FileUtils.getExtension((String)path))) break block25;
                                    try {
                                        Path temp = Files.createTempFile("tmp-" + FileUtils.getBaseName((String)path) + "-", FileUtils.getExtension((String)path), new FileAttribute[0]);
                                        temp.toFile().deleteOnExit();
                                        try (InputStream is = url.openStream();){
                                            Files.copy(is, temp, StandardCopyOption.REPLACE_EXISTING);
                                        }
                                        url = temp.toUri().normalize().toURL();
                                    }
                                    catch (FileNotFoundException temp) {
                                    }
                                    catch (IOException e) {
                                        throw RuntimeExceptionWrapper.wrap((Throwable)e);
                                    }
                                }
                                catch (MalformedURLException | URISyntaxException e2) {
                                    continue;
                                }
                            }
                        }
                        boolean f = false;
                        for (URL url1 : originalUrls) {
                            if (!url1.sameFile(originalUrl)) continue;
                            f = true;
                        }
                        if (f) continue;
                        originalUrls.add(originalUrl);
                        urls.add(url);
                    }
                    this.classPathUrls = urls.toArray(new URL[0]);
                }
            }
        }
        return this.classPathUrls;
    }

    private Set<String> processClasspathPathPatterns() {
        HashSet<String> pathEntries = new HashSet<String>();
        for (PathEntry pathEntry : this.classpath) {
            String path = pathEntry.getPath().replace('\\', '/').trim();
            if (path.startsWith("./")) {
                path = path.substring(2);
            }
            if (path.contains("*") || path.contains("?")) {
                this.resolve(this.projectFolder, pathEntries, path, this.projectFolder);
                continue;
            }
            if (path.endsWith("/")) {
                pathEntries.add(path);
                continue;
            }
            File file = new File(path);
            if (file.isAbsolute() && file.isDirectory()) {
                pathEntries.add(path + "/");
                continue;
            }
            if (Files.isDirectory(this.projectFolder.resolve(path), new LinkOption[0])) {
                pathEntries.add(path + "/");
                continue;
            }
            pathEntries.add(path);
        }
        return pathEntries;
    }

    private void resolve(Path folder, final Collection<String> pathEntries, final String pathPattern, final Path rootFolder) {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (attrs.isDirectory()) {
                        return FileVisitResult.CONTINUE;
                    }
                    String relativePath = rootFolder.relativize(file).toString();
                    if (new AntPathMatcher().match(pathPattern, relativePath = relativePath.replace('\\', '/'))) {
                        pathEntries.add(relativePath);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    public String toString() {
        return "ProjectDescriptor{name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDescriptor that = (ProjectDescriptor)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

