/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation.variation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.cloner.Cloner;
import org.openl.rules.core.ce.ServiceMT;
import org.openl.rules.project.instantiation.variation.VariationInstantiationStrategyEnhancerHelper;
import org.openl.rules.runtime.OpenLRulesMethodHandler;
import org.openl.rules.variation.NoVariation;
import org.openl.rules.variation.Variation;
import org.openl.rules.variation.VariationsPack;
import org.openl.rules.variation.VariationsResult;
import org.openl.rules.vm.CacheMode;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;
import org.openl.runtime.ASMProxyFactory;
import org.openl.runtime.AbstractOpenLMethodHandler;
import org.openl.runtime.IEngineWrapper;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class VariationInstantiationStrategyEnhancerInvocationHandler
extends AbstractOpenLMethodHandler<Method, Method> {
    private final Logger log = LoggerFactory.getLogger(VariationInstantiationStrategyEnhancerInvocationHandler.class);
    private final Map<Method, Method> methodsMap;
    private final Object serviceClassInstance;

    VariationInstantiationStrategyEnhancerInvocationHandler(Map<Method, Method> methodsMap, Object serviceClassInstance) {
        this.methodsMap = Objects.requireNonNull(methodsMap, "methodMap cannot be null");
        this.serviceClassInstance = Objects.requireNonNull(serviceClassInstance, "serviceClassInstance cannot be null");
    }

    public Object getTarget() {
        return this.serviceClassInstance;
    }

    public Method getTargetMember(Method key) {
        return this.methodsMap.get(key);
    }

    public Object invoke(Method method, Object[] args) throws Exception {
        Method member = this.methodsMap.get(method);
        if (member == null) {
            return method.invoke(this.serviceClassInstance, args);
        }
        if (VariationInstantiationStrategyEnhancerHelper.isDecoratedMethod(method)) {
            this.log.debug("Invoking service class method with variations: {} -> {}", (Object)method, (Object)member);
            return this.calculateWithVariations(args, member);
        }
        this.log.debug("Invoking service class method without variations: {} -> {}", (Object)method, (Object)member);
        return member.invoke(this.serviceClassInstance, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object calculateWithVariations(Object[] args, Method member) {
        VariationsPack variationsPack = (VariationsPack)args[args.length - 1];
        Object[] arguments = Arrays.copyOf(args, args.length - 1);
        if (this.serviceClassInstance instanceof IEngineWrapper) {
            SimpleRulesRuntimeEnv runtimeEnv = (SimpleRulesRuntimeEnv)((IEngineWrapper)this.serviceClassInstance).getRuntimeEnv();
            runtimeEnv.changeMethodArgumentsCacheMode(CacheMode.READ_WRITE);
            runtimeEnv.setMethodArgumentsCacheEnable(true);
            runtimeEnv.getArgumentCachingStorage().resetOriginalCalculationSteps();
            runtimeEnv.getArgumentCachingStorage().resetMethodArgumentsCache();
            runtimeEnv.setOriginalCalculation(true);
            runtimeEnv.setIgnoreRecalculate(false);
            try {
                ForkJoinTask[] tasks;
                VariationsResult variationsResults = new VariationsResult();
                VariationsResult<Object> singleVariation = this.calculateSingleVariation(member, arguments, (Variation)new NoVariation());
                this.merge((VariationsResult<Object>)variationsResults, singleVariation);
                if (variationsPack != null && (tasks = this.createTasks(member, variationsPack, arguments, runtimeEnv)).length > 0) {
                    ServiceMT.getInstance().executeAll(tasks);
                    for (ForkJoinTask task : tasks) {
                        VariationsResult joinedVariation = (VariationsResult)task.join();
                        this.merge((VariationsResult<Object>)variationsResults, (VariationsResult<Object>)joinedVariation);
                    }
                }
                VariationsResult variationsResult = variationsResults;
                return variationsResult;
            }
            finally {
                runtimeEnv.setIgnoreRecalculate(true);
                runtimeEnv.setOriginalCalculation(true);
                runtimeEnv.getArgumentCachingStorage().resetOriginalCalculationSteps();
                runtimeEnv.setMethodArgumentsCacheEnable(false);
                runtimeEnv.setIgnoreRecalculate(true);
                runtimeEnv.getArgumentCachingStorage().resetMethodArgumentsCache();
            }
        }
        throw new OpenlNotCheckedException("Service instance class must to implement IEngineWrapper or OpenLWrapper interface.");
    }

    private void merge(VariationsResult<Object> results, VariationsResult<Object> item) {
        for (Map.Entry entry : item.getVariationResults().entrySet()) {
            results.registerResult((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : item.getVariationFailures().entrySet()) {
            results.registerFailure((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariationsResult<Object> calculateSingleVariation(Method member, Object[] arguments, Variation variation) {
        VariationsResult variationsResults = new VariationsResult();
        Object[] modifiedArguments = null;
        Object currentValue = null;
        try {
            try {
                currentValue = variation.currentValue(arguments);
                modifiedArguments = variation.applyModification(arguments);
                Object result = member.invoke(this.serviceClassInstance, modifiedArguments);
                variationsResults.registerResult(variation.getVariationID(), result);
            }
            catch (Exception e) {
                this.log.warn("Failed to calculate '{}'", (Object)variation.getVariationID(), (Object)e);
                Throwable e1 = e;
                if (e instanceof InvocationTargetException && e.getCause() != null) {
                    e1 = e.getCause();
                }
                variationsResults.registerFailure(variation.getVariationID(), e1.getMessage());
            }
        }
        finally {
            if (modifiedArguments != null) {
                try {
                    variation.revertModifications(modifiedArguments, currentValue);
                }
                catch (Exception e) {
                    this.log.error("Failed to revert modifications in variation '{}'", (Object)variation.getVariationID());
                }
            }
        }
        return variationsResults;
    }

    private VariationCalculationTask[] createTasks(Method member, VariationsPack variationsPack, Object[] arguments, SimpleRulesRuntimeEnv parentRuntimeEnv) {
        ArrayList<VariationCalculationTask> tasks = new ArrayList<VariationCalculationTask>(variationsPack.getVariations().size());
        if (!ASMProxyFactory.isProxy((Object)this.serviceClassInstance)) {
            this.log.warn("Variation features are not supported for Wrapper classes. This functionality is deprecated.");
        }
        for (Variation variation : variationsPack.getVariations()) {
            VariationCalculationTask item = new VariationCalculationTask(member, (Object[])Cloner.clone((Object)arguments), variation, parentRuntimeEnv.clone());
            tasks.add(item);
        }
        return tasks.toArray(new VariationCalculationTask[0]);
    }

    private class VariationCalculationTask
    extends RecursiveTask<VariationsResult<Object>> {
        private static final long serialVersionUID = 1L;
        private final Method member;
        private final Object[] arguments;
        private final Variation variation;
        private final IRuntimeEnv runtimeEnv;

        private VariationCalculationTask(Method member, Object[] arguments, Variation variation, IRuntimeEnv runtimeEnv) {
            this.member = member;
            this.arguments = arguments;
            this.variation = variation;
            this.runtimeEnv = runtimeEnv;
        }

        @Override
        protected VariationsResult<Object> compute() {
            OpenLRulesMethodHandler handler = null;
            try {
                VariationsResult<Object> simpleRulesRuntimeEnv;
                if (this.runtimeEnv instanceof SimpleRulesRuntimeEnv) {
                    if (ASMProxyFactory.isProxy((Object)VariationInstantiationStrategyEnhancerInvocationHandler.this.serviceClassInstance)) {
                        handler = (OpenLRulesMethodHandler)ASMProxyFactory.getProxyHandler((Object)VariationInstantiationStrategyEnhancerInvocationHandler.this.serviceClassInstance);
                        handler.setRuntimeEnv(this.runtimeEnv);
                    }
                    simpleRulesRuntimeEnv = (VariationsResult<Object>)this.runtimeEnv;
                    simpleRulesRuntimeEnv.changeMethodArgumentsCacheMode(CacheMode.READ_ONLY);
                    simpleRulesRuntimeEnv.setOriginalCalculation(false);
                    simpleRulesRuntimeEnv.setIgnoreRecalculate(true);
                    simpleRulesRuntimeEnv.getArgumentCachingStorage().initCurrentStep();
                }
                simpleRulesRuntimeEnv = VariationInstantiationStrategyEnhancerInvocationHandler.this.calculateSingleVariation(this.member, this.arguments, this.variation);
                return simpleRulesRuntimeEnv;
            }
            catch (Exception e) {
                VariationInstantiationStrategyEnhancerInvocationHandler.this.log.error("Failed to calculate a variation.", (Throwable)e);
                throw e;
            }
            finally {
                if (handler != null) {
                    handler.release();
                }
            }
        }
    }
}

