/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation.variation;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.openl.classloader.ClassLoaderUtils;
import org.openl.rules.variation.VariationsPack;
import org.openl.rules.variation.VariationsResult;
import org.openl.util.generation.InterfaceTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class VariationInstantiationStrategyEnhancerHelper {
    private static final String VARIATIONS_PACK_TYPE = "Lorg/openl/rules/variation/VariationsPack;";
    private static final String VARIATIONS_RESULT_TYPE = "Lorg/openl/rules/variation/VariationsResult;";
    private static final String UNDECORATED_CLASS_NAME_SUFFIX = "$VariationsUndecorated";
    private static final String DECORATED_CLASS_NAME_SUFFIX = "$VariationsDecorated";

    private VariationInstantiationStrategyEnhancerHelper() {
    }

    public static boolean isDecoratedClass(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!VariationInstantiationStrategyEnhancerHelper.isDecoratedMethod(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecoratedMethod(Method method) {
        int paramsLength = method.getParameterTypes().length;
        return paramsLength != 0 && method.getParameterTypes()[paramsLength - 1] == VariationsPack.class && method.getReturnType().equals(VariationsResult.class);
    }

    public static Class<?> undecorateClass(Class<?> clazz, ClassLoader classLoader) throws Exception {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Only interface classes are supported");
        }
        String className = clazz.getName() + UNDECORATED_CLASS_NAME_SUFFIX;
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Logger log = LoggerFactory.getLogger(VariationInstantiationStrategyEnhancerHelper.class);
            log.debug("Generating interface without variations for '{}' class", (Object)clazz.getName());
            return VariationInstantiationStrategyEnhancerHelper.innerUndecorateInterface(className, clazz, classLoader);
        }
    }

    private static Class<?> innerUndecorateInterface(String className, Class<?> original, ClassLoader classLoader) throws Exception {
        ClassWriter classWriter = new ClassWriter(0);
        UndecoratingClassWriter classVisitor = new UndecoratingClassWriter((ClassVisitor)classWriter, className);
        InterfaceTransformer transformer = new InterfaceTransformer(original, className);
        transformer.accept(classVisitor);
        classWriter.visitEnd();
        return ClassLoaderUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
    }

    public static Class<?> decorateClass(Class<?> clazz, ClassLoader classLoader) throws Exception {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Only interface classes are supported");
        }
        String className = clazz.getName() + DECORATED_CLASS_NAME_SUFFIX;
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Logger log = LoggerFactory.getLogger(VariationInstantiationStrategyEnhancerHelper.class);
            log.debug("Generating interface with variations for '{}' class", (Object)clazz.getName());
            return VariationInstantiationStrategyEnhancerHelper.innerDecorateInterface(className, clazz, classLoader);
        }
    }

    private static Class<?> innerDecorateInterface(String className, Class<?> original, ClassLoader classLoader) throws Exception {
        ClassWriter classWriter = new ClassWriter(0);
        DecoratingClassWriter classVisitor = new DecoratingClassWriter((ClassVisitor)classWriter, className);
        InterfaceTransformer transformer = new InterfaceTransformer(original, className);
        transformer.accept(classVisitor);
        classWriter.visitEnd();
        return ClassLoaderUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
    }

    public static Method getMethodForDecoration(Class<?> simpleClass, Method decoratedMethod) throws Exception {
        Class<?>[] parameterTypes = decoratedMethod.getParameterTypes();
        if (VariationInstantiationStrategyEnhancerHelper.isDecoratedMethod(decoratedMethod)) {
            return simpleClass.getMethod(decoratedMethod.getName(), Arrays.copyOf(parameterTypes, parameterTypes.length - 1));
        }
        return simpleClass.getMethod(decoratedMethod.getName(), parameterTypes);
    }

    private static class UndecoratingClassWriter
    extends ClassVisitor {
        private final String className;

        public UndecoratingClassWriter(ClassVisitor delegatedClassVisitor, String className) {
            super(327680, delegatedClassVisitor);
            this.className = className;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, this.className.replace('.', '/'), signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (!this.isDecoratedMethod(descriptor)) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            return null;
        }

        private boolean isDecoratedMethod(String signature) {
            return signature.contains("Lorg/openl/rules/variation/VariationsPack;)") && signature.endsWith(VariationInstantiationStrategyEnhancerHelper.VARIATIONS_RESULT_TYPE);
        }
    }

    private static class DecoratingClassWriter
    extends ClassVisitor {
        private final String className;

        public DecoratingClassWriter(ClassVisitor delegatedClassVisitor, String className) {
            super(327680, delegatedClassVisitor);
            this.className = className;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, this.className.replace('.', '/'), signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            super.visitMethod(access, name, this.addVariationToSignature(descriptor), signature, exceptions);
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        private String addVariationToSignature(String signature) {
            return signature.substring(0, signature.indexOf(")")) + "Lorg/openl/rules/variation/VariationsPack;)Lorg/openl/rules/variation/VariationsResult;";
        }
    }
}

