/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openl.CompiledOpenClass;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.project.dependencies.ProjectExternalDependenciesHelper;
import org.openl.rules.project.instantiation.ProjectEngineFactory;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancer;
import org.openl.rules.project.instantiation.SimpleDependencyManager;
import org.openl.rules.project.instantiation.SimpleMultiModuleInstantiationStrategy;
import org.openl.rules.project.instantiation.variation.VariationInstantiationStrategyEnhancer;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDependencyDescriptor;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ProjectResolver;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProjectEngineFactory<T>
implements ProjectEngineFactory<T> {
    protected final Logger log = LoggerFactory.getLogger(SimpleProjectEngineFactory.class);
    protected final Map<String, Object> externalParameters;
    protected final boolean provideRuntimeContext;
    protected final boolean provideVariations;
    protected final boolean executionMode;
    protected final ClassLoader classLoader;
    protected final File[] projectDependencies;
    protected final File project;
    protected final Class<?> interfaceClass;
    protected Class<?> generatedInterfaceClass;
    protected ProjectDescriptor projectDescriptor;
    private RulesInstantiationStrategy rulesInstantiationStrategy = null;
    private IDependencyManager dependencyManager = null;

    protected SimpleProjectEngineFactory(File project, File[] projectDependencies, ClassLoader classLoader, Class<T> interfaceClass, Map<String, Object> externalParameters, boolean provideRuntimeContext, boolean provideVariations, boolean executionMode) {
        this.project = Objects.requireNonNull(project, "project arg cannot be null");
        this.projectDependencies = projectDependencies;
        this.classLoader = classLoader;
        this.interfaceClass = interfaceClass;
        this.externalParameters = externalParameters;
        this.provideRuntimeContext = provideRuntimeContext;
        this.provideVariations = provideVariations;
        this.executionMode = executionMode;
    }

    protected RulesInstantiationStrategy getStrategy(Collection<Module> modules, IDependencyManager dependencyManager) {
        if (this.rulesInstantiationStrategy == null) {
            this.rulesInstantiationStrategy = new SimpleMultiModuleInstantiationStrategy(modules, dependencyManager, this.classLoader, this.isExecutionMode());
        }
        return this.rulesInstantiationStrategy;
    }

    private Set<ProjectDescriptor> getDependentProjects(ProjectDescriptor project, Collection<ProjectDescriptor> projectsInWorkspace) {
        HashSet<ProjectDescriptor> projectDescriptors = new HashSet<ProjectDescriptor>();
        this.addDependentProjects(projectDescriptors, project, projectsInWorkspace);
        return projectDescriptors;
    }

    private void addDependentProjects(Set<ProjectDescriptor> projectDescriptors, ProjectDescriptor project, Collection<ProjectDescriptor> projectsInWorkspace) {
        if (project.getDependencies() != null) {
            block0: for (ProjectDependencyDescriptor dependencyDescriptor : project.getDependencies()) {
                for (ProjectDescriptor projectDescriptor : projectsInWorkspace) {
                    if (!dependencyDescriptor.getName().equals(projectDescriptor.getName())) continue;
                    projectDescriptors.add(projectDescriptor);
                    this.addDependentProjects(projectDescriptors, projectDescriptor, projectsInWorkspace);
                    continue block0;
                }
            }
        }
    }

    protected IDependencyManager buildDependencyManager() throws ProjectResolvingException {
        return new SimpleDependencyManager(this.buildProjectDescriptors(), this.classLoader, this.isExecutionMode(), this.getExternalParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ProjectDescriptor> buildProjectDescriptors() throws ProjectResolvingException {
        ArrayList<ProjectDescriptor> projectDescriptors = new ArrayList<ProjectDescriptor>();
        ProjectResolver projectResolver = ProjectResolver.getInstance();
        ProjectDescriptor projectDescriptor = this.getProjectDescriptor();
        if (this.projectDependencies != null) {
            List<ProjectDescriptor> projects;
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (this.classLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                }
                projects = projectResolver.resolve(this.projectDependencies);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            Set<ProjectDescriptor> dependentProjects = this.getDependentProjects(projectDescriptor, projects);
            projectDescriptors.addAll(dependentProjects);
        }
        projectDescriptors.add(projectDescriptor);
        return projectDescriptors;
    }

    public final synchronized IDependencyManager getDependencyManager() throws ProjectResolvingException {
        if (this.dependencyManager == null) {
            this.dependencyManager = this.buildDependencyManager();
        }
        return this.dependencyManager;
    }

    public boolean isExecutionMode() {
        return this.executionMode;
    }

    @Override
    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public boolean isProvideVariations() {
        return this.provideVariations;
    }

    @Override
    public Class<?> getInterfaceClass() throws RulesInstantiationException, ProjectResolvingException {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        if (this.generatedInterfaceClass != null) {
            return this.generatedInterfaceClass;
        }
        this.log.info("Interface class is undefined for the factory. Generated interface is used.");
        this.generatedInterfaceClass = this.getRulesInstantiationStrategy().getInstanceClass();
        return this.generatedInterfaceClass;
    }

    @Override
    public Map<String, Object> getExternalParameters() {
        return this.externalParameters;
    }

    @Override
    public T newInstance() throws RulesInstantiationException, ProjectResolvingException {
        return (T)this.getRulesInstantiationStrategy().instantiate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ProjectDescriptor getProjectDescriptor() throws ProjectResolvingException {
        if (this.projectDescriptor == null) {
            ProjectDescriptor pd;
            ProjectResolver projectResolver = ProjectResolver.getInstance();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (this.classLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                }
                pd = projectResolver.resolve(this.project);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            if (pd == null) {
                throw new ProjectResolvingException(String.format("Failed to resolve the project. Folder '%s' is not a OpenL project.", this.project.getAbsolutePath()));
            }
            this.projectDescriptor = pd;
        }
        return this.projectDescriptor;
    }

    public final synchronized RulesInstantiationStrategy getRulesInstantiationStrategy() throws RulesInstantiationException, ProjectResolvingException {
        if (this.rulesInstantiationStrategy == null) {
            RulesInstantiationStrategy instantiationStrategy = this.getStrategy(this.getProjectDescriptor().getModules(), this.getDependencyManager());
            if (this.isProvideVariations()) {
                instantiationStrategy = new VariationInstantiationStrategyEnhancer(instantiationStrategy);
            }
            if (this.isProvideRuntimeContext()) {
                instantiationStrategy = new RuntimeContextInstantiationStrategyEnhancer(instantiationStrategy);
            }
            Map<String, Object> parameters = ProjectExternalDependenciesHelper.buildExternalParamsWithProjectDependencies(this.getExternalParameters(), this.getProjectDescriptor().getModules());
            instantiationStrategy.setExternalParameters(parameters);
            try {
                if (this.interfaceClass != null) {
                    instantiationStrategy.setServiceClass(this.interfaceClass);
                }
            }
            catch (Exception ex) {
                throw new RulesInstantiationException(ex);
            }
            this.rulesInstantiationStrategy = instantiationStrategy;
        }
        return this.rulesInstantiationStrategy;
    }

    @Override
    public CompiledOpenClass getCompiledOpenClass() throws RulesInstantiationException, ProjectResolvingException {
        return this.getRulesInstantiationStrategy().compile();
    }

    public static class SimpleProjectEngineFactoryBuilder<T> {
        protected String project;
        protected String workspace;
        protected ClassLoader classLoader;
        protected boolean provideRuntimeContext = false;
        protected boolean provideVariations = false;
        protected Class<T> interfaceClass = null;
        protected Map<String, Object> externalParameters = Collections.emptyMap();
        protected boolean executionMode = true;
        protected String[] projectDependencies;

        public SimpleProjectEngineFactoryBuilder<T> setProject(String project) {
            if (project == null || project.isEmpty()) {
                throw new IllegalArgumentException("project cannot be null or empty");
            }
            this.project = project;
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setInterfaceClass(Class<T> interfaceClass) {
            this.interfaceClass = interfaceClass;
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setExternalParameters(Map<String, Object> externalParameters) {
            this.externalParameters = Objects.requireNonNullElse(externalParameters, Collections.emptyMap());
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setExecutionMode(boolean executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setProvideRuntimeContext(boolean provideRuntimeContext) {
            this.provideRuntimeContext = provideRuntimeContext;
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setProvideVariations(boolean provideVariations) {
            this.provideVariations = provideVariations;
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setWorkspace(String workspace) {
            if (workspace == null || workspace.isEmpty()) {
                throw new IllegalArgumentException("workspace cannot be null or empty");
            }
            this.workspace = workspace;
            return this;
        }

        public SimpleProjectEngineFactoryBuilder<T> setProjectDependencies(String ... projectDependencies) {
            if (projectDependencies == null || projectDependencies.length == 0) {
                return this;
            }
            for (String dependency : projectDependencies) {
                if (dependency != null && !dependency.isEmpty()) continue;
                throw new IllegalArgumentException("Dependency cannot be null or empty");
            }
            this.projectDependencies = projectDependencies;
            return this;
        }

        protected File[] getProjectDependencies() {
            ArrayList<File> dependencies = new ArrayList<File>();
            if (this.workspace != null) {
                File workspaceFile = new File(this.workspace);
                if (!workspaceFile.isDirectory()) {
                    throw new IllegalArgumentException("Workspace is not a directory with projects");
                }
                File[] dirs = workspaceFile.listFiles(File::isDirectory);
                if (dirs != null) {
                    dependencies.addAll(Arrays.asList(dirs));
                }
            }
            if (this.projectDependencies != null) {
                for (String dependency : this.projectDependencies) {
                    File dependencyFile = new File(dependency);
                    if (!dependencyFile.isDirectory()) {
                        throw new IllegalArgumentException("Dependency is not a project directory");
                    }
                    dependencies.add(dependencyFile);
                }
            }
            return dependencies.isEmpty() ? null : dependencies.toArray(new File[0]);
        }

        public SimpleProjectEngineFactory<T> build() {
            if (this.project == null || this.project.isEmpty()) {
                throw new IllegalArgumentException("project cannot be null or empty");
            }
            File projectFile = new File(this.project);
            File[] dependencies = this.getProjectDependencies();
            return new SimpleProjectEngineFactory<T>(projectFile, dependencies, this.classLoader, this.interfaceClass, this.externalParameters, this.provideRuntimeContext, this.provideVariations, this.executionMode);
        }
    }
}

