/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.Collection;
import java.util.HashSet;
import org.openl.dependency.IDependencyManager;
import org.openl.rules.project.instantiation.MultiModuleInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.model.MethodFilter;
import org.openl.rules.project.model.Module;
import org.openl.rules.runtime.InterfaceClassGenerator;
import org.openl.rules.runtime.RulesEngineFactory;

public class SimpleMultiModuleInstantiationStrategy
extends MultiModuleInstantiationStrategy {
    private RulesEngineFactory<?> engineFactory;

    public SimpleMultiModuleInstantiationStrategy(Collection<Module> modules, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode) {
        super(modules, dependencyManager, classLoader, executionMode);
    }

    public SimpleMultiModuleInstantiationStrategy(Collection<Module> modules, IDependencyManager dependencyManager, boolean executionMode) {
        super(modules, dependencyManager, executionMode);
    }

    @Override
    public void reset() {
        super.reset();
        this.engineFactory = null;
    }

    @Override
    public Class<?> getGeneratedRulesClass() throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Class clazz = this.getEngineFactory().getInterfaceClass();
            return clazz;
        }
        catch (Exception e) {
            throw new RulesInstantiationException("Failed to resolve an interface.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public Object instantiate(Class<?> rulesClass, boolean ignoreCompilationErrors) throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Object object = this.getEngineFactory().newEngineInstance(ignoreCompilationErrors);
            return object;
        }
        catch (Exception e) {
            throw new RulesInstantiationException("Failed to instantiate.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected RulesEngineFactory<?> getEngineFactory() {
        Class<?> serviceClass = this.getServiceClass();
        if (this.engineFactory == null) {
            this.engineFactory = new RulesEngineFactory(this.createVirtualSourceCodeModule(), serviceClass);
            this.engineFactory.setExecutionMode(this.isExecutionMode());
            HashSet<String> allIncludes = new HashSet<String>();
            HashSet<String> allExcludes = new HashSet<String>();
            for (Module m : this.getModules()) {
                MethodFilter methodFilter = m.getMethodFilter();
                if (methodFilter == null) continue;
                if (methodFilter.getIncludes() != null) {
                    allIncludes.addAll(methodFilter.getIncludes());
                }
                if (methodFilter.getExcludes() == null) continue;
                allExcludes.addAll(methodFilter.getExcludes());
            }
            if (!allIncludes.isEmpty() || !allExcludes.isEmpty()) {
                String[] includes = new String[]{};
                String[] excludes = new String[]{};
                includes = allIncludes.toArray(includes);
                excludes = allExcludes.toArray(excludes);
                this.engineFactory.setInterfaceClassGenerator(new InterfaceClassGenerator(includes, excludes));
            }
            this.engineFactory.setDependencyManager(this.getDependencyManager());
        }
        return this.engineFactory;
    }

    @Override
    public void setServiceClass(Class<?> serviceClass) {
        super.setServiceClass(serviceClass);
        if (this.engineFactory != null) {
            this.engineFactory.setInterfaceClass(serviceClass);
        }
    }
}

