/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openl.rules.project.instantiation.AbstractDependencyManager;
import org.openl.rules.project.instantiation.DependencyLoaderInitializationException;
import org.openl.rules.project.instantiation.IDependencyLoader;
import org.openl.rules.project.instantiation.SimpleDependencyLoader;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;

public class SimpleDependencyManager
extends AbstractDependencyManager {
    private final Collection<ProjectDescriptor> projects;

    public SimpleDependencyManager(Collection<ProjectDescriptor> projects, ClassLoader rootClassLoader, boolean executionMode, Map<String, Object> externalParameters) {
        super(rootClassLoader, executionMode, externalParameters);
        this.projects = Objects.requireNonNull(projects, "projects cannot be null");
    }

    @Override
    protected Set<IDependencyLoader> initDependencyLoaders() {
        HashSet<IDependencyLoader> dependencyLoaders = new HashSet<IDependencyLoader>();
        for (ProjectDescriptor project : this.projects) {
            try {
                for (Module m : project.getModules()) {
                    SimpleDependencyLoader moduleDependencyLoader = new SimpleDependencyLoader(project, m, this.executionMode, this);
                    dependencyLoaders.add(moduleDependencyLoader);
                }
                SimpleDependencyLoader projectDependencyLoader = new SimpleDependencyLoader(project, null, this.executionMode, this);
                dependencyLoaders.add(projectDependencyLoader);
            }
            catch (Exception e) {
                throw new DependencyLoaderInitializationException(String.format("Failed to initialize dependency loaders for project '%s'.", project.getName()), e);
            }
        }
        return dependencyLoaders;
    }
}

