/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.openl.CompiledOpenClass;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.DependencyType;
import org.openl.dependency.IDependencyManager;
import org.openl.dependency.ResolvedDependency;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.project.dependencies.ProjectExternalDependenciesHelper;
import org.openl.rules.project.instantiation.AbstractDependencyManager;
import org.openl.rules.project.instantiation.ApiBasedInstantiationStrategy;
import org.openl.rules.project.instantiation.CommonRulesInstantiationStrategy;
import org.openl.rules.project.instantiation.IDependencyLoader;
import org.openl.rules.project.instantiation.SimpleMultiModuleInstantiationStrategy;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.validation.ValidationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDependencyLoader
implements IDependencyLoader {
    private final Logger log = LoggerFactory.getLogger(SimpleDependencyLoader.class);
    private final AbstractDependencyManager dependencyManager;
    private final ResolvedDependency dependency;
    private volatile CompiledDependency compiledDependency;
    private final boolean executionMode;
    private final ProjectDescriptor project;
    private final Module module;

    protected Map<String, Object> configureExternalParameters(IDependencyManager dependencyManager) {
        return ProjectExternalDependenciesHelper.buildExternalParamsWithProjectDependencies(dependencyManager.getExternalParameters(), this.getModules());
    }

    @Override
    public CompiledDependency getRefToCompiledDependency() {
        return this.compiledDependency;
    }

    private Collection<Module> getModules() {
        return this.module != null ? Collections.singleton(this.module) : this.project.getModules();
    }

    @Override
    public boolean isProjectLoader() {
        return this.module == null;
    }

    @Override
    public ProjectDescriptor getProject() {
        return this.project;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    public SimpleDependencyLoader(ProjectDescriptor project, Module module, boolean executionMode, AbstractDependencyManager dependencyManager) {
        this.project = Objects.requireNonNull(project, "project cannot be null");
        this.module = module;
        this.executionMode = executionMode;
        this.dependencyManager = Objects.requireNonNull(dependencyManager, "dependencyManager cannot be null");
        this.dependency = SimpleDependencyLoader.buildDependency(project, module);
    }

    public static ResolvedDependency buildDependency(ProjectDescriptor project, Module module) {
        if (module != null) {
            return AbstractDependencyManager.buildResolvedDependency(module);
        }
        return AbstractDependencyManager.buildResolvedDependency(project);
    }

    public AbstractDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompiledDependency getCompiledDependency() throws OpenLCompilationException {
        CompiledDependency cachedDependency = this.compiledDependency;
        if (cachedDependency != null) {
            this.log.debug("Compiled dependency '{}' is used from cache.", (Object)this.dependency);
            return cachedDependency;
        }
        this.log.debug("Dependency '{}' is not found in cache.", (Object)this.dependency);
        AbstractDependencyManager abstractDependencyManager = this.dependencyManager;
        synchronized (abstractDependencyManager) {
            cachedDependency = this.compiledDependency;
            if (cachedDependency != null) {
                this.log.debug("Compiled dependency '{}' is used from cache.", (Object)this.dependency);
                return cachedDependency;
            }
            return this.compileDependency();
        }
    }

    protected ClassLoader buildClassLoader(AbstractDependencyManager dependencyManager) {
        return dependencyManager.getExternalJarsClassLoader(this.getProject());
    }

    protected boolean isActualDependency() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompiledDependency compileDependency() throws OpenLCompilationException {
        ClassLoader classLoader = this.buildClassLoader(this.dependencyManager);
        CommonRulesInstantiationStrategy rulesInstantiationStrategy = !this.isProjectLoader() ? new ApiBasedInstantiationStrategy(this.module, this.dependencyManager, classLoader, this.executionMode) : new SimpleMultiModuleInstantiationStrategy(this.getModules(), this.dependencyManager, classLoader, this.executionMode);
        Map<String, Object> parameters = this.configureExternalParameters(this.dependencyManager);
        rulesInstantiationStrategy.setExternalParameters(parameters);
        rulesInstantiationStrategy.setServiceClass(EmptyInterface.class);
        boolean oldValidationState = ValidationManager.isValidationEnabled();
        try {
            ValidationManager.turnOffValidation();
            CompiledOpenClass compiledOpenClass = rulesInstantiationStrategy.compile();
            CompiledDependency compiledDependency = new CompiledDependency(this.dependency, compiledOpenClass, this.isProjectLoader() ? DependencyType.PROJECT : DependencyType.MODULE);
            if (this.isActualDependency()) {
                this.onCompilationComplete(this, compiledDependency);
                this.compiledDependency = compiledDependency;
                this.log.debug("Dependency '{}' is saved in cache.", (Object)this.dependency);
            }
            CompiledDependency compiledDependency2 = compiledDependency;
            return compiledDependency2;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            CompiledDependency compiledDependency = this.onCompilationFailure(ex, this.dependencyManager);
            return compiledDependency;
        }
        finally {
            if (oldValidationState) {
                ValidationManager.turnOnValidation();
            }
        }
    }

    protected void onCompilationComplete(IDependencyLoader dependencyLoader, CompiledDependency compiledDependency) {
    }

    protected CompiledDependency onCompilationFailure(Exception ex, AbstractDependencyManager dependencyManager) throws OpenLCompilationException {
        throw new OpenLCompilationException(String.format("Failed to load dependency '%s'.", this.dependency), (Throwable)ex);
    }

    @Override
    public ResolvedDependency getDependency() {
        return this.dependency;
    }

    @Override
    public void reset() {
        CompiledDependency compiledDependency1 = this.compiledDependency;
        if (compiledDependency1 != null) {
            this.onResetComplete(this, compiledDependency1);
        }
        this.compiledDependency = null;
    }

    protected void onResetComplete(IDependencyLoader dependencyLoader, CompiledDependency compiledDependency) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDependencyLoader that = (SimpleDependencyLoader)o;
        return this.dependency.equals((Object)that.dependency);
    }

    public int hashCode() {
        return Objects.hash(this.dependency);
    }

    public static interface EmptyInterface {
    }
}

