/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openl.CompiledOpenClass;
import org.openl.classloader.OpenLClassLoader;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.IDependencyManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.project.instantiation.AbstractDependencyManager;
import org.openl.rules.project.instantiation.CommonRulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.source.impl.VirtualSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.IOUtils;

public abstract class MultiModuleInstantiationStrategy
extends CommonRulesInstantiationStrategy {
    private final Collection<Module> modules;

    public MultiModuleInstantiationStrategy(Collection<Module> modules, IDependencyManager dependencyManager, boolean executionMode) {
        this(modules, dependencyManager, null, executionMode);
    }

    public MultiModuleInstantiationStrategy(Collection<Module> modules, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode) {
        super(executionMode, dependencyManager, classLoader);
        this.modules = modules;
    }

    @Override
    public Collection<Module> getModules() {
        return this.modules;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ClassLoader initClassLoader() throws RulesInstantiationException {
        OpenLClassLoader classLoader = new OpenLClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            Set projectDescriptors = this.modules.stream().map(Module::getProject).collect(Collectors.toSet());
            for (ProjectDescriptor pd : projectDescriptors) {
                try {
                    CompiledDependency compiledDependency = this.getDependencyManager().loadDependency(AbstractDependencyManager.buildResolvedDependency(pd));
                    CompiledOpenClass compiledOpenClass = compiledDependency.getCompiledOpenClass();
                    classLoader.addClassLoader(compiledOpenClass.getClassLoader());
                }
                catch (OpenLCompilationException e) {
                    throw new RulesInstantiationException(e.getMessage(), e);
                    return classLoader;
                }
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly((AutoCloseable)classLoader);
            throw e;
        }
    }

    protected IOpenSourceCodeModule createVirtualSourceCodeModule() {
        List dependencies = this.getModules().stream().map(AbstractDependencyManager::buildResolvedDependency).distinct().collect(Collectors.toList());
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.getExternalParameters() != null) {
            params.putAll(this.getExternalParameters());
        }
        if (params.get("external-dependencies") != null) {
            List externalDependencies = (List)params.get("external-dependencies");
            dependencies.addAll(externalDependencies);
        }
        params.put("external-dependencies", dependencies);
        VirtualSourceCodeModule source = new VirtualSourceCodeModule();
        source.setParams(params);
        return source;
    }
}

