/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import org.openl.dependency.IDependencyManager;
import org.openl.rules.project.instantiation.ModulePathSourceCodeModule;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.SingleModuleInstantiationStrategy;
import org.openl.rules.project.model.MethodFilter;
import org.openl.rules.project.model.Module;
import org.openl.rules.runtime.InterfaceClassGenerator;
import org.openl.rules.runtime.RulesEngineFactory;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.CollectionUtils;

public class ApiBasedInstantiationStrategy
extends SingleModuleInstantiationStrategy {
    private RulesEngineFactory<?> engineFactory;

    public ApiBasedInstantiationStrategy(Module module, IDependencyManager dependencyManager, boolean executionMode) {
        super(module, dependencyManager, executionMode);
    }

    public ApiBasedInstantiationStrategy(Module module, IDependencyManager dependencyManager, ClassLoader classLoader, boolean executionMode) {
        super(module, dependencyManager, classLoader, executionMode);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.engineFactory != null) {
            this.getEngineFactory().reset(false);
        }
    }

    @Override
    public void forcedReset() {
        super.forcedReset();
        this.engineFactory = null;
    }

    @Override
    public Class<?> getGeneratedRulesClass() throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Class clazz = this.getEngineFactory().getInterfaceClass();
            return clazz;
        }
        catch (Exception e) {
            throw new RulesInstantiationException("Failed to resolve a interface.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected RulesEngineFactory<?> getEngineFactory() {
        Class<?> serviceClass = this.getServiceClass();
        if (this.engineFactory == null) {
            Module module = this.getModule();
            ModulePathSourceCodeModule source = new ModulePathSourceCodeModule(module);
            source.setParams(this.prepareExternalParameters());
            this.engineFactory = new RulesEngineFactory((IOpenSourceCodeModule)source, serviceClass);
            MethodFilter methodFilter = module.getMethodFilter();
            if (methodFilter != null && (CollectionUtils.isNotEmpty(methodFilter.getExcludes()) || CollectionUtils.isNotEmpty(methodFilter.getIncludes()))) {
                String[] includes = new String[]{};
                String[] excludes = new String[]{};
                includes = methodFilter.getIncludes().toArray(includes);
                excludes = methodFilter.getExcludes().toArray(excludes);
                this.engineFactory.setInterfaceClassGenerator(new InterfaceClassGenerator(includes, excludes));
            }
            this.engineFactory.setExecutionMode(this.isExecutionMode());
            this.engineFactory.setDependencyManager(this.getDependencyManager());
        }
        return this.engineFactory;
    }

    @Override
    public Object instantiate(Class<?> rulesClass, boolean ignoreCompilationErrors) throws RulesInstantiationException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            Object object = this.getEngineFactory().newEngineInstance(ignoreCompilationErrors);
            return object;
        }
        catch (Exception e) {
            throw new RulesInstantiationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public void setServiceClass(Class<?> serviceClass) {
        super.setServiceClass(serviceClass);
        if (this.engineFactory != null) {
            this.engineFactory.setInterfaceClass(serviceClass);
        }
    }
}

