/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.instantiation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.ValidationServiceClassException;
import org.openl.rules.project.model.Module;
import org.openl.runtime.ASMProxyFactory;
import org.openl.runtime.ASMProxyHandler;

public abstract class AbstractServiceClassEnhancerInstantiationStrategy
implements RulesInstantiationStrategy {
    private final RulesInstantiationStrategy instantiationStrategy;
    private Class<?> serviceClass;

    public AbstractServiceClassEnhancerInstantiationStrategy(RulesInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    protected abstract Class<?> decorateServiceClass(Class<?> var1, ClassLoader var2);

    protected abstract Class<?> undecorateServiceClass(Class<?> var1, ClassLoader var2);

    protected abstract boolean validateServiceClass(Class<?> var1) throws ValidationServiceClassException;

    @Override
    public final Class<?> getServiceClass() {
        if (this.serviceClass == null) {
            try {
                Class<?> originalServiceClass = this.getOriginalInstantiationStrategy().getInstanceClass();
                this.serviceClass = this.decorateServiceClass(originalServiceClass, this.getClassLoader());
            }
            catch (Exception e) {
                throw new OpenlNotCheckedException("Failed to enhance a service class.", (Throwable)e);
            }
        }
        return this.serviceClass;
    }

    @Override
    public void setServiceClass(Class<?> serviceClass) {
        block5: {
            try {
                if (this.validateServiceClass(serviceClass)) {
                    this.serviceClass = serviceClass;
                    try {
                        Class<?> clazz = this.undecorateServiceClass(serviceClass, this.getClassLoader());
                        this.getOriginalInstantiationStrategy().setServiceClass(clazz);
                        break block5;
                    }
                    catch (Exception e) {
                        throw new OpenlNotCheckedException("Failed to set service class to instantiation strategy enhancer. Failed to get undecorated class.", (Throwable)e);
                    }
                }
                throw new OpenlNotCheckedException("Failed to set service class to instantiation strategy enhancer. Service class is not supported by this strategy.");
            }
            catch (ValidationServiceClassException e) {
                throw new OpenlNotCheckedException("Failed to set service class to instantiation strategy enhancer. Service class is not supported by this strategy.", (Throwable)e);
            }
        }
    }

    protected abstract ASMProxyHandler makeMethodHandler(Object var1) throws Exception;

    protected Class<?>[] getProxyInterfaces(Object originalInstance) throws Exception {
        ArrayList proxyInterfaces = new ArrayList();
        proxyInterfaces.add(this.getServiceClass());
        Class<?> originalServiceClass = this.getOriginalInstantiationStrategy().getInstanceClass();
        for (Class<?> interfaceClass : originalInstance.getClass().getInterfaces()) {
            if (interfaceClass.equals(originalServiceClass)) continue;
            proxyInterfaces.add(interfaceClass);
        }
        return proxyInterfaces.toArray(new Class[0]);
    }

    @Override
    public final Object instantiate(boolean ignoreCompilationErrors) throws RulesInstantiationException {
        try {
            Object originalInstance = this.getOriginalInstantiationStrategy().instantiate(ignoreCompilationErrors);
            return ASMProxyFactory.newProxyInstance((ClassLoader)this.getClassLoader(), (ASMProxyHandler)this.makeMethodHandler(originalInstance), (Class[])this.getProxyInterfaces(originalInstance));
        }
        catch (Exception e) {
            throw new RulesInstantiationException(e.getMessage(), e);
        }
    }

    @Override
    public final Object instantiate() throws RulesInstantiationException {
        return this.instantiate(false);
    }

    @Override
    public final boolean isServiceClassDefined() {
        return true;
    }

    @Override
    public void reset() {
        this.getOriginalInstantiationStrategy().reset();
        this.serviceClass = null;
    }

    @Override
    public ClassLoader getClassLoader() throws RulesInstantiationException {
        return this.getOriginalInstantiationStrategy().getInstanceClass().getClassLoader();
    }

    @Override
    public final Class<?> getInstanceClass() {
        return this.getServiceClass();
    }

    protected RulesInstantiationStrategy getOriginalInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    @Override
    public CompiledOpenClass compile() throws RulesInstantiationException {
        return this.getOriginalInstantiationStrategy().compile();
    }

    @Override
    public Class<?> getGeneratedRulesClass() throws RulesInstantiationException {
        return this.getOriginalInstantiationStrategy().getGeneratedRulesClass();
    }

    @Override
    public void forcedReset() {
        this.reset();
        this.getOriginalInstantiationStrategy().forcedReset();
    }

    @Override
    public Collection<Module> getModules() {
        return this.getOriginalInstantiationStrategy().getModules();
    }

    @Override
    public Map<String, Object> getExternalParameters() {
        return this.getOriginalInstantiationStrategy().getExternalParameters();
    }

    @Override
    public void setExternalParameters(Map<String, Object> parameters) {
        this.getOriginalInstantiationStrategy().setExternalParameters(parameters);
    }
}

