/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openl.dependency.DependencyType;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDependencyDescriptor;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.syntax.code.Dependency;
import org.openl.syntax.impl.IdentifierNode;

public final class ProjectExternalDependenciesHelper {
    private ProjectExternalDependenciesHelper() {
    }

    public static Map<String, Object> buildExternalParamsWithProjectDependencies(Map<String, Object> externalParams, Collection<Module> modules) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (externalParams != null) {
            parameters.putAll(externalParams);
        }
        if (modules == null) {
            parameters.put("external-dependencies", null);
            return parameters;
        }
        ArrayList<Dependency> externalDependencies = new ArrayList<Dependency>();
        for (Module module : modules) {
            ProjectDescriptor projectDescriptor = module.getProject();
            if (projectDescriptor.getDependencies() == null) continue;
            for (ProjectDependencyDescriptor dependency : projectDescriptor.getDependencies()) {
                if (!dependency.isAutoIncluded()) continue;
                externalDependencies.add(new Dependency(DependencyType.PROJECT, new IdentifierNode(null, null, dependency.getName(), null)));
            }
        }
        parameters.put("external-dependencies", externalDependencies);
        return parameters;
    }
}

