/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.openl.rules.cloner.Cloner;
import org.openl.rules.project.IProjectDescriptorSerializer;
import org.openl.rules.project.model.MethodFilter;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.WebstudioConfiguration;
import org.openl.rules.project.model.validation.ProjectDescriptorValidator;
import org.openl.rules.project.model.validation.ValidationException;
import org.openl.rules.project.xml.XmlProjectDescriptorSerializer;
import org.openl.util.FileUtils;
import org.openl.util.IOUtils;
import org.openl.util.OS;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class ProjectDescriptorManager {
    private IProjectDescriptorSerializer serializer = new XmlProjectDescriptorSerializer();
    private final ProjectDescriptorValidator validator = new ProjectDescriptorValidator();
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public IProjectDescriptorSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(IProjectDescriptorSerializer serializer) {
        this.serializer = serializer;
    }

    public ProjectDescriptor readDescriptor(InputStream source) throws JAXBException {
        return this.serializer.deserialize(source);
    }

    public ProjectDescriptor readDescriptor(Path file) throws IOException, ValidationException, JAXBException {
        ProjectDescriptor descriptor;
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            descriptor = this.readDescriptor(inputStream);
        }
        this.postProcess(descriptor, file);
        this.validator.validate(descriptor);
        return descriptor;
    }

    public ProjectDescriptor readDescriptor(String filename) throws IOException, ValidationException, JAXBException {
        File source = new File(filename);
        return this.readDescriptor(source.toPath());
    }

    public ProjectDescriptor readOriginalDescriptor(File filename) throws IOException, ValidationException, JAXBException {
        ProjectDescriptor descriptor;
        try (FileInputStream inputStream = new FileInputStream(filename);){
            descriptor = this.readDescriptor(inputStream);
        }
        this.validator.validate(descriptor);
        return descriptor;
    }

    public void writeDescriptor(ProjectDescriptor descriptor, OutputStream dest) throws IOException, ValidationException, JAXBException {
        this.validator.validate(descriptor);
        descriptor = (ProjectDescriptor)Cloner.clone((Object)descriptor);
        this.preProcess(descriptor);
        String serializedObject = this.serializer.serialize(descriptor);
        dest.write(serializedObject.getBytes(StandardCharsets.UTF_8));
    }

    public boolean isModuleWithWildcard(Module module) {
        PathEntry rulesRootPath = module.getRulesRootPath();
        if (rulesRootPath != null) {
            String path = rulesRootPath.getPath();
            return path.contains("*") || path.contains("?");
        }
        return false;
    }

    public boolean isCoveredByWildcardModule(ProjectDescriptor descriptor, Module otherModule) {
        PathEntry otherModuleRootPath = otherModule.getRulesRootPath();
        for (Module module : descriptor.getModules()) {
            if (!this.isModuleWithWildcard(module) || otherModuleRootPath == null) continue;
            String relativePath = otherModuleRootPath.getPath().replace("\\", "/");
            if (!this.pathMatcher.match(module.getRulesRootPath().getPath(), relativePath)) continue;
            return true;
        }
        return false;
    }

    public List<Module> getAllModulesMatchingPathPattern(final ProjectDescriptor descriptor, final Module module, final String pathPattern) throws IOException {
        final ArrayList<Module> modules = new ArrayList<Module>();
        final String ptrn = pathPattern.trim();
        final Path rootPath = descriptor.getProjectFolder();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relativePath = rootPath.relativize(file).toString().replace("\\", "/");
                if (ProjectDescriptorManager.this.isNotTemporaryFile(file) && ProjectDescriptorManager.this.pathMatcher.match(ptrn, relativePath)) {
                    Path modulePath = file.toAbsolutePath();
                    Module m = new Module();
                    m.setProject(descriptor);
                    m.setRulesRootPath(new PathEntry(relativePath));
                    m.setName(FileUtils.getBaseName((String)modulePath.toString()));
                    m.setMethodFilter(module.getMethodFilter());
                    if (module.getWebstudioConfiguration() != null) {
                        WebstudioConfiguration webstudioConfiguration = new WebstudioConfiguration();
                        webstudioConfiguration.setCompileThisModuleOnly(module.getWebstudioConfiguration().isCompileThisModuleOnly());
                        m.setWebstudioConfiguration(webstudioConfiguration);
                    }
                    m.setWildcardRulesRootPath(pathPattern);
                    m.setWildcardName(module.getName());
                    modules.add(m);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotTemporaryFile(Path file) throws IOException {
        if (file.getFileName().startsWith("~$")) {
            return false;
        }
        if (OS.isWindows() && Files.isHidden(file)) {
            OutputStream os = null;
            try {
                os = Files.newOutputStream(file, StandardOpenOption.APPEND);
                IOUtils.closeQuietly((AutoCloseable)os);
            }
            catch (Exception unused) {
                boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly(os);
            }
        }
        return true;
    }

    private boolean containsInProcessedModules(Collection<Module> modules, Module m, Path projectRoot) {
        Path targetModulePath = projectRoot.resolve(m.getRulesRootPath().getPath());
        for (Module module : modules) {
            Path modulePath = projectRoot.resolve(module.getRulesRootPath().getPath());
            if (!targetModulePath.equals(modulePath)) continue;
            return true;
        }
        return false;
    }

    private void processModulePathPatterns(ProjectDescriptor descriptor, Path projectRoot) throws IOException {
        List<Module> readModules = descriptor.getModules();
        ArrayList<Module> processedModules = new ArrayList<Module>(readModules.size());
        for (Module module : readModules) {
            if (this.isModuleWithWildcard(module)) continue;
            processedModules.add(module);
        }
        for (Module module : readModules) {
            if (!this.isModuleWithWildcard(module)) continue;
            ArrayList<Module> newModules = new ArrayList<Module>();
            List<Module> modules = this.getAllModulesMatchingPathPattern(descriptor, module, module.getRulesRootPath().getPath());
            for (Module m : modules) {
                if (this.containsInProcessedModules(processedModules, m, projectRoot)) continue;
                newModules.add(m);
            }
            processedModules.addAll(newModules);
        }
        descriptor.setModules(processedModules);
    }

    private void postProcess(ProjectDescriptor descriptor, Path projectDescriptorFile) throws IOException {
        Path projectRoot = projectDescriptorFile.getParent().toRealPath(new LinkOption[0]);
        descriptor.setProjectFolder(projectRoot);
        this.processModulePathPatterns(descriptor, projectRoot);
        for (Module module : descriptor.getModules()) {
            Path modulePath;
            module.setProject(descriptor);
            if (module.getMethodFilter() == null) {
                module.setMethodFilter(new MethodFilter());
            }
            if (module.getMethodFilter().getExcludes() == null) {
                module.getMethodFilter().setExcludes(new HashSet<String>());
            } else {
                module.getMethodFilter().getExcludes().removeAll(Arrays.asList("", null));
            }
            if (module.getMethodFilter().getIncludes() == null) {
                module.getMethodFilter().setIncludes(new HashSet<String>());
            } else {
                module.getMethodFilter().getIncludes().removeAll(Arrays.asList("", null));
            }
            if (!(modulePath = Paths.get(module.getRulesRootPath().getPath(), new String[0])).isAbsolute()) continue;
            modulePath = projectRoot.relativize(modulePath);
            PathEntry relativePath = new PathEntry(modulePath.toString());
            module.setRulesRootPath(relativePath);
        }
    }

    private void preProcess(ProjectDescriptor descriptor) {
        if (descriptor.getModules() == null || descriptor.getModules().isEmpty()) {
            return;
        }
        HashSet<String> wildcardPathSet = new HashSet<String>();
        Iterator<Module> itr = descriptor.getModules().iterator();
        while (itr.hasNext()) {
            Module module = itr.next();
            if (module.getWildcardRulesRootPath() == null || !wildcardPathSet.contains(module.getWildcardRulesRootPath())) {
                module.setProject(null);
                module.setProperties(null);
                if (module.getWildcardRulesRootPath() != null) {
                    wildcardPathSet.add(module.getWildcardRulesRootPath());
                    module.setRulesRootPath(new PathEntry(module.getWildcardRulesRootPath()));
                    module.setName(module.getWildcardName());
                } else {
                    PathEntry pathEntry = module.getRulesRootPath();
                    String path = pathEntry.getPath();
                    module.setRulesRootPath(new PathEntry(path.replaceAll("\\\\", "/")));
                }
                if (module.getMethodFilter() == null) continue;
                boolean f = true;
                if (module.getMethodFilter().getExcludes() != null && module.getMethodFilter().getExcludes().isEmpty()) {
                    module.getMethodFilter().setExcludes(null);
                    f = false;
                }
                if (module.getMethodFilter().getIncludes() == null || !module.getMethodFilter().getIncludes().isEmpty()) continue;
                if (f) {
                    module.getMethodFilter().setExcludes(null);
                    continue;
                }
                module.setMethodFilter(null);
                continue;
            }
            itr.remove();
        }
    }
}

