/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.validation.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.util.RefUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.CompiledOpenClass;
import org.openl.classloader.OpenLClassLoader;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.openapi.OpenAPIConfiguration;
import org.openl.rules.project.IRulesDeploySerializer;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RuntimeContextInstantiationStrategyEnhancer;
import org.openl.rules.project.instantiation.variation.VariationInstantiationStrategyEnhancer;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.model.RulesDeploy;
import org.openl.rules.project.resolving.ProjectResource;
import org.openl.rules.project.resolving.ProjectResourceLoader;
import org.openl.rules.project.validation.openapi.Context;
import org.openl.rules.project.validation.openapi.DifferentTypesException;
import org.openl.rules.project.validation.openapi.OpenAPIResolver;
import org.openl.rules.project.validation.openapi.OpenApiProjectValidatorMessagesUtils;
import org.openl.rules.project.xml.XmlRulesDeploySerializer;
import org.openl.rules.ruleservice.core.RuleServiceInstantiationFactoryHelper;
import org.openl.rules.ruleservice.core.RuleServiceOpenLServiceInstantiationHelper;
import org.openl.rules.ruleservice.core.interceptors.DynamicInterfaceAnnotationEnhancerHelper;
import org.openl.rules.ruleservice.publish.jaxrs.JAXRSOpenLServiceEnhancerHelper;
import org.openl.rules.ruleservice.publish.jaxrs.ParameterIndex;
import org.openl.rules.serialization.ProjectJacksonObjectMapperFactoryBean;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.types.java.JavaOpenField;
import org.openl.types.java.JavaOpenMethod;
import org.openl.util.ClassUtils;
import org.openl.util.CollectionUtils;
import org.openl.validation.ValidatedCompiledOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiProjectValidator {
    private static final String OPENAPI_JSON = "openapi.json";
    private static final String OPENAPI_YAML = "openapi.yaml";
    private static final String OPENAPI_YML = "openapi.yml";
    public static final String OPEN_API_VALIDATION_MSG_PREFIX = "OpenAPI Reconciliation: ";
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiProjectValidator.class);
    private static final String RULES_DEPLOY_XML = "rules-deploy.xml";
    private final IRulesDeploySerializer rulesDeploySerializer = new XmlRulesDeploySerializer();
    private boolean provideRuntimeContext = true;
    private boolean provideVariations;
    private RulesDeploy rulesDeploy;
    private ClassLoader classLoader;
    private static final List<String> ORDER_TYPES1 = Arrays.asList("Integer", "Long", "BigInteger", "BigDecimal");
    private static final List<String> ORDER_TYPES2 = Arrays.asList("Integer", "Long", "Float", "Double", "BigDecimal");

    private OpenAPI loadOpenAPI(Context context, ProjectDescriptor projectDescriptor, ValidatedCompiledOpenClass validatedCompiledOpenClass) {
        ProjectResource projectResource;
        String openApiFile;
        ProjectResourceLoader projectResourceLoader = new ProjectResourceLoader((CompiledOpenClass)validatedCompiledOpenClass);
        if (projectDescriptor.getOpenapi() != null && org.openl.util.StringUtils.isNotBlank((CharSequence)projectDescriptor.getOpenapi().getPath())) {
            openApiFile = projectDescriptor.getOpenapi().getPath();
            projectResource = this.loadProjectResource(projectResourceLoader, projectDescriptor, projectDescriptor.getOpenapi().getPath());
            if (projectResource == null) {
                validatedCompiledOpenClass.addMessage(OpenLMessagesUtils.newErrorMessage((String)String.format("OpenAPI Reconciliation: File '%s' is not found.", projectDescriptor.getOpenapi().getPath())));
            }
        } else {
            openApiFile = OPENAPI_JSON;
            projectResource = this.loadProjectResource(projectResourceLoader, projectDescriptor, OPENAPI_JSON);
            if (projectResource == null) {
                openApiFile = OPENAPI_YAML;
                projectResource = this.loadProjectResource(projectResourceLoader, projectDescriptor, OPENAPI_YAML);
            }
            if (projectResource == null) {
                openApiFile = OPENAPI_YML;
                projectResource = this.loadProjectResource(projectResourceLoader, projectDescriptor, OPENAPI_YML);
            }
        }
        if (projectResource != null) {
            if (projectResource.getFile().endsWith(".yaml") || projectResource.getFile().endsWith(".yml")) {
                context.setYaml(true);
            }
            OpenAPIParser openApiParser = new OpenAPIParser();
            ParseOptions options = new ParseOptions();
            options.setResolve(true);
            OpenAPI openAPI = openApiParser.readLocation(projectResource.getUrl().toString(), null, options).getOpenAPI();
            if (openAPI == null) {
                validatedCompiledOpenClass.addMessage(OpenLMessagesUtils.newErrorMessage((String)String.format("OpenAPI Reconciliation: Failed to read file '%s'.", openApiFile)));
            }
            return openAPI;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledOpenClass validate(ProjectDescriptor projectDescriptor, RulesInstantiationStrategy rulesInstantiationStrategy) throws RulesInstantiationException {
        Context context = new Context();
        CompiledOpenClass compiledOpenClass = rulesInstantiationStrategy.compile();
        ValidatedCompiledOpenClass validatedCompiledOpenClass = ValidatedCompiledOpenClass.instanceOf((CompiledOpenClass)compiledOpenClass);
        OpenAPI expectedOpenAPI = this.loadOpenAPI(context, projectDescriptor, validatedCompiledOpenClass);
        if (expectedOpenAPI == null) {
            return validatedCompiledOpenClass;
        }
        context.setExpectedOpenAPI(expectedOpenAPI);
        context.setExpectedOpenAPIResolver(new OpenAPIResolver(context, expectedOpenAPI));
        context.setValidatedCompiledOpenClass(validatedCompiledOpenClass);
        context.setOpenClass(validatedCompiledOpenClass.getOpenClassWithErrors());
        ClassLoader serviceClassLoader = this.resolveServiceClassLoader(rulesInstantiationStrategy);
        context.setServiceClassLoader(serviceClassLoader);
        RulesDeploy rulesDeploy = this.getRulesDeploy(projectDescriptor, compiledOpenClass);
        context.setRulesDeploy(rulesDeploy);
        boolean provideRuntimeContext = rulesDeploy == null && this.isProvideRuntimeContext() || rulesDeploy != null && Boolean.TRUE.equals(rulesDeploy.isProvideRuntimeContext());
        boolean provideVariations = rulesDeploy == null && this.isProvideVariations() || rulesDeploy != null && Boolean.TRUE.equals(rulesDeploy.isProvideVariations());
        context.setProvideRuntimeContext(provideRuntimeContext);
        context.setProvideVariations(provideVariations);
        rulesInstantiationStrategy = this.enhanceRulesInstantiationStrategy(rulesInstantiationStrategy, provideRuntimeContext, provideVariations);
        context.setTargetService(rulesInstantiationStrategy.instantiate(true));
        ObjectMapper objectMapper = this.createObjectMapper(context);
        context.setObjectMapper(objectMapper);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> enhancedServiceClass;
            Class<?> serviceClass;
            Thread.currentThread().setContextClassLoader(serviceClassLoader);
            try {
                serviceClass = this.resolveInterface(rulesDeploy, rulesInstantiationStrategy, validatedCompiledOpenClass, provideRuntimeContext, provideVariations);
            }
            catch (Exception e) {
                validatedCompiledOpenClass.addMessage(OpenLMessagesUtils.newErrorMessage((String)(OPEN_API_VALIDATION_MSG_PREFIX + String.format("Failed to build an interface for the project.%s", org.openl.util.StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""))));
                ValidatedCompiledOpenClass validatedCompiledOpenClass2 = validatedCompiledOpenClass;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                return validatedCompiledOpenClass2;
            }
            try {
                enhancedServiceClass = this.enhanceWithJAXRS(context, serviceClass, serviceClassLoader);
            }
            catch (Exception e) {
                validatedCompiledOpenClass.addMessage(OpenLMessagesUtils.newErrorMessage((String)(OPEN_API_VALIDATION_MSG_PREFIX + String.format("Failed to build an interface for the project.%s", org.openl.util.StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""))));
                ValidatedCompiledOpenClass validatedCompiledOpenClass3 = validatedCompiledOpenClass;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                return validatedCompiledOpenClass3;
            }
            context.setServiceClass(enhancedServiceClass);
            try {
                Map methodMap = JAXRSOpenLServiceEnhancerHelper.buildMethodMap(serviceClass, enhancedServiceClass);
                context.setMethodMap(methodMap);
                if (methodMap.isEmpty()) {
                    validatedCompiledOpenClass.addMessage(OpenLMessagesUtils.newWarnMessage((String)"OpenAPI Reconciliation: There are no suitable methods to check. Check the provided rules, annotation template class, and included/excluded methods in module settings."));
                }
            }
            catch (Exception e) {
                validatedCompiledOpenClass.addMessage(OpenLMessagesUtils.newErrorMessage((String)"OpenAPI Reconciliation: Failed to build an interface for the project."));
                ValidatedCompiledOpenClass validatedCompiledOpenClass4 = validatedCompiledOpenClass;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                return validatedCompiledOpenClass4;
            }
            OpenAPI actualOpenAPI = OpenAPIConfiguration.generateOpenAPI(enhancedServiceClass, (ObjectMapper)objectMapper);
            context.setActualOpenAPI(actualOpenAPI);
            context.setActualOpenAPIResolver(new OpenAPIResolver(context, actualOpenAPI));
            this.validateOpenAPI(context);
            ValidatedCompiledOpenClass validatedCompiledOpenClass5 = validatedCompiledOpenClass;
            return validatedCompiledOpenClass5;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private ObjectMapper createObjectMapper(Context context) {
        ClassLoader classLoader = context.getValidatedCompiledOpenClass().getClassLoader();
        ProjectJacksonObjectMapperFactoryBean objectMapperFactoryBean = new ProjectJacksonObjectMapperFactoryBean();
        objectMapperFactoryBean.setClassLoader(classLoader);
        objectMapperFactoryBean.setRulesDeploy(context.getRulesDeploy());
        objectMapperFactoryBean.setXlsModuleOpenClass((XlsModuleOpenClass)context.getOpenClass());
        objectMapperFactoryBean.setClassLoader(context.getServiceClassLoader());
        try {
            return objectMapperFactoryBean.createJacksonObjectMapper();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create an object mapper", e);
        }
    }

    private Class<?> enhanceWithJAXRS(Context context, Class<?> originalClass, ClassLoader classLoader) throws Exception {
        return JAXRSOpenLServiceEnhancerHelper.enhanceInterface(originalClass, (Object)context.getTargetService(), (ClassLoader)classLoader, (boolean)context.isProvideRuntimeContext(), (boolean)context.isProvideVariations());
    }

    private Pair<String, PathItem> findPathItem(Paths paths, String path) {
        if (paths != null) {
            path = path.replaceAll("\\{[^}]*}", "{}");
            for (Map.Entry entry : paths.entrySet()) {
                String k = (String)entry.getKey();
                if (!Objects.equals(path, k = k.replaceAll("\\{[^}]*}", "{}"))) continue;
                return Pair.of((Object)((String)entry.getKey()), (Object)((PathItem)entry.getValue()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOpenAPI(Context context) {
        if (context.getActualOpenAPI().getPaths() != null) {
            for (Map.Entry entry : context.getActualOpenAPI().getPaths().entrySet()) {
                try {
                    context.setActualPath((String)entry.getKey());
                    context.setActualPathItem((PathItem)entry.getValue());
                    Pair<String, PathItem> expectedPath = this.findPathItem(context.getExpectedOpenAPI().getPaths(), (String)entry.getKey());
                    if (expectedPath != null && expectedPath.getRight() != null) {
                        context.setExpectedPath((String)expectedPath.getKey());
                        context.setExpectedPathItem((PathItem)expectedPath.getValue());
                    } else {
                        context.setExpectedPath(null);
                        context.setExpectedPathItem(null);
                    }
                    this.validatePathItem(context);
                }
                finally {
                    context.setOpenMethod(null);
                    context.setMethod(null);
                    context.setActualPathItem(null);
                    context.setExpectedPathItem(null);
                    context.setExpectedPath(null);
                    context.setActualPath(null);
                }
            }
        }
        if (context.getExpectedOpenAPI().getPaths() != null) {
            for (Map.Entry entry : context.getExpectedOpenAPI().getPaths().entrySet()) {
                PathItem expectedPathItem = (PathItem)entry.getValue();
                try {
                    Pair<String, PathItem> actualPath;
                    context.setExpectedPath((String)entry.getKey());
                    context.setExpectedPathItem(expectedPathItem);
                    if (context.getActualOpenAPI().getPaths() == null || (actualPath = this.findPathItem(context.getActualOpenAPI().getPaths(), (String)entry.getKey())) != null) continue;
                    OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected method is not found for path '%s'.", context.getExpectedPath()));
                }
                finally {
                    context.setExpectedPath(null);
                    context.setExpectedPathItem(null);
                }
            }
        }
    }

    private IOpenMethod getRulesMethod(Context context, Method method) {
        Optional<IOpenField> foundOpenField;
        IOpenMethod openMethod;
        IOpenMember openMember = RuleServiceOpenLServiceInstantiationHelper.getOpenMember((Method)context.getMethodMap().get(method), (Object)context.getTargetService());
        IOpenMethod iOpenMethod = openMethod = openMember instanceof IOpenMethod ? (IOpenMethod)openMember : null;
        if (openMethod != null) {
            return openMethod;
        }
        if (method.getParameterCount() == 0 && method.getName().startsWith("get") && (foundOpenField = context.getOpenClass().getFields().stream().filter(e -> method.getName().equals(ClassUtils.getter((String)e.getName()))).findFirst()).isPresent()) {
            final IOpenField openField = foundOpenField.get();
            return new JavaOpenMethod(method){

                public IOpenClass getType() {
                    return openField.getType();
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndValidateOperation(Context context, Function<PathItem, Operation> func, Class<? extends Annotation> operationAnnotation) {
        Method method = this.findMethodByPathAndMethod(context.getServiceClass(), context.getActualPath(), operationAnnotation);
        PathItem expectedPathItem = context.getExpectedPathItem();
        String expectedPath = context.getExpectedPath();
        if (method == null) {
            if (expectedPath != null && expectedPathItem != null) {
                PathItem actualPathItem = context.getActualPathItem();
                Operation actualOperation = func.apply(actualPathItem);
                Operation expectedOperation = func.apply(expectedPathItem);
                if (expectedOperation != null && actualOperation == null) {
                    OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected operation '%s' is not found for path '%s'.", operationAnnotation.getSimpleName(), context.getActualPath()));
                }
            }
        } else {
            IOpenMethod openMethod = this.getRulesMethod(context, method);
            if (expectedPath == null || context.getExpectedPathItem() == null) {
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected method '%s' is found for path '%s'.", openMethod != null ? openMethod.getName() : method.getName(), context.getActualPath()));
            } else {
                context.setMethod(method);
                context.setOpenMethod(openMethod);
                PathItem actualPathItem = context.getActualPathItem();
                Operation expectedOperation = func.apply(expectedPathItem);
                Operation actualOperation = func.apply(actualPathItem);
                if (expectedOperation != null || actualOperation != null) {
                    if (expectedOperation == null) {
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected operation '%s' is found for path '%s'.", operationAnnotation.getSimpleName(), context.getActualPath()));
                    } else {
                        try {
                            context.setExpectedOperation(expectedOperation);
                            context.setActualOperation(actualOperation);
                            context.setOperationType(operationAnnotation.getSimpleName());
                            this.validateOperation(context);
                        }
                        finally {
                            context.setExpectedOperation(null);
                            context.setActualOperation(null);
                            context.setOperationType(null);
                        }
                    }
                }
            }
        }
    }

    private String normalizePath(String path) {
        Object s = path;
        if (s == null) {
            s = "/";
        }
        s = ((String)s).replaceAll("\\{[^}]*}", "{}");
        while (!Objects.equals(s, ((String)s).replaceAll("//", "/"))) {
            s = ((String)s).replaceAll("//", "/");
        }
        if (((String)s).length() == 0 || !((String)s).startsWith("/")) {
            s = "/" + (String)s;
        }
        if (((String)s).endsWith("/")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        return s;
    }

    private Method findMethodByPathAndMethod(Class<?> serviceClass, String path, Class<?> operationAnnotation) {
        path = this.normalizePath(path);
        Path classPathAnnotation = serviceClass.getAnnotation(Path.class);
        for (Method method : serviceClass.getMethods()) {
            Annotation[] declaredAnnotations;
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation == null) continue;
            Object methodPath = (classPathAnnotation != null ? classPathAnnotation.value() : "") + pathAnnotation.value();
            if (!Objects.equals(methodPath = this.normalizePath((String)methodPath), path)) continue;
            if (operationAnnotation == null) {
                return method;
            }
            for (Annotation declaredAnnotation : declaredAnnotations = method.getDeclaredAnnotations()) {
                if (!declaredAnnotation.annotationType().equals(operationAnnotation)) continue;
                return method;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOperation(Context context) {
        MediaType actualMediaType;
        MediaType expectedMediaType;
        Operation expectedOperation = context.getExpectedOperation();
        Operation actualOperation = context.getActualOperation();
        RequestBody actualRequestBody = context.getActualOpenAPIResolver().resolve(actualOperation.getRequestBody(), RequestBody::get$ref);
        RequestBody expectedRequestBody = context.getExpectedOpenAPIResolver().resolve(expectedOperation.getRequestBody(), RequestBody::get$ref);
        if (actualRequestBody != null || expectedRequestBody != null) {
            if (actualRequestBody == null) {
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected request body is not found for operation '%s' and path '%s'.", context.getOperationType(), context.getActualPath()));
            } else if (expectedRequestBody == null) {
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected request body is found for operation '%s' and path '%s'.", context.getOperationType(), context.getActualPath()));
            } else {
                Content actualRequestBodyContent = actualRequestBody.getContent();
                Content expectedRequestBodyContent = expectedRequestBody.getContent();
                if (actualRequestBodyContent != null || expectedRequestBodyContent != null) {
                    if (actualRequestBodyContent == null) {
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected request body content is not found for operation '%s' and path '%s'.", context.getOperationType(), context.getActualPath()));
                    } else if (expectedRequestBodyContent == null) {
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected request body content is found for operation '%s' and path '%s'.", context.getOperationType(), context.getActualPath()));
                    } else {
                        for (Object entry : expectedRequestBodyContent.entrySet()) {
                            expectedMediaType = (MediaType)entry.getValue();
                            actualMediaType = (MediaType)actualRequestBodyContent.get(entry.getKey());
                            if (expectedMediaType == null && actualMediaType == null) continue;
                            if (expectedMediaType == null) {
                                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected operation '%s' with media type '%s' is found for path '%s'.", context.getOperationType(), entry.getKey(), context.getActualPath()));
                                continue;
                            }
                            if (actualMediaType == null) {
                                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected operation '%s' with media type '%s' is not found for path '%s'.", context.getOperationType(), entry.getKey(), context.getActualPath()));
                                continue;
                            }
                            try {
                                context.setActualMediaType(actualMediaType);
                                context.setExpectedMediaType(expectedMediaType);
                                context.setMediaType((String)entry.getKey());
                                this.validateRequestBodyInput(context);
                            }
                            finally {
                                context.setActualMediaType(null);
                                context.setExpectedMediaType(null);
                                context.setMediaType(null);
                            }
                        }
                        for (Object entry : actualRequestBodyContent.entrySet()) {
                            expectedMediaType = (MediaType)expectedRequestBodyContent.get(entry.getKey());
                            if (expectedMediaType != null) continue;
                            OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected operation '%s' with media type '%s' is found for path '%s'.", context.getOperationType(), entry.getKey(), context.getActualPath()));
                        }
                    }
                }
            }
        }
        if (actualOperation.getParameters() != null) {
            String s;
            int index;
            boolean found;
            IOpenMethod openMethod = context.getOpenMethod();
            Method method = context.getMethodMap().get(context.getMethod());
            String methodName = openMethod != null ? openMethod.getName() : method.getName();
            for (io.swagger.v3.oas.models.parameters.Parameter parameter : actualOperation.getParameters()) {
                io.swagger.v3.oas.models.parameters.Parameter actualParameter = context.getActualOpenAPIResolver().resolve(parameter, io.swagger.v3.oas.models.parameters.Parameter::get$ref);
                if ("header".equalsIgnoreCase(actualParameter.getIn()) && !Boolean.TRUE.equals(actualParameter.getRequired())) continue;
                found = false;
                if (!CollectionUtils.isEmpty((Collection)expectedOperation.getParameters())) {
                    for (io.swagger.v3.oas.models.parameters.Parameter p : expectedOperation.getParameters()) {
                        io.swagger.v3.oas.models.parameters.Parameter expectedParameter = context.getExpectedOpenAPIResolver().resolve(p, io.swagger.v3.oas.models.parameters.Parameter::get$ref);
                        if (!Objects.equals(actualParameter.getIn(), expectedParameter.getIn())) continue;
                        index = this.findParameterIndex(context.getMethod(), actualParameter.getIn(), actualParameter.getName());
                        if ("path".equalsIgnoreCase(actualParameter.getIn())) {
                            s = this.extractPathParameterName(context.getExpectedPath(), index);
                            if (s == null || !Objects.equals(s, expectedParameter.getName())) continue;
                            found = true;
                            this.validateParameter(context, openMethod, methodName, actualParameter, expectedParameter, index);
                            break;
                        }
                        if (!Objects.equals(actualParameter.getName(), expectedParameter.getName())) continue;
                        found = true;
                        this.validateParameter(context, openMethod, methodName, actualParameter, expectedParameter, index);
                        break;
                    }
                }
                if (found) continue;
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected %s parameter '%s' is found in method '%s'%s.", actualParameter.getIn(), actualParameter.getName(), methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath())));
            }
            if (expectedOperation.getParameters() != null) {
                for (io.swagger.v3.oas.models.parameters.Parameter parameter : expectedOperation.getParameters()) {
                    io.swagger.v3.oas.models.parameters.Parameter expectedParameter = context.getExpectedOpenAPIResolver().resolve(parameter, io.swagger.v3.oas.models.parameters.Parameter::get$ref);
                    found = false;
                    if (!CollectionUtils.isEmpty((Collection)actualOperation.getParameters())) {
                        for (io.swagger.v3.oas.models.parameters.Parameter p : actualOperation.getParameters()) {
                            io.swagger.v3.oas.models.parameters.Parameter actualParameter = context.getActualOpenAPIResolver().resolve(p, io.swagger.v3.oas.models.parameters.Parameter::get$ref);
                            if (!Objects.equals(actualParameter.getIn(), expectedParameter.getIn())) continue;
                            if ("path".equalsIgnoreCase(actualParameter.getIn())) {
                                index = this.findParameterIndex(context.getMethod(), actualParameter.getIn(), actualParameter.getName());
                                s = this.extractPathParameterName(context.getExpectedPath(), index);
                                if (s == null || !Objects.equals(s, expectedParameter.getName())) continue;
                                found = true;
                                break;
                            }
                            if (!Objects.equals(actualParameter.getName(), expectedParameter.getName())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected %s parameter '%s' is not found in method '%s'%s.", expectedParameter.getIn(), expectedParameter.getName(), methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath())));
                }
            }
        }
        if (expectedOperation.getResponses() != null || actualOperation.getResponses() != null) {
            if (expectedOperation.getResponses() == null) {
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected response is found in operation '%s' for path '%s'.", context.getOperationType(), context.getActualPath()));
            } else if (actualOperation.getResponses() == null) {
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected response is not found in operation '%s' for path '%s'.", context.getOperationType(), context.getActualPath()));
            } else {
                ApiResponse actualApiResponse;
                ApiResponse expectedApiResponse = (ApiResponse)expectedOperation.getResponses().get((Object)"200");
                if (expectedApiResponse == null) {
                    expectedApiResponse = expectedOperation.getResponses().getDefault();
                }
                if ((actualApiResponse = (ApiResponse)actualOperation.getResponses().get((Object)"200")) == null) {
                    actualApiResponse = actualOperation.getResponses().getDefault();
                }
                expectedApiResponse = context.getExpectedOpenAPIResolver().resolve(expectedApiResponse, ApiResponse::get$ref);
                actualApiResponse = context.getActualOpenAPIResolver().resolve(actualApiResponse, ApiResponse::get$ref);
                if (expectedApiResponse != null || actualApiResponse != null) {
                    if (expectedApiResponse == null) {
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected response is found in operation '%s' for path '%s'.", context.getOperationType(), context.getActualPath()));
                    } else if (actualApiResponse == null) {
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected response is not found in operation '%s' for path '%s'.", context.getOperationType(), context.getActualPath()));
                    } else {
                        if (expectedApiResponse.getContent() != null) {
                            for (Object entry : expectedApiResponse.getContent().entrySet()) {
                                expectedMediaType = (MediaType)entry.getValue();
                                actualMediaType = (MediaType)actualApiResponse.getContent().get(entry.getKey());
                                if (expectedMediaType == null && actualMediaType == null) continue;
                                if (actualMediaType == null) {
                                    OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected response is not found in operation '%s' with media type '%s' for path '%s'.", context.getOperationType(), entry.getKey(), context.getActualPath()));
                                    continue;
                                }
                                if (expectedMediaType == null) {
                                    OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected response is found in operation '%s' with media type '%s' for path '%s'.", context.getOperationType(), entry.getKey(), context.getActualPath()));
                                    continue;
                                }
                                try {
                                    context.setActualMediaType(actualMediaType);
                                    context.setExpectedMediaType(expectedMediaType);
                                    context.setMediaType((String)entry.getKey());
                                    this.validateResponse(context);
                                }
                                finally {
                                    context.setActualMediaType(null);
                                    context.setExpectedMediaType(null);
                                    context.setMediaType(null);
                                }
                            }
                        }
                        if (actualApiResponse.getContent() != null) {
                            for (Object entry : actualApiResponse.getContent().entrySet()) {
                                expectedMediaType = expectedApiResponse.getContent() != null ? (MediaType)expectedApiResponse.getContent().get(entry.getKey()) : null;
                                if (expectedMediaType != null) continue;
                                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected response is found in operation '%s' with media type '%s' for path '%s'.", context.getOperationType(), entry.getKey(), context.getActualPath()));
                            }
                        }
                    }
                }
            }
        }
        if (expectedOperation.getCallbacks() != null && !expectedOperation.getCallbacks().isEmpty()) {
            OpenApiProjectValidatorMessagesUtils.addMethodWarning(context, String.format("OpenAPI Reconciliation: Out-of band callback in operation '%s' for path '%s' is ignored. Callbacks are not supported.", context.getOperationType(), context.getActualPath()));
        }
    }

    private String extractPathParameterName(String path, int index) {
        String s = path;
        try {
            for (int i = 0; i < index; ++i) {
                s = s.substring(s.indexOf("}") + 1);
            }
            s = s.substring(s.indexOf("{") + 1);
            s = s.substring(0, s.indexOf("}"));
            return s;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private void validateParameter(Context context, IOpenMethod openMethod, String methodName, io.swagger.v3.oas.models.parameters.Parameter actualParameter, io.swagger.v3.oas.models.parameters.Parameter expectedParameter, int index) {
        JavaOpenClass parameterType = JavaOpenClass.getOpenClass(context.getMethod().getParameterTypes()[index]);
        String parameterName = actualParameter.getName();
        if (openMethod != null) {
            int i = index;
            if (context.isProvideRuntimeContext()) {
                --i;
            }
            if (i >= 0 && i < openMethod.getSignature().getNumberOfParameters()) {
                parameterType = openMethod.getSignature().getParameterType(i);
                parameterName = openMethod.getSignature().getParameterName(i);
            }
        }
        context.setTypeValidationInProgress(true);
        try {
            this.validateType(context, actualParameter.getSchema(), expectedParameter.getSchema(), (IOpenClass)parameterType, new HashSet<KeyBySchemasRef>(), new HashSet<KeyByFieldType>());
        }
        catch (DifferentTypesException e) {
            OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Type '%s' of parameter '%s' in method '%s'%s must be compatible with OpenAPI %s.", parameterType.getDisplayName(1), parameterName, methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath()), this.buildOpenApiTypeMessagePart(expectedParameter.getSchema())));
        }
    }

    private int findParameterIndex(Method method, String in, String name) {
        int index;
        if ("path".equalsIgnoreCase(in)) {
            index = this.getIndex(method, PathParam.class, PathParam::value, name);
        } else if ("query".equalsIgnoreCase(in)) {
            index = this.getIndex(method, QueryParam.class, QueryParam::value, name);
        } else if ("header".equalsIgnoreCase(in)) {
            index = this.getIndex(method, HeaderParam.class, HeaderParam::value, name);
        } else if ("cookie".equalsIgnoreCase(in)) {
            index = this.getIndex(method, CookieParam.class, CookieParam::value, name);
        } else {
            throw new IllegalStateException("Parameter type is not resolved");
        }
        if (index >= 0) {
            return index;
        }
        throw new IllegalStateException("Failed to resolve parameter index");
    }

    private <T extends Annotation> int getIndex(Method method, Class<T> annotationClass, Function<T, String> f, String name) {
        int index = 0;
        for (Parameter parameter : method.getParameters()) {
            T annotation = parameter.getAnnotation(annotationClass);
            if (annotation != null && Objects.equals(f.apply(annotation), name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateResponse(Context context) {
        MediaType expectedMediaType = context.getExpectedMediaType();
        MediaType actualMediaType = context.getActualMediaType();
        IOpenMethod openMethod = context.getOpenMethod();
        if (expectedMediaType.getSchema() == null) {
            OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Schema definition for the response in operation '%s' with media type '%s' for path '%s' is not found.", context.getOperationType(), context.getMediaType(), context.getActualPath()));
            return;
        }
        Method method = context.getMethodMap().get(context.getMethod());
        JavaOpenClass returnType = openMethod != null && method.getReturnType() == openMethod.getType().getInstanceClass() ? openMethod.getType() : JavaOpenClass.getOpenClass(method.getReturnType());
        try {
            context.setTypeValidationInProgress(true);
            try {
                this.validateType(context, actualMediaType.getSchema(), expectedMediaType.getSchema(), (IOpenClass)returnType, new HashSet<KeyBySchemasRef>(), new HashSet<KeyByFieldType>());
            }
            catch (DifferentTypesException e) {
                String methodName = openMethod != null ? openMethod.getName() : method.getName();
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Return type of method '%s'%s must be compatible with OpenAPI %s.", methodName, this.getMethodForPathStringPart(methodName, context.getActualPath()), this.buildOpenApiTypeMessagePart(expectedMediaType.getSchema())));
            }
        }
        finally {
            context.setTypeValidationInProgress(false);
        }
    }

    private String buildOpenApiTypeMessagePart(Schema schema) {
        String s = this.resolveSimplifiedName(schema);
        if (s == null) {
            return "schema";
        }
        int dim = 0;
        StringBuilder arraySuffix = new StringBuilder();
        while (s.endsWith("[]")) {
            s = s.substring(0, s.length() - 2);
            arraySuffix.append("[]");
            ++dim;
            schema = ((ArraySchema)schema).getItems();
        }
        String prefix = "";
        if (dim > 0) {
            prefix = String.format("array%s of ", arraySuffix.toString());
        }
        String type = this.resolveType(schema);
        String format = schema.getFormat();
        return (dim == 0 && this.isSimpleJavaType(s) ? "type" : "schema") + " '" + prefix + type + (String)(format != null ? "(" + format + ")" : "") + "'";
    }

    private String getMethodForPathStringPart(String methodName, String path) {
        String pathPart = "";
        if (!path.equals("/" + methodName)) {
            pathPart = String.format(" for path '%s'", path);
        }
        return pathPart;
    }

    private String getMethodRelatedPathStringPart(String methodName, String path) {
        String pathPart = "";
        if (!path.equals("/" + methodName)) {
            pathPart = String.format(" related to path '%s'", path);
        }
        return pathPart;
    }

    private void validateRequestBodyInput(Context context) {
        block10: {
            String methodName;
            Map<String, Schema> allPropertiesOfExpectedSchema;
            Map<String, Schema> allPropertiesOfActualSchema;
            Method method;
            Schema actualSchema;
            Schema expectedSchema;
            block11: {
                IOpenMethod openMethod;
                block9: {
                    MediaType expectedMediaType = context.getExpectedMediaType();
                    MediaType actualMediaType = context.getActualMediaType();
                    openMethod = context.getOpenMethod();
                    expectedSchema = context.getExpectedOpenAPIResolver().resolve(expectedMediaType.getSchema(), Schema::get$ref);
                    actualSchema = context.getActualOpenAPIResolver().resolve(actualMediaType.getSchema(), Schema::get$ref);
                    if (expectedSchema == null) {
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Failed to resolve a schema definition for operation '%s' with media type '%s' for path '%s'.", context.getOperationType(), context.getMediaType(), context.getActualPath()));
                        return;
                    }
                    method = context.getMethodMap().get(context.getMethod());
                    allPropertiesOfActualSchema = context.getActualOpenAPIResolver().resolveAllProperties(actualSchema);
                    allPropertiesOfExpectedSchema = context.getExpectedOpenAPIResolver().resolveAllProperties(expectedSchema);
                    String string = methodName = openMethod != null ? openMethod.getName() : method.getName();
                    if (method.getParameterCount() <= 1 || context.getMethod().getParameterCount() != 1) break block9;
                    for (Map.Entry<String, Schema> entry : allPropertiesOfExpectedSchema.entrySet()) {
                        Schema actualParameterSchema = allPropertiesOfActualSchema.get(entry.getKey());
                        if (actualParameterSchema != null) {
                            Pair<String, IOpenClass> parameter = this.findParameter(context, entry.getKey());
                            this.validateMethodParameter(context, methodName, entry.getKey(), (String)parameter.getLeft(), (IOpenClass)parameter.getRight(), actualParameterSchema, entry.getValue());
                            continue;
                        }
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected parameter for request body schema property '%s' is not found in method '%s'%s.", entry.getKey(), methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath())));
                    }
                    for (Map.Entry<String, Schema> entry : allPropertiesOfActualSchema.entrySet()) {
                        if (allPropertiesOfExpectedSchema.get(entry.getKey()) != null) continue;
                        Pair<String, IOpenClass> parameter = this.findParameter(context, entry.getKey());
                        OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected parameter '%s' is found in method '%s'%s.", parameter.getLeft(), methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath())));
                    }
                    break block10;
                }
                if (method.getParameterCount() != 1 || !method.getParameters()[0].isAnnotationPresent(BeanParam.class)) break block11;
                this.validateMethodParameter(context, methodName, null, openMethod != null ? openMethod.getSignature().getParameterName(0) : method.getParameters()[0].getName(), (IOpenClass)(openMethod != null ? openMethod.getSignature().getParameterType(0) : JavaOpenClass.getOpenClass(method.getParameterTypes()[0])), actualSchema, expectedSchema);
                break block10;
            }
            if (method.getParameterCount() <= 0) break block10;
            int i = 0;
            for (Parameter parameter1 : method.getParameters()) {
                if (!this.isJAXRSParameterAnnotationPresented(parameter1)) {
                    Pair<String, IOpenClass> parameter = this.findParameter(context, method, i);
                    this.validateMethodParameter(context, methodName, null, (String)parameter.getLeft(), (IOpenClass)parameter.getRight(), actualSchema, expectedSchema);
                    return;
                }
                ++i;
            }
            for (i = 0; i < method.getParameterCount(); ++i) {
                String name = this.getJAXRSFormParamAnnotationValue(method.getParameters()[i]);
                if (name == null) continue;
                Schema actualParameterSchema = allPropertiesOfActualSchema.get(name);
                Schema expectedParameterSchema = allPropertiesOfExpectedSchema.get(name);
                if (expectedParameterSchema != null) {
                    Pair<String, IOpenClass> parameter = this.findParameter(context, method, i);
                    this.validateMethodParameter(context, methodName, name, (String)parameter.getLeft(), (IOpenClass)parameter.getRight(), actualParameterSchema, expectedParameterSchema);
                    continue;
                }
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected parameter for request body schema property '%s' is found in method '%s'%s.", name, methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath())));
            }
            for (Map.Entry<String, Schema> entry : allPropertiesOfExpectedSchema.entrySet()) {
                if (allPropertiesOfActualSchema.get(entry.getKey()) != null) continue;
                OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Expected parameter for request body schema property '%s' is not found in method '%s'%s.", entry.getKey(), methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath())));
            }
        }
    }

    private Pair<String, IOpenClass> findParameter(Context context, Method method, int i) {
        int index = i;
        if (context.isProvideRuntimeContext()) {
            --index;
        }
        String parameterName = method.getParameters()[i].getName();
        JavaOpenClass parameterType = JavaOpenClass.getOpenClass(method.getParameterTypes()[i]);
        if (context.getOpenMethod() != null && index >= 0 && index < context.getOpenMethod().getSignature().getNumberOfParameters()) {
            parameterName = context.getOpenMethod().getSignature().getParameterName(index);
            parameterType = context.getOpenMethod().getSignature().getParameterType(index);
        }
        return Pair.of((Object)parameterName, (Object)parameterType);
    }

    private Pair<String, IOpenClass> findParameter(Context context, String propertyName) {
        JavaOpenField javaOpenField = (JavaOpenField)context.getOpenClassPropertiesResolver().findFieldByPropertyName((IOpenClass)JavaOpenClass.getOpenClass(context.getMethod().getParameterTypes()[0]), propertyName);
        String parameterName = javaOpenField.getName();
        IOpenClass parameterType = javaOpenField.getType();
        if (context.getOpenMethod() != null) {
            ParameterIndex parameterIndex = javaOpenField.getJavaField().getAnnotation(ParameterIndex.class);
            int index = parameterIndex.value();
            if (context.isProvideRuntimeContext()) {
                --index;
            }
            if (index >= 0 && index < context.getOpenMethod().getSignature().getNumberOfParameters()) {
                parameterName = context.getOpenMethod().getSignature().getParameterName(index);
                parameterType = context.getOpenMethod().getSignature().getParameterType(index);
            }
        }
        return Pair.of((Object)parameterName, (Object)parameterType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateMethodParameter(Context context, String methodName, String parameterPropertyName, String parameterName, IOpenClass parameterType, Schema<?> actualParameterSchema, Schema<?> expectedParameterSchema) {
        if (expectedParameterSchema == null) {
            OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Unexpected parameter for schema property%s is found in method '%s'%s.", parameterPropertyName != null ? String.format(" '%s'", parameterPropertyName) : "", methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath())));
        } else {
            try {
                context.setTypeValidationInProgress(true);
                try {
                    this.validateType(context, actualParameterSchema, expectedParameterSchema, parameterType, new HashSet<KeyBySchemasRef>(), new HashSet<KeyByFieldType>());
                }
                catch (DifferentTypesException e) {
                    OpenApiProjectValidatorMessagesUtils.addMethodError(context, String.format("OpenAPI Reconciliation: Type '%s' of parameter '%s' in method '%s'%s must be compatible with OpenAPI %s.", parameterType.getDisplayName(1), parameterName, methodName, this.getMethodRelatedPathStringPart(methodName, context.getActualPath()), this.buildOpenApiTypeMessagePart(expectedParameterSchema)));
                }
            }
            finally {
                context.setTypeValidationInProgress(false);
            }
        }
    }

    private boolean isJAXRSParameterAnnotationPresented(Parameter parameter) {
        return parameter.isAnnotationPresent(PathParam.class) || parameter.isAnnotationPresent(QueryParam.class) || parameter.isAnnotationPresent(CookieParam.class) || parameter.isAnnotationPresent(FormParam.class) || parameter.isAnnotationPresent(BeanParam.class) || parameter.isAnnotationPresent(HeaderParam.class) || parameter.isAnnotationPresent(MatrixParam.class);
    }

    private String getJAXRSFormParamAnnotationValue(Parameter parameter) {
        FormParam formParam = parameter.getAnnotation(FormParam.class);
        return formParam != null ? formParam.value() : null;
    }

    private boolean isCompatibleSimpleTypes(String actualType, String expectedType) {
        int actualIndex = ORDER_TYPES1.indexOf(actualType);
        int expectedIndex = ORDER_TYPES1.indexOf(expectedType);
        if (actualIndex >= 0 && expectedIndex >= 0 && actualIndex <= expectedIndex) {
            return true;
        }
        actualIndex = ORDER_TYPES2.indexOf(actualType);
        expectedIndex = ORDER_TYPES2.indexOf(expectedType);
        if (actualIndex >= 0 && expectedIndex >= 0 && actualIndex <= expectedIndex) {
            return true;
        }
        return Objects.equals(actualType, expectedType);
    }

    private boolean isSimpleJavaType(String type) {
        return "String".equals(type) || "Float".equals(type) || "Double".equals(type) || "Integer".equals(type) || "Long".equals(type) || "Boolean".equals(type) || "Date".equals(type) || "BigDecimal".equals(type) || "BigInteger".equals(type);
    }

    private String resolveType(Schema<?> schema) {
        if (schema.get$ref() != null) {
            return RefUtils.computeDefinitionName((String)schema.get$ref());
        }
        return schema.getType();
    }

    private String resolveSimplifiedName(Schema<?> schema) {
        if (schema == null) {
            return "void";
        }
        if (schema.get$ref() != null) {
            return RefUtils.computeDefinitionName((String)schema.get$ref());
        }
        if ("object".equals(schema.getType())) {
            return "object";
        }
        if ("string".equals(schema.getType())) {
            if ("date".equals(schema.getFormat())) {
                return "Date";
            }
            if ("date-time".equals(schema.getFormat())) {
                return "Date";
            }
            return "String";
        }
        if ("number".equals(schema.getType())) {
            if ("float".equals(schema.getFormat())) {
                return "Float";
            }
            if ("double".equals(schema.getFormat())) {
                return "Double";
            }
            return "BigDecimal";
        }
        if ("integer".equals(schema.getType())) {
            if ("int32".equals(schema.getFormat())) {
                return "Integer";
            }
            if ("int64".equals(schema.getFormat())) {
                return "Long";
            }
            return "BigInteger";
        }
        if ("boolean".equals(schema.getType())) {
            return "Boolean";
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String type = this.resolveSimplifiedName(arraySchema.getItems());
            return type != null ? type + "[]" : null;
        }
        return null;
    }

    private IOpenClass getSuperClass(IOpenClass openClass) {
        for (IOpenClass superClass : openClass.superClasses()) {
            if (superClass.isInterface()) continue;
            return superClass;
        }
        return null;
    }

    protected ProjectResource loadProjectResource(ProjectResourceLoader projectResourceLoader, ProjectDescriptor projectDescriptor, String name) {
        ProjectResource[] projectResources = projectResourceLoader.loadResource(name);
        return Arrays.stream(projectResources).filter(e -> Objects.equals(e.getProjectDescriptor().getName(), projectDescriptor.getName())).findFirst().orElse(null);
    }

    protected RulesDeploy loadRulesDeploy(ProjectDescriptor projectDescriptor, CompiledOpenClass compiledOpenClass) {
        ProjectResourceLoader projectResourceLoader = new ProjectResourceLoader(compiledOpenClass);
        ProjectResource projectResource = this.loadProjectResource(projectResourceLoader, projectDescriptor, RULES_DEPLOY_XML);
        if (projectResource != null) {
            try {
                return this.rulesDeploySerializer.deserialize((InputStream)new FileInputStream(projectResource.getFile()));
            }
            catch (FileNotFoundException | JAXBException e) {
                LOG.debug("Ignored error: ", e);
                return null;
            }
        }
        return null;
    }

    protected RulesDeploy getRulesDeploy(ProjectDescriptor projectDescriptor, CompiledOpenClass compiledOpenClass) {
        if (this.rulesDeploy == null) {
            this.rulesDeploy = this.loadRulesDeploy(projectDescriptor, compiledOpenClass);
        }
        return this.rulesDeploy;
    }

    protected ClassLoader resolveServiceClassLoader(RulesInstantiationStrategy instantiationStrategy) throws RulesInstantiationException {
        if (this.classLoader == null) {
            OpenLClassLoader moduleGeneratedClassesClassLoader = ((XlsModuleOpenClass)instantiationStrategy.compile().getOpenClassWithErrors()).getClassGenerationClassLoader();
            OpenLClassLoader openLClassLoader = new OpenLClassLoader(null);
            openLClassLoader.addClassLoader((ClassLoader)moduleGeneratedClassesClassLoader);
            openLClassLoader.addClassLoader(instantiationStrategy.getClassLoader());
            this.classLoader = openLClassLoader;
        }
        return this.classLoader;
    }

    protected RulesInstantiationStrategy enhanceRulesInstantiationStrategy(RulesInstantiationStrategy rulesInstantiationStrategy, boolean provideRuntimeContext, boolean provideVariations) {
        if (provideVariations) {
            rulesInstantiationStrategy = new VariationInstantiationStrategyEnhancer(rulesInstantiationStrategy);
        }
        if (provideRuntimeContext) {
            rulesInstantiationStrategy = new RuntimeContextInstantiationStrategyEnhancer(rulesInstantiationStrategy);
        }
        return rulesInstantiationStrategy;
    }

    protected Class<?> resolveInterface(RulesDeploy rulesDeploy, RulesInstantiationStrategy rulesInstantiationStrategy, ValidatedCompiledOpenClass validatedCompiledOpenClass, boolean provideRuntimeContext, boolean provideVariations) throws RulesInstantiationException {
        String serviceClassName;
        if (rulesDeploy != null && rulesDeploy.getServiceClass() != null && !StringUtils.isEmpty((CharSequence)(serviceClassName = rulesDeploy.getServiceClass().trim()))) {
            try {
                Class<?> serviceClass = validatedCompiledOpenClass.getClassLoader().loadClass(serviceClassName);
                if (serviceClass.isInterface()) {
                    return serviceClass;
                }
                throw new RulesInstantiationException(String.format("Interface is expected for service class '%s', but class is found.", serviceClassName));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new RulesInstantiationException(String.format("An error is occurred during loading a service class '%s'.%s", serviceClassName, StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""));
            }
        }
        String annotationTemplateClassName = null;
        if (rulesDeploy != null) {
            String string = annotationTemplateClassName = rulesDeploy.getAnnotationTemplateClassName() != null ? rulesDeploy.getAnnotationTemplateClassName() : rulesDeploy.getInterceptingTemplateClassName();
            if (annotationTemplateClassName != null) {
                annotationTemplateClassName = annotationTemplateClassName.trim();
            }
        }
        Class serviceClass = rulesInstantiationStrategy.getInstanceClass();
        ClassLoader resolveServiceClassLoader = this.resolveServiceClassLoader(rulesInstantiationStrategy);
        if (!StringUtils.isEmpty((CharSequence)annotationTemplateClassName)) {
            try {
                Class<?> annotationTemplateClass = resolveServiceClassLoader.loadClass(annotationTemplateClassName);
                if (!annotationTemplateClass.isInterface() && !Modifier.isAbstract(annotationTemplateClass.getModifiers())) {
                    throw new RulesInstantiationException(String.format("Interface or abstract class is expected for annotation template class '%s', but class is found.", annotationTemplateClassName));
                }
                serviceClass = DynamicInterfaceAnnotationEnhancerHelper.decorate((Class)serviceClass, annotationTemplateClass, (IOpenClass)rulesInstantiationStrategy.compile().getOpenClassWithErrors(), (ClassLoader)resolveServiceClassLoader);
            }
            catch (RulesInstantiationException e) {
                throw e;
            }
            catch (Exception | NoClassDefFoundError e) {
                throw new RulesInstantiationException(String.format("An error is occurred during loading or applying annotation template class '%s'.%s", annotationTemplateClassName, StringUtils.isNotBlank((CharSequence)e.getMessage()) ? " " + e.getMessage() : ""));
            }
        }
        return RuleServiceInstantiationFactoryHelper.buildInterfaceForService((IOpenClass)rulesInstantiationStrategy.compile().getOpenClassWithErrors(), (Class)serviceClass, (ClassLoader)resolveServiceClassLoader, (Object)rulesInstantiationStrategy.instantiate(true), (boolean)provideRuntimeContext, (boolean)provideVariations);
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public void setProvideRuntimeContext(boolean provideRuntimeContext) {
        this.provideRuntimeContext = provideRuntimeContext;
    }

    public boolean isProvideVariations() {
        return this.provideVariations;
    }

    public void setProvideVariations(boolean provideVariations) {
        this.provideVariations = provideVariations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateType(Context context, Schema<?> actualSchema, Schema<?> expectedSchema, IOpenClass openClass, Set<KeyBySchemasRef> validatedBySchemasRef, Set<KeyByFieldType> validatedByFieldType) throws DifferentTypesException {
        block27: {
            if (actualSchema != null && Optional.ofNullable(expectedSchema).filter(s -> s.getProperties() == null).map(Schema::getType).filter("object"::equals).isPresent()) {
                return;
            }
            if (expectedSchema != null && actualSchema != null && expectedSchema.get$ref() != null && actualSchema.get$ref() != null) {
                KeyBySchemasRef key = new KeyBySchemasRef(openClass, actualSchema.get$ref(), expectedSchema.get$ref());
                if (validatedBySchemasRef.contains(key)) {
                    return;
                }
                validatedBySchemasRef.add(key);
            }
            IOpenClass oldType = context.getType();
            try {
                IOpenField openField;
                Schema resolvedActualSchema = context.getActualOpenAPIResolver().resolve(actualSchema, Schema::get$ref);
                if (resolvedActualSchema == null) break block27;
                Schema resolvedExpectedSchema = context.getExpectedOpenAPIResolver().resolve(expectedSchema, Schema::get$ref);
                if ((openClass.isArray() || ClassUtils.isAssignable((Class)openClass.getInstanceClass(), Collection.class)) && resolvedActualSchema instanceof ArraySchema) {
                    if (resolvedExpectedSchema instanceof ArraySchema) {
                        this.validateType(context, ((ArraySchema)resolvedActualSchema).getItems(), ((ArraySchema)resolvedExpectedSchema).getItems(), (IOpenClass)(openClass.isArray() ? openClass.getComponentClass() : JavaOpenClass.OBJECT), validatedBySchemasRef, validatedByFieldType);
                        return;
                    }
                    throw new DifferentTypesException();
                }
                if (resolvedExpectedSchema instanceof ArraySchema && !(resolvedActualSchema instanceof ArraySchema)) {
                    throw new DifferentTypesException();
                }
                String resolvedActualSchemaSimplifiedName = this.resolveSimplifiedName(resolvedActualSchema);
                String resolvedExpectedSchemaSimplifiedName = this.resolveSimplifiedName(resolvedExpectedSchema);
                if (this.isSimpleJavaType(resolvedActualSchemaSimplifiedName) || this.isSimpleJavaType(resolvedExpectedSchemaSimplifiedName)) {
                    if (this.isSimpleJavaType(resolvedActualSchemaSimplifiedName) && this.isSimpleJavaType(resolvedExpectedSchemaSimplifiedName)) {
                        if (!this.isCompatibleSimpleTypes(resolvedActualSchemaSimplifiedName, resolvedExpectedSchemaSimplifiedName)) {
                            throw new DifferentTypesException();
                        }
                    } else {
                        throw new DifferentTypesException();
                    }
                }
                context.setType(openClass);
                Map propertiesOfExpectedSchema = null;
                Map propertiesOfActualSchema = null;
                boolean parentPresentedInBothSchemas = false;
                if (resolvedExpectedSchema instanceof ComposedSchema && resolvedActualSchema instanceof ComposedSchema) {
                    IOpenClass superClass;
                    ComposedSchema actualComposedSchema = (ComposedSchema)resolvedActualSchema;
                    ComposedSchema expectedComposedSchema = (ComposedSchema)resolvedExpectedSchema;
                    if (this.isParentPresented(actualComposedSchema) && this.isParentPresented(expectedComposedSchema) && (superClass = this.getSuperClass(openClass)) != null) {
                        try {
                            this.validateType(context, this.extractParentSchema(actualComposedSchema), this.extractParentSchema(expectedComposedSchema), superClass, validatedBySchemasRef, validatedByFieldType);
                        }
                        catch (DifferentTypesException e) {
                            String schemaToString = this.schemaToString(context, this.extractParentSchema(expectedComposedSchema));
                            OpenApiProjectValidatorMessagesUtils.addTypeError(context, String.format("OpenAPI Reconciliation: Parent '%s' of type '%s' mismatches to declared schema%s", superClass.getDisplayName(1), openClass.getDisplayName(1), schemaToString == null ? "." : ":\n" + schemaToString));
                        }
                        propertiesOfExpectedSchema = this.extractObjectSchema(expectedComposedSchema).getProperties();
                        propertiesOfActualSchema = this.extractObjectSchema(actualComposedSchema).getProperties();
                        if (propertiesOfActualSchema == null) {
                            propertiesOfActualSchema = Collections.emptyMap();
                        }
                        if (propertiesOfExpectedSchema == null) {
                            propertiesOfExpectedSchema = Collections.emptyMap();
                        }
                        parentPresentedInBothSchemas = true;
                    }
                }
                if (!parentPresentedInBothSchemas) {
                    context.setType(openClass);
                    propertiesOfExpectedSchema = context.getExpectedOpenAPIResolver().resolveAllProperties(resolvedExpectedSchema);
                    propertiesOfActualSchema = context.getActualOpenAPIResolver().resolveAllProperties(resolvedActualSchema);
                }
                ArrayList<Runnable> wrongFields = new ArrayList<Runnable>();
                int countOfValidFields = 0;
                for (Map.Entry<String, Schema> entry : propertiesOfExpectedSchema.entrySet()) {
                    Schema fieldActualSchema = propertiesOfActualSchema.get(entry.getKey());
                    if (fieldActualSchema == null) {
                        if (context.getSpreadsheetMethodResolver().resolve(openClass) == null || openClass instanceof SpreadsheetResultOpenClass) {
                            wrongFields.add(() -> OpenApiProjectValidatorMessagesUtils.addTypeError(context, String.format("OpenAPI Reconciliation: Expected non transient field for schema property '%s' is not found in type '%s'.", entry.getKey(), openClass.getDisplayName(1))));
                            continue;
                        }
                        wrongFields.add(() -> OpenApiProjectValidatorMessagesUtils.addTypeError(context, String.format("OpenAPI Reconciliation: Expected non transient cell for schema property '%s' is not found.", entry.getKey())));
                        continue;
                    }
                    openField = context.getOpenClassPropertiesResolver().findFieldByPropertyName(openClass, entry.getKey());
                    if (openField == null) continue;
                    BiPredicate<Schema, IOpenField> isIncompatibleTypesPredicate = (e1, f) -> {
                        try {
                            if (expectedSchema != null && expectedSchema.get$ref() != null) {
                                KeyByFieldType key = new KeyByFieldType(openClass, openField.getType(), expectedSchema.get$ref());
                                if (!validatedByFieldType.contains(key)) {
                                    validatedByFieldType.add(key);
                                    try {
                                        this.validateType(context, (Schema<?>)e1, (Schema<?>)((Schema)entry.getValue()), f.getType(), validatedBySchemasRef, validatedByFieldType);
                                    }
                                    finally {
                                        validatedByFieldType.remove(key);
                                    }
                                }
                            } else {
                                this.validateType(context, (Schema<?>)e1, (Schema<?>)((Schema)entry.getValue()), f.getType(), validatedBySchemasRef, validatedByFieldType);
                            }
                            return false;
                        }
                        catch (DifferentTypesException e2) {
                            return true;
                        }
                    };
                    if (isIncompatibleTypesPredicate.test(fieldActualSchema, openField)) {
                        String stepName = context.getSpreadsheetMethodResolver().resolveStepName(context.getType(), openField);
                        wrongFields.add(() -> {
                            try {
                                context.setField(openField);
                                context.setIsIncompatibleTypesPredicate(isIncompatibleTypesPredicate);
                                String actualSchemaMessagePartString = this.buildOpenApiTypeMessagePart(fieldActualSchema);
                                actualSchemaMessagePartString = Objects.equals("schema", actualSchemaMessagePartString) ? "" : String.format(" that incompatible with actual %s", actualSchemaMessagePartString);
                                if (stepName == null) {
                                    OpenApiProjectValidatorMessagesUtils.addTypeError(context, String.format("OpenAPI Reconciliation: Type of field '%s' in type '%s' must be compatible with OpenAPI %s%s.", openField.getName(), openClass.getDisplayName(1), this.buildOpenApiTypeMessagePart((Schema)entry.getValue()), actualSchemaMessagePartString));
                                } else {
                                    OpenApiProjectValidatorMessagesUtils.addTypeError(context, String.format("OpenAPI Reconciliation: Type of cell '%s' must be compatible with OpenAPI %s%s.", stepName, this.buildOpenApiTypeMessagePart((Schema)entry.getValue()), actualSchemaMessagePartString));
                                }
                            }
                            finally {
                                context.setIsIncompatibleTypesPredicate(null);
                                context.setField(null);
                            }
                        });
                        continue;
                    }
                    ++countOfValidFields;
                }
                for (Map.Entry<String, Schema> entry : propertiesOfActualSchema.entrySet()) {
                    Schema fieldExpectedSchema = propertiesOfExpectedSchema.get(entry.getKey());
                    if (fieldExpectedSchema != null || (openField = context.getOpenClassPropertiesResolver().findFieldByPropertyName(openClass, entry.getKey())) == null) continue;
                    String stepName = context.getSpreadsheetMethodResolver().resolveStepName(context.getType(), openField);
                    wrongFields.add(() -> {
                        try {
                            context.setField(openField);
                            if (stepName == null) {
                                OpenApiProjectValidatorMessagesUtils.addTypeError(context, String.format("OpenAPI Reconciliation: Unexpected field '%s' is found in type '%s'.", openField.getName(), openClass.getDisplayName(1)));
                            } else {
                                OpenApiProjectValidatorMessagesUtils.addTypeError(context, String.format("OpenAPI Reconciliation: Unexpected schema property '%s' related to cell '%s' is found.", entry.getKey(), stepName));
                            }
                        }
                        finally {
                            context.setField(null);
                        }
                    });
                }
                if (!(countOfValidFields != 0 || wrongFields.isEmpty() || expectedSchema.get$ref() != null && actualSchema.get$ref() != null && Objects.equals(RefUtils.computeDefinitionName((String)expectedSchema.get$ref()), RefUtils.computeDefinitionName((String)actualSchema.get$ref())))) {
                    throw new DifferentTypesException();
                }
                wrongFields.forEach(Runnable::run);
            }
            finally {
                context.setType(oldType);
            }
        }
    }

    private String schemaToString(Context context, Schema<?> extractParentSchema) {
        if (extractParentSchema == null) {
            return null;
        }
        ObjectMapper objectMapper = context.isYaml() ? new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)) : new ObjectMapper();
        objectMapper.deactivateDefaultTyping();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            return objectMapper.writeValueAsString(extractParentSchema);
        }
        catch (JsonProcessingException ignore) {
            return null;
        }
    }

    private boolean isParentPresented(ComposedSchema expectedComposedSchema) {
        if (expectedComposedSchema.getAllOf() != null) {
            int i = 0;
            for (Schema schema : expectedComposedSchema.getAllOf()) {
                if (!(schema instanceof ObjectSchema)) continue;
                ++i;
            }
            return expectedComposedSchema.getAllOf().size() == 2 && i == 1;
        }
        return false;
    }

    private Schema<?> extractObjectSchema(ComposedSchema expectedComposedSchema) {
        if (expectedComposedSchema.getAllOf() != null) {
            for (Schema schema : expectedComposedSchema.getAllOf()) {
                if (!(schema instanceof ObjectSchema)) continue;
                return schema;
            }
        }
        throw new IllegalStateException("Object schema is not found");
    }

    private Schema<?> extractParentSchema(ComposedSchema expectedComposedSchema) {
        if (expectedComposedSchema.getAllOf() != null) {
            for (Schema schema : expectedComposedSchema.getAllOf()) {
                if (schema instanceof ObjectSchema) continue;
                return schema;
            }
        }
        throw new IllegalStateException("Parent schema is not found");
    }

    private void validatePathItem(Context context) {
        this.getAndValidateOperation(context, PathItem::getGet, GET.class);
        this.getAndValidateOperation(context, PathItem::getPost, POST.class);
        this.getAndValidateOperation(context, PathItem::getDelete, DELETE.class);
        this.getAndValidateOperation(context, PathItem::getPut, PUT.class);
        this.getAndValidateOperation(context, PathItem::getHead, HEAD.class);
        this.getAndValidateOperation(context, PathItem::getPatch, PATCH.class);
        this.getAndValidateOperation(context, PathItem::getOptions, OPTIONS.class);
    }

    private static class KeyByFieldType {
        private final IOpenClass openClass;
        private final IOpenClass openFieldType;
        private final String expectedSchemaRef;

        public KeyByFieldType(IOpenClass openClass, IOpenClass openFieldType, String expectedSchemaRef) {
            this.openClass = openClass;
            this.openFieldType = openFieldType;
            this.expectedSchemaRef = expectedSchemaRef;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyByFieldType key = (KeyByFieldType)o;
            if (!Objects.equals(this.openClass, key.openClass)) {
                return false;
            }
            if (!Objects.equals(this.openFieldType, key.openFieldType)) {
                return false;
            }
            return Objects.equals(this.expectedSchemaRef, key.expectedSchemaRef);
        }

        public int hashCode() {
            int result = this.openClass != null ? this.openClass.hashCode() : 0;
            result = 31 * result + (this.openFieldType != null ? this.openFieldType.hashCode() : 0);
            result = 31 * result + (this.expectedSchemaRef != null ? this.expectedSchemaRef.hashCode() : 0);
            return result;
        }
    }

    private static class KeyBySchemasRef {
        private final IOpenClass openClass;
        private final String actualSchemaRef;
        private final String expectedSchemaRef;

        public KeyBySchemasRef(IOpenClass openClass, String actualSchemaRef, String expectedSchemaRef) {
            this.openClass = openClass;
            this.actualSchemaRef = actualSchemaRef;
            this.expectedSchemaRef = expectedSchemaRef;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyBySchemasRef key = (KeyBySchemasRef)o;
            return Objects.equals(this.openClass, key.openClass) && Objects.equals(this.actualSchemaRef, key.actualSchemaRef) && Objects.equals(this.expectedSchemaRef, key.expectedSchemaRef);
        }

        public int hashCode() {
            return Objects.hash(this.openClass, this.actualSchemaRef, this.expectedSchemaRef);
        }
    }
}

