/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.ss.formula.ArrayEval;
import org.apache.poi.ss.formula.IStabilityClassifier;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.ArrayFormulaEvaluatorHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFFormulaEvaluator
implements FormulaEvaluator {
    private WorkbookEvaluator _bookEvaluator;
    private XSSFWorkbook _book;

    public XSSFFormulaEvaluator(XSSFWorkbook workbook) {
        this(workbook, null, null);
    }

    @Deprecated
    public XSSFFormulaEvaluator(XSSFWorkbook workbook, IStabilityClassifier stabilityClassifier) {
        this._bookEvaluator = new WorkbookEvaluator(XSSFEvaluationWorkbook.create(workbook), stabilityClassifier, null);
        this._book = workbook;
    }

    private XSSFFormulaEvaluator(XSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this._bookEvaluator = new WorkbookEvaluator(XSSFEvaluationWorkbook.create(workbook), stabilityClassifier, udfFinder);
        this._book = workbook;
    }

    public static XSSFFormulaEvaluator create(XSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        return new XSSFFormulaEvaluator(workbook, stabilityClassifier, udfFinder);
    }

    @Override
    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    @Override
    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public CellValue evaluate(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError(cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    @Override
    public int evaluateFormulaCell(Cell cell) {
        CellValue cv;
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        if (cell.isPartOfArrayFormulaGroup()) {
            XSSFCell formulaCell = ((XSSFSheet)cell.getSheet()).getFirstCellInArrayFormula((XSSFCell)cell);
            CellValue[][] cvs = this.evaluateFormulaCellArrayValues(formulaCell);
            CellValue[][] values = this.setCellValues(cell, cvs);
            int rowIndex = cell.getRowIndex() - cell.getArrayFormulaRange().getFirstRow();
            int colIndex = cell.getColumnIndex() - cell.getArrayFormulaRange().getFirstColumn();
            cv = values[rowIndex][colIndex];
        } else {
            cv = this.evaluateFormulaCellValue(cell);
            XSSFFormulaEvaluator.setCellValue(cell, cv);
        }
        return cv.getCellType();
    }

    @Override
    public XSSFCell evaluateInCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        XSSFCell result = (XSSFCell)cell;
        if (cell.getCellType() == 2) {
            if (cell.isPartOfArrayFormulaGroup()) {
                CellValue[][] cvs = this.evaluateFormulaCellArrayValues((XSSFCell)cell);
                this.setCellsTypes(cell, cvs);
                this.setCellValues(cell, cvs);
            } else {
                CellValue cv = this.evaluateFormulaCellValue(cell);
                XSSFFormulaEvaluator.setCellType(cell, cv);
                XSSFFormulaEvaluator.setCellValue(cell, cv);
            }
        }
        return result;
    }

    private static void setCellType(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(cellType);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
    }

    private static void setCellValue(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 4: {
                cell.setCellValue(cv.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cv.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cv.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue(new XSSFRichTextString(cv.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
            }
        }
    }

    private void setCellsTypes(Cell cell, CellValue[][] cvs) {
        CellRangeAddress range = cell.getArrayFormulaRange();
        int rowStart = range.getFirstRow();
        int colStart = range.getFirstColumn();
        Sheet sheet = cell.getSheet();
        for (int i = rowStart; i <= range.getLastRow(); ++i) {
            for (int j = colStart; j <= range.getLastColumn(); ++j) {
                Row row = sheet.getRow(i);
                Cell c = row.getCell(j);
                if (i - rowStart >= cvs.length || j - colStart >= cvs[i - rowStart].length) continue;
                XSSFFormulaEvaluator.setCellType(c, cvs[i - rowStart][j - colStart]);
            }
        }
    }

    private CellValue[][] setCellValues(Cell cell, CellValue[][] cvs) {
        CellRangeAddress range = cell.getArrayFormulaRange();
        int rowStart = range.getFirstRow();
        int colStart = range.getFirstColumn();
        Sheet sheet = cell.getSheet();
        CellValue[][] answer = ArrayFormulaEvaluatorHelper.transformToRange(cvs, range);
        for (int i = rowStart; i <= range.getLastRow(); ++i) {
            for (int j = colStart; j <= range.getLastColumn(); ++j) {
                Cell c;
                Row row = sheet.getRow(i);
                if (row == null) {
                    row = sheet.createRow(i);
                }
                if ((c = row.getCell(j)) == null) {
                    c = row.createCell(j);
                }
                CellValue cellValue = answer[i - rowStart][j - colStart];
                XSSFFormulaEvaluator.setCellValue(c, cellValue);
            }
        }
        return answer;
    }

    public static void evaluateAllFormulaCells(XSSFWorkbook wb) {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(wb);
    }

    @Override
    public void evaluateAll() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(this._book);
    }

    private CellValue evaluateFormulaCellValue(Cell cell) {
        if (!(cell instanceof XSSFCell)) {
            throw new IllegalArgumentException("Unexpected type of cell: " + cell.getClass() + "." + " Only XSSFCells can be evaluated.");
        }
        ValueEval eval = this._bookEvaluator.evaluate(new XSSFEvaluationCell((XSSFCell)cell));
        if (eval instanceof ArrayEval) {
            eval = cell.isPartOfArrayFormulaGroup() ? ArrayFormulaEvaluatorHelper.dereferenceValue((ArrayEval)eval, cell) : ((ArrayEval)eval).getValue(0, 0);
        }
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            StringEval ne = (StringEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }

    private CellValue[][] evaluateFormulaCellArrayValues(XSSFCell cell) {
        ValueEval eval = this._bookEvaluator.evaluate(new XSSFEvaluationCell(cell));
        if (eval instanceof ArrayEval) {
            ArrayEval ae = (ArrayEval)eval;
            int rowCount = ae.getHeight();
            int colCount = ae.getWidth();
            CellValue[][] answer = new CellValue[rowCount][colCount];
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    ValueEval val = ae.getValue(i, j);
                    answer[i][j] = ArrayFormulaEvaluatorHelper.evalToCellValue(val);
                }
            }
            return answer;
        }
        CellValue[][] answer = new CellValue[1][1];
        answer[0][0] = ArrayFormulaEvaluatorHelper.evalToCellValue(eval);
        return answer;
    }
}

