/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationName;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.IExternalWorkbookResolver;
import org.apache.poi.ss.formula.UpdatableEvaluationCell;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.ptg.NamePtg;
import org.apache.poi.ss.formula.ptg.NameXPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.PathUtils;
import org.apache.poi.xssf.model.IndexedUDFFinder;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationSheet;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDefinedName;

public final class XSSFEvaluationWorkbook
implements FormulaRenderingWorkbook,
EvaluationWorkbook,
FormulaParsingWorkbook {
    private final XSSFWorkbook _uBook;

    public static XSSFEvaluationWorkbook create(XSSFWorkbook book) {
        if (book == null) {
            return null;
        }
        return new XSSFEvaluationWorkbook(book);
    }

    private XSSFEvaluationWorkbook(XSSFWorkbook book) {
        this._uBook = book;
    }

    private int convertFromExternalSheetIndex(int externSheetIndex) {
        return externSheetIndex;
    }

    @Override
    public int convertFromExternSheetIndex(int externSheetIndex) {
        return externSheetIndex;
    }

    private int convertToExternalSheetIndex(int sheetIndex) {
        return sheetIndex;
    }

    @Override
    public int getExternalSheetIndex(String sheetName) {
        int sheetIndex = this._uBook.getSheetIndex(sheetName);
        return this.convertToExternalSheetIndex(sheetIndex);
    }

    @Override
    public EvaluationName getName(String name, int sheetIndex) {
        for (int i = 0; i < this._uBook.getNumberOfNames(); ++i) {
            XSSFName nm = this._uBook.getNameAt(i);
            String nameText = nm.getNameName();
            if (!name.equalsIgnoreCase(nameText) || nm.getSheetIndex() != sheetIndex) continue;
            return new Name(this._uBook.getNameAt(i), i, this);
        }
        return sheetIndex == -1 ? null : this.getName(name, -1);
    }

    @Override
    public int getSheetIndex(EvaluationSheet evalSheet) {
        XSSFSheet sheet = ((XSSFEvaluationSheet)evalSheet).getXSSFSheet();
        return this._uBook.getSheetIndex(sheet);
    }

    @Override
    public String getSheetName(int sheetIndex) {
        return this._uBook.getSheetName(sheetIndex);
    }

    @Override
    public EvaluationWorkbook.ExternalName getExternalName(int externSheetIndex, int externNameIndex) {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public NameXPtg getNameXPtg(String name) {
        IndexedUDFFinder udfFinder = (IndexedUDFFinder)this.getUDFFinder();
        FreeRefFunction func = udfFinder.findFunction(name);
        if (func == null) {
            return null;
        }
        return new NameXPtg(0, udfFinder.getFunctionIndex(name));
    }

    @Override
    public String resolveNameXText(NameXPtg n) {
        int idx = n.getNameIndex();
        IndexedUDFFinder udfFinder = (IndexedUDFFinder)this.getUDFFinder();
        return udfFinder.getFunctionName(idx);
    }

    @Override
    public EvaluationSheet getSheet(int sheetIndex) {
        return new XSSFEvaluationSheet(this._uBook.getSheetAt(sheetIndex));
    }

    @Override
    public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
        return this._uBook.getExternalSheet(externSheetIndex);
    }

    @Override
    public int getExternalSheetIndex(String workbookName, String sheetName) {
        return this._uBook.getExternalSheetIndex(workbookName, sheetName);
    }

    @Override
    public int getSheetIndex(String sheetName) {
        return this._uBook.getSheetIndex(sheetName);
    }

    @Override
    public String getSheetNameByExternSheet(int externSheetIndex) {
        int sheetIndex = this.convertFromExternalSheetIndex(externSheetIndex);
        return this._uBook.getSheetName(sheetIndex);
    }

    @Override
    public String getNameText(NamePtg namePtg) {
        return this._uBook.getNameAt(namePtg.getIndex()).getNameName();
    }

    @Override
    public EvaluationName getName(NamePtg namePtg) {
        int ix = namePtg.getIndex();
        return new Name(this._uBook.getNameAt(ix), ix, this);
    }

    @Override
    public Ptg[] getFormulaTokens(EvaluationCell evalCell) {
        XSSFCell cell = ((XSSFEvaluationCell)evalCell).getXSSFCell();
        XSSFEvaluationWorkbook frBook = XSSFEvaluationWorkbook.create(this._uBook);
        return FormulaParser.parse(cell.getCellFormula(), frBook, 0, this._uBook.getSheetIndex(cell.getSheet()));
    }

    @Override
    public UDFFinder getUDFFinder() {
        return this._uBook.getUDFFinder();
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    @Override
    public Workbook getWorkbook() {
        return this._uBook;
    }

    @Override
    public UpdatableEvaluationCell getOrCreateUpdatableCell(String sheetName, int rowIndex, int columnIndex) {
        return this.getSheet(this.getSheetIndex(sheetName)).getOrCreateUpdatableCell(rowIndex, columnIndex);
    }

    private URI getExternalReferenceURI(String referenceName) {
        URI answer = null;
        try {
            OPCPackage pkg = this._uBook.getPackage();
            String contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml";
            ArrayList<PackagePart> array = pkg.getPartsByContentType(contentType);
            int index = Integer.parseInt(referenceName);
            PackagePart p = array.get(index - 1);
            PackageRelationshipCollection rels = p.getRelationships();
            for (PackageRelationship rel : rels) {
                if (rel.getTargetMode() != TargetMode.EXTERNAL) continue;
                answer = rel.getTargetURI();
                break;
            }
        }
        catch (NumberFormatException e) {
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return answer;
    }

    @Override
    public WorkbookEvaluator createExternalWorkbookEvaluator(String workbookName, IExternalWorkbookResolver resolver) {
        Workbook externalWorkbook = this.createExternalWorkbook(workbookName, resolver);
        XSSFEvaluationWorkbook ebook = new XSSFCreationHelper((XSSFWorkbook)externalWorkbook).createEvaluationWorkbook();
        return new WorkbookEvaluator(ebook, null, null);
    }

    @Override
    public Workbook createExternalWorkbook(String workbookName, IExternalWorkbookResolver resolver) {
        Workbook result = null;
        URI targetUri = this.getExternalReferenceURI(workbookName);
        if (targetUri != null) {
            try {
                result = resolver.resolveExternalWorkbook(targetUri.getPath());
                if (result == null) {
                    result = new XSSFWorkbook(resolver.resolveExternalExcel(targetUri.getPath()));
                }
                return result;
            }
            catch (IOException e) {}
        } else {
            try {
                result = new XSSFWorkbook(resolver.resolveExternalExcel(workbookName));
            }
            catch (IOException e) {
                throw new RuntimeException("ExternalWorkbook " + workbookName + " not found", e);
            }
        }
        return result;
    }

    @Override
    public String translateExternalWorkbookRef(String refWorkbookName) {
        try {
            OPCPackage pkg = this._uBook.getPackage();
            String contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml";
            ArrayList<PackagePart> array = pkg.getPartsByContentType(contentType);
            for (PackagePart part : array) {
                for (PackageRelationship rel : part.getRelationships()) {
                    String filePath = rel.getTargetURI().getRawPath();
                    if (!PathUtils.hewExtension(filePath).endsWith(PathUtils.hewExtension(refWorkbookName))) continue;
                    return "" + (array.indexOf(part) + 1);
                }
            }
        }
        catch (NumberFormatException e) {
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return refWorkbookName;
    }

    @Override
    public String restoreExternalWorkbookName(String refWorkbookName) {
        URI targetURI = this.getExternalReferenceURI(refWorkbookName);
        if (targetURI != null) {
            return targetURI.getPath();
        }
        return refWorkbookName;
    }

    private static final class Name
    implements EvaluationName {
        private final XSSFName _nameRecord;
        private final int _index;
        private final FormulaParsingWorkbook _fpBook;

        public Name(XSSFName name, int index, FormulaParsingWorkbook fpBook) {
            this._nameRecord = name;
            this._index = index;
            this._fpBook = fpBook;
        }

        @Override
        public Ptg[] getNameDefinition() {
            return FormulaParser.parse(this._nameRecord.getRefersToFormula(), this._fpBook, 4, this._nameRecord.getSheetIndex());
        }

        @Override
        public String getNameText() {
            return this._nameRecord.getNameName();
        }

        @Override
        public boolean hasFormula() {
            CTDefinedName ctn = this._nameRecord.getCTName();
            String strVal = ctn.getStringValue();
            return !ctn.getFunction() && strVal != null && strVal.length() > 0;
        }

        @Override
        public boolean isFunctionName() {
            return this._nameRecord.isFunctionName();
        }

        @Override
        public boolean isRange() {
            return this.hasFormula();
        }

        @Override
        public NamePtg createPtg() {
            return new NamePtg(this._index);
        }
    }
}

