/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.UpdatableEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

final class XSSFEvaluationSheet
implements EvaluationSheet {
    private final XSSFSheet _xs;

    public XSSFEvaluationSheet(XSSFSheet sheet) {
        this._xs = sheet;
    }

    public XSSFSheet getXSSFSheet() {
        return this._xs;
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        XSSFRow row = this._xs.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        XSSFCell cell = row.getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        return new XSSFEvaluationCell(cell, this);
    }

    @Override
    public UpdatableEvaluationCell getOrCreateUpdatableCell(int rowIndex, int columnIndex) {
        XSSFCell cell;
        XSSFRow row = this._xs.getRow(rowIndex);
        if (row == null) {
            row = this._xs.createRow(rowIndex);
        }
        if ((cell = row.getCell(columnIndex)) == null) {
            cell = row.createCell(columnIndex);
        }
        return new XSSFEvaluationCell(cell, this);
    }
}

