/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFCreationHelper
implements CreationHelper {
    private XSSFWorkbook workbook;

    XSSFCreationHelper(XSSFWorkbook wb) {
        this.workbook = wb;
    }

    @Override
    public XSSFRichTextString createRichTextString(String text) {
        XSSFRichTextString rt = new XSSFRichTextString(text);
        rt.setStylesTableReference(this.workbook.getStylesSource());
        return rt;
    }

    @Override
    public XSSFDataFormat createDataFormat() {
        return this.workbook.createDataFormat();
    }

    @Override
    public XSSFHyperlink createHyperlink(int type) {
        return new XSSFHyperlink(type);
    }

    @Override
    public XSSFEvaluationWorkbook createEvaluationWorkbook() {
        return XSSFEvaluationWorkbook.create(this.workbook);
    }

    @Override
    public XSSFFormulaEvaluator createFormulaEvaluator() {
        return new XSSFFormulaEvaluator(this.workbook);
    }

    @Override
    public FormulaEvaluator createFormulaEvaluator(UDFFinder udfFinder) {
        return XSSFFormulaEvaluator.create(this.workbook, null, udfFinder);
    }

    @Override
    public XSSFClientAnchor createClientAnchor() {
        return new XSSFClientAnchor();
    }
}

