/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.GZIPSheetDataWriter;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SheetDataWriter;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SXSSFWorkbook
implements Workbook {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    XSSFWorkbook _wb;
    HashMap<SXSSFSheet, XSSFSheet> _sxFromXHash = new HashMap();
    HashMap<XSSFSheet, SXSSFSheet> _xFromSxHash = new HashMap();
    private int _randomAccessWindowSize = 100;
    private boolean _compressTmpFiles = false;

    public SXSSFWorkbook() {
        this(null);
    }

    public SXSSFWorkbook(XSSFWorkbook workbook) {
        this(workbook, 100);
    }

    public SXSSFWorkbook(XSSFWorkbook workbook, int rowAccessWindowSize) {
        this(workbook, rowAccessWindowSize, false);
    }

    public SXSSFWorkbook(XSSFWorkbook workbook, int rowAccessWindowSize, boolean compressTmpFiles) {
        this.setRandomAccessWindowSize(rowAccessWindowSize);
        this.setCompressTempFiles(compressTmpFiles);
        if (workbook == null) {
            this._wb = new XSSFWorkbook();
        } else {
            this._wb = workbook;
            for (int i = 0; i < this._wb.getNumberOfSheets(); ++i) {
                XSSFSheet sheet = this._wb.getSheetAt(i);
                this.createAndRegisterSXSSFSheet(sheet);
            }
        }
    }

    public SXSSFWorkbook(int rowAccessWindowSize) {
        this(null, rowAccessWindowSize);
    }

    public int getRandomAccessWindowSize() {
        return this._randomAccessWindowSize;
    }

    private void setRandomAccessWindowSize(int rowAccessWindowSize) {
        if (rowAccessWindowSize == 0 || rowAccessWindowSize < -1) {
            throw new IllegalArgumentException("rowAccessWindowSize must be greater than 0 or -1");
        }
        this._randomAccessWindowSize = rowAccessWindowSize;
    }

    public void setCompressTempFiles(boolean compress) {
        this._compressTmpFiles = compress;
    }

    SheetDataWriter createSheetDataWriter() throws IOException {
        if (this._compressTmpFiles) {
            return new GZIPSheetDataWriter();
        }
        return new SheetDataWriter();
    }

    XSSFSheet getXSSFSheet(SXSSFSheet sheet) {
        XSSFSheet result = this._sxFromXHash.get(sheet);
        assert (result != null);
        return result;
    }

    SXSSFSheet getSXSSFSheet(XSSFSheet sheet) {
        SXSSFSheet result = this._xFromSxHash.get(sheet);
        return result;
    }

    void registerSheetMapping(SXSSFSheet sxSheet, XSSFSheet xSheet) {
        this._sxFromXHash.put(sxSheet, xSheet);
        this._xFromSxHash.put(xSheet, sxSheet);
    }

    void deregisterSheetMapping(XSSFSheet xSheet) {
        SXSSFSheet sxSheet = this.getSXSSFSheet(xSheet);
        this._sxFromXHash.remove(sxSheet);
        this._xFromSxHash.remove(xSheet);
    }

    private XSSFSheet getSheetFromZipEntryName(String sheetRef) {
        for (XSSFSheet sheet : this._sxFromXHash.values()) {
            if (!sheetRef.equals(sheet.getPackagePart().getPartName().getName().substring(1))) continue;
            return sheet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectData(File zipfile, OutputStream out) throws IOException {
        ZipFile zip = new ZipFile(zipfile);
        try {
            ZipOutputStream zos = new ZipOutputStream(out);
            try {
                Enumeration<? extends ZipEntry> en = zip.entries();
                while (en.hasMoreElements()) {
                    ZipEntry ze = en.nextElement();
                    zos.putNextEntry(new ZipEntry(ze.getName()));
                    InputStream is = zip.getInputStream(ze);
                    XSSFSheet xSheet = this.getSheetFromZipEntryName(ze.getName());
                    if (xSheet != null) {
                        SXSSFSheet sxSheet = this.getSXSSFSheet(xSheet);
                        InputStream xis = sxSheet.getWorksheetXMLInputStream();
                        try {
                            SXSSFWorkbook.copyStreamAndInjectWorksheet(is, zos, xis);
                        }
                        finally {
                            xis.close();
                        }
                    } else {
                        SXSSFWorkbook.copyStream(is, zos);
                    }
                    is.close();
                }
            }
            finally {
                zos.close();
            }
        }
        finally {
            zip.close();
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] chunk = new byte[1024];
        while ((count = in.read(chunk)) >= 0) {
            out.write(chunk, 0, count);
        }
    }

    private static void copyStreamAndInjectWorksheet(InputStream in, OutputStream out, InputStream worksheetData) throws IOException {
        int c;
        InputStreamReader inReader = new InputStreamReader(in, "UTF-8");
        OutputStreamWriter outWriter = new OutputStreamWriter(out, "UTF-8");
        boolean needsStartTag = true;
        int pos = 0;
        String s = "<sheetData";
        int n = s.length();
        while ((c = inReader.read()) != -1) {
            if (c == s.charAt(pos)) {
                if (++pos != n) continue;
                if (!"<sheetData".equals(s)) break;
                c = inReader.read();
                if (c == -1) {
                    outWriter.write(s);
                    break;
                }
                if (c == 62) {
                    outWriter.write(s);
                    outWriter.write(c);
                    s = "</sheetData>";
                    n = s.length();
                    pos = 0;
                    needsStartTag = false;
                    continue;
                }
                if (c == 47) {
                    c = inReader.read();
                    if (c == -1) {
                        outWriter.write(s);
                        break;
                    }
                    if (c == 62) break;
                    outWriter.write(s);
                    outWriter.write(47);
                    outWriter.write(c);
                    pos = 0;
                    continue;
                }
                outWriter.write(s);
                outWriter.write(47);
                outWriter.write(c);
                pos = 0;
                continue;
            }
            if (pos > 0) {
                outWriter.write(s, 0, pos);
            }
            if (c == s.charAt(0)) {
                pos = 1;
                continue;
            }
            outWriter.write(c);
            pos = 0;
        }
        outWriter.flush();
        if (needsStartTag) {
            outWriter.write("<sheetData>\n");
            outWriter.flush();
        }
        SXSSFWorkbook.copyStream(worksheetData, out);
        outWriter.write("</sheetData>");
        outWriter.flush();
        while ((c = inReader.read()) != -1) {
            outWriter.write(c);
        }
        outWriter.flush();
    }

    public XSSFWorkbook getXSSFWorkbook() {
        return this._wb;
    }

    @Override
    public int getActiveSheetIndex() {
        return this._wb.getActiveSheetIndex();
    }

    @Override
    public void setActiveSheet(int sheetIndex) {
        this._wb.setActiveSheet(sheetIndex);
    }

    @Override
    public int getFirstVisibleTab() {
        return this._wb.getFirstVisibleTab();
    }

    @Override
    public void setFirstVisibleTab(int sheetIndex) {
        this._wb.setFirstVisibleTab(sheetIndex);
    }

    @Override
    public void setSheetOrder(String sheetname, int pos) {
        this._wb.setSheetOrder(sheetname, pos);
    }

    @Override
    public void setSelectedTab(int index) {
        this._wb.setSelectedTab(index);
    }

    @Override
    public void setSheetName(int sheet, String name) {
        this._wb.setSheetName(sheet, name);
    }

    @Override
    public String getSheetName(int sheet) {
        return this._wb.getSheetName(sheet);
    }

    @Override
    public int getSheetIndex(String name) {
        return this._wb.getSheetIndex(name);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        assert (sheet instanceof SXSSFSheet);
        return this._wb.getSheetIndex(this.getXSSFSheet((SXSSFSheet)sheet));
    }

    @Override
    public Sheet createSheet() {
        return this.createAndRegisterSXSSFSheet(this._wb.createSheet());
    }

    SXSSFSheet createAndRegisterSXSSFSheet(XSSFSheet xSheet) {
        SXSSFSheet sxSheet = null;
        try {
            sxSheet = new SXSSFSheet(this, xSheet);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.registerSheetMapping(sxSheet, xSheet);
        return sxSheet;
    }

    @Override
    public Sheet createSheet(String sheetname) {
        return this.createAndRegisterSXSSFSheet(this._wb.createSheet(sheetname));
    }

    @Override
    public Sheet cloneSheet(int sheetNum) {
        throw new RuntimeException("NotImplemented");
    }

    @Override
    public int getNumberOfSheets() {
        return this._wb.getNumberOfSheets();
    }

    @Override
    public Sheet getSheetAt(int index) {
        return this.getSXSSFSheet(this._wb.getSheetAt(index));
    }

    @Override
    public Sheet getSheet(String name) {
        return this.getSXSSFSheet(this._wb.getSheet(name));
    }

    @Override
    public void removeSheetAt(int index) {
        XSSFSheet xSheet = this._wb.getSheetAt(index);
        this._wb.removeSheetAt(index);
        this.deregisterSheetMapping(xSheet);
    }

    @Override
    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        this._wb.setRepeatingRowsAndColumns(sheetIndex, startColumn, endColumn, startRow, endRow);
    }

    @Override
    public Font createFont() {
        return this._wb.createFont();
    }

    @Override
    public Font findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        return this._wb.findFont(boldWeight, color, fontHeight, name, italic, strikeout, typeOffset, underline);
    }

    @Override
    public short getNumberOfFonts() {
        return this._wb.getNumberOfFonts();
    }

    @Override
    public Font getFontAt(short idx) {
        return this._wb.getFontAt(idx);
    }

    @Override
    public CellStyle createCellStyle() {
        return this._wb.createCellStyle();
    }

    @Override
    public short getNumCellStyles() {
        return this._wb.getNumCellStyles();
    }

    @Override
    public CellStyle getCellStyleAt(short idx) {
        return this._wb.getCellStyleAt(idx);
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        for (SXSSFSheet sheet : this._xFromSxHash.values()) {
            sheet.flushRows();
        }
        File tmplFile = File.createTempFile("poi-sxssf-template", ".xlsx");
        tmplFile.deleteOnExit();
        FileOutputStream os = new FileOutputStream(tmplFile);
        this._wb.write(os);
        os.close();
        this.injectData(tmplFile, stream);
        tmplFile.delete();
    }

    @Override
    public int getNumberOfNames() {
        return this._wb.getNumberOfNames();
    }

    @Override
    public Name getName(String name) {
        return this._wb.getName(name);
    }

    @Override
    public Name getNameAt(int nameIndex) {
        return this._wb.getNameAt(nameIndex);
    }

    @Override
    public Name createName() {
        return this._wb.createName();
    }

    @Override
    public int getNameIndex(String name) {
        return this._wb.getNameIndex(name);
    }

    @Override
    public void removeName(int index) {
        this._wb.removeName(index);
    }

    @Override
    public void removeName(String name) {
        this._wb.removeName(name);
    }

    @Override
    public void setPrintArea(int sheetIndex, String reference) {
        this._wb.setPrintArea(sheetIndex, reference);
    }

    @Override
    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        this._wb.setPrintArea(sheetIndex, startColumn, endColumn, startRow, endRow);
    }

    @Override
    public String getPrintArea(int sheetIndex) {
        return this._wb.getPrintArea(sheetIndex);
    }

    @Override
    public void removePrintArea(int sheetIndex) {
        this._wb.removePrintArea(sheetIndex);
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this._wb.getMissingCellPolicy();
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this._wb.setMissingCellPolicy(missingCellPolicy);
    }

    @Override
    public DataFormat createDataFormat() {
        return this._wb.createDataFormat();
    }

    @Override
    public int addPicture(byte[] pictureData, int format) {
        return this._wb.addPicture(pictureData, format);
    }

    @Override
    public List<? extends PictureData> getAllPictures() {
        return this._wb.getAllPictures();
    }

    @Override
    public CreationHelper getCreationHelper() {
        return this._wb.getCreationHelper();
    }

    @Override
    public boolean isHidden() {
        return this._wb.isHidden();
    }

    @Override
    public void setHidden(boolean hiddenFlag) {
        this._wb.setHidden(hiddenFlag);
    }

    @Override
    public boolean isSheetHidden(int sheetIx) {
        return this._wb.isSheetHidden(sheetIx);
    }

    @Override
    public boolean isSheetVeryHidden(int sheetIx) {
        return this._wb.isSheetVeryHidden(sheetIx);
    }

    @Override
    public void setSheetHidden(int sheetIx, boolean hidden) {
        this._wb.setSheetHidden(sheetIx, hidden);
    }

    @Override
    public void setSheetHidden(int sheetIx, int hidden) {
        this._wb.setSheetHidden(sheetIx, hidden);
    }

    @Override
    public void addToolPack(UDFFinder toopack) {
        this._wb.addToolPack(toopack);
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        this._wb.setForceFormulaRecalculation(value);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        return this._wb.getForceFormulaRecalculation();
    }

    @Override
    public boolean isDate1904() {
        return this._wb.isDate1904();
    }
}

