/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import org.apache.poi.ss.formula.ArrayEval;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.function.FunctionMetadata;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.FunctionWithArraySupport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.util.CellRangeAddress;

public class ArrayFormulaEvaluatorHelper {
    private static final CellValue CELL_VALUE_NA = CellValue.getError(42);
    static final int SCALAR_TYPE = 0;
    static final int ARRAY_TYPE = 1;
    private static final ValueEval ERROR_EVAL_NA = ErrorEval.NA;

    private ArrayFormulaEvaluatorHelper() {
    }

    public static ValueEval[][] transformToRange(ValueEval[][] cvs, CellRangeAddress range) {
        return (ValueEval[][])ArrayFormulaEvaluatorHelper.transformToRange(cvs, range, false);
    }

    public static CellValue[][] transformToRange(CellValue[][] cvs, CellRangeAddress range) {
        return (CellValue[][])ArrayFormulaEvaluatorHelper.transformToRange(cvs, range, true);
    }

    private static Object[][] transformToRange(Object[][] cvs, CellRangeAddress range, boolean isCellValue) {
        int nRows = range.getLastRow() - range.getFirstRow() + 1;
        int nColumns = range.getLastColumn() - range.getFirstColumn() + 1;
        Object[][] result = isCellValue ? new CellValue[nRows][nColumns] : new ValueEval[nRows][nColumns];
        int rowStart = range.getFirstRow();
        int colStart = range.getFirstColumn();
        for (int i = rowStart; i <= range.getLastRow(); ++i) {
            for (int j = colStart; j <= range.getLastColumn(); ++j) {
                Object value;
                if (i - rowStart < cvs.length && j - colStart < cvs[i - rowStart].length) {
                    value = cvs[i - rowStart][j - colStart];
                } else {
                    boolean needClone = false;
                    int cloneRow = 0;
                    int cloneCol = 0;
                    if (cvs.length == 1) {
                        cloneCol = j - colStart;
                        needClone = true;
                    }
                    if (cvs[0].length == 1) {
                        cloneRow = i - rowStart;
                        needClone = true;
                    }
                    value = needClone && cloneCol < cvs[0].length && cloneRow < cvs.length ? cvs[cloneRow][cloneCol] : (isCellValue ? CELL_VALUE_NA : ErrorEval.NA);
                }
                result[i - rowStart][j - colStart] = value;
            }
        }
        return result;
    }

    public static CellValue evalToCellValue(ValueEval val) {
        if (val instanceof BoolEval) {
            return CellValue.valueOf(((BoolEval)val).getBooleanValue());
        }
        if (val instanceof NumberEval) {
            return new CellValue(((NumberEval)val).getNumberValue());
        }
        if (val instanceof StringEval) {
            return new CellValue(((StringEval)val).getStringValue());
        }
        if (val instanceof ErrorEval) {
            return new CellValue(((ErrorEval)val).getErrorCode());
        }
        throw new IllegalStateException("Unexpected value (" + val + ")");
    }

    public static ValueEval dereferenceValue(ArrayEval evaluationResult, Cell cell) {
        CellRangeAddress range = cell.getArrayFormulaRange();
        ValueEval[][] rangeVal = ArrayFormulaEvaluatorHelper.transformToRange(evaluationResult.getArrayValues(), range);
        int rowInArray = cell.getRowIndex() - range.getFirstRow();
        int colInArray = cell.getColumnIndex() - range.getFirstColumn();
        return rangeVal[rowInArray][colInArray];
    }

    public static int getParameterType(Function function, FunctionMetadata functionMetaData, int argIndex) {
        int oldanswer = 0;
        if (function instanceof FunctionWithArraySupport && ((FunctionWithArraySupport)function).supportArray(argIndex)) {
            oldanswer = 1;
        }
        return oldanswer;
    }

    public static ArrayEval prepareEmptyResult(Function function, FunctionMetadata functionMetaData, ValueEval[] args, boolean arrayFormula) {
        boolean foundArrayArgThatNeedIterated = false;
        boolean criticalError = false;
        int rowCount = Integer.MIN_VALUE;
        int colCount = Integer.MIN_VALUE;
        int aggregationError = 0;
        for (int i = 0; i < args.length; ++i) {
            TwoDEval aa;
            int argRowCount = Integer.MIN_VALUE;
            int argColCount = Integer.MIN_VALUE;
            ValueEval arg = args[i];
            if (ArrayFormulaEvaluatorHelper.getParameterType(function, functionMetaData, i) == 0) {
                if (arg instanceof ArrayEval) {
                    aa = (ArrayEval)arg;
                    argRowCount = ((ArrayEval)aa).getHeight();
                    argColCount = ((ArrayEval)aa).getWidth();
                    if (((ArrayEval)aa).getComponentError() != 0) {
                        aggregationError = ((ArrayEval)aa).getComponentError();
                    } else if (ArrayFormulaEvaluatorHelper.isArrayArgContainsRef((ArrayEval)aa)) {
                        aggregationError = 15;
                    }
                } else {
                    if (!(arg instanceof AreaEval) || !arrayFormula) continue;
                    aa = (AreaEval)arg;
                    argRowCount = aa.getHeight();
                    argColCount = aa.getWidth();
                }
                foundArrayArgThatNeedIterated = true;
                rowCount = Math.max(rowCount, argRowCount);
                colCount = Math.max(colCount, argColCount);
                continue;
            }
            if (!(arg instanceof ArrayEval)) continue;
            aa = (ArrayEval)arg;
            boolean thisArrayRequreIteration = false;
            if (((ArrayEval)aa).getComponentError() != 0) {
                criticalError = true;
                thisArrayRequreIteration = true;
                aggregationError = ((ArrayEval)aa).getComponentError();
            }
            if (ArrayFormulaEvaluatorHelper.isArrayArgContainsRef((ArrayEval)aa)) {
                thisArrayRequreIteration = true;
                aggregationError = 42;
            }
            if (!thisArrayRequreIteration) continue;
            foundArrayArgThatNeedIterated = true;
            argRowCount = ((ArrayEval)aa).getHeight();
            argColCount = ((ArrayEval)aa).getWidth();
            rowCount = Math.max(rowCount, argRowCount);
            colCount = Math.max(colCount, argColCount);
        }
        if (!foundArrayArgThatNeedIterated) {
            return null;
        }
        if (criticalError) {
            ValueEval[][] errorArray = new ErrorEval[rowCount][colCount];
            for (int row = 0; row < rowCount; ++row) {
                for (int col = 0; col < colCount; ++col) {
                    errorArray[row][col] = ErrorEval.valueOf(aggregationError);
                }
            }
            return new ArrayEval(errorArray);
        }
        ValueEval[][] emptyArray = new ValueEval[rowCount][colCount];
        ArrayEval answer = new ArrayEval(emptyArray);
        if (aggregationError != 0) {
            answer.setComponentError((byte)aggregationError);
        }
        return answer;
    }

    private static boolean isArrayArgContainsRef(ArrayEval aa) {
        for (int j = 0; j < aa.getHeight(); ++j) {
            for (int jj = 0; jj < aa.getWidth(); ++jj) {
                ValueEval elem = aa.getValue(j, jj);
                if (!(elem instanceof AreaEval) && !(elem instanceof RefEval)) continue;
                return true;
            }
        }
        return false;
    }

    public static ValueEval[] prepareArgsForLoop(Function function, FunctionMetadata functionMetaData, ValueEval[] args, int i, int j, boolean arrayFormula) {
        ValueEval[] answer = new ValueEval[args.length];
        for (int argIn = 0; argIn < args.length; ++argIn) {
            ValueEval arg = args[argIn];
            if (ArrayFormulaEvaluatorHelper.getParameterType(function, functionMetaData, argIn) == 0) {
                if (arg instanceof TwoDEval) {
                    arg = ArrayFormulaEvaluatorHelper.getArrayValue((TwoDEval)arg, i, j);
                }
            } else if (arg instanceof ArrayEval) {
                ValueEval elem = ArrayFormulaEvaluatorHelper.getArrayValue((TwoDEval)arg, i, j);
                if (elem instanceof AreaEval) {
                    arg = WorkbookEvaluator.dereferenceValue(elem, ((AreaEval)elem).getFirstRow() + i, ((AreaEval)elem).getFirstColumn() + j);
                } else if (elem instanceof RefEval) {
                    arg = WorkbookEvaluator.dereferenceValue(elem, 0, 0);
                }
            }
            answer[argIn] = arg;
        }
        return answer;
    }

    private static ValueEval getArrayValue(TwoDEval tde, int pRowIndex, int pColIndex) {
        int colIndex;
        int rowIndex;
        if (pRowIndex >= tde.getHeight()) {
            if (!tde.isRow()) {
                return ERROR_EVAL_NA;
            }
            rowIndex = 0;
        } else {
            rowIndex = pRowIndex;
        }
        if (pColIndex >= tde.getWidth()) {
            if (!tde.isColumn()) {
                return ERROR_EVAL_NA;
            }
            colIndex = 0;
        } else {
            colIndex = pColIndex;
        }
        return tde.getValue(rowIndex, colIndex);
    }

    public static boolean checkForArrays(Function function, FunctionMetadata functionMetaData, ValueEval[] ops) {
        for (int i = 0; i < ops.length; ++i) {
            if (!(ops[i] instanceof ArrayEval) || ArrayFormulaEvaluatorHelper.getParameterType(function, functionMetaData, i) != 0) continue;
            return true;
        }
        return false;
    }

    public static ValueEval transferComponentError(ValueEval to, ValueEval[] ops) {
        ValueEval result = to;
        if (result instanceof ArrayEval) {
            for (int i = 0; i < ops.length; ++i) {
                if (!(ops[i] instanceof ArrayEval) || ((ArrayEval)ops[i]).getComponentError() == 0) continue;
                ((ArrayEval)result).setComponentError(((ArrayEval)ops[i]).getComponentError());
                return result;
            }
        }
        return result;
    }
}

