/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.ArrayEval;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayMode;
import org.apache.poi.ss.formula.functions.Function2Arg;
import org.apache.poi.ss.formula.functions.Function3Arg;
import org.apache.poi.ss.formula.functions.Function4Arg;
import org.apache.poi.ss.formula.functions.FunctionWithArraySupport;

public final class Index
implements Function2Arg,
Function3Arg,
Function4Arg,
FunctionWithArraySupport,
ArrayMode {
    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        return this.evaluateX(srcRowIndex, srcColumnIndex, arg0, arg1, false);
    }

    public ValueEval evaluateX(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, boolean arrayMode) {
        TwoDEval reference = Index.convertFirstArg(arg0);
        int columnIx = 0;
        try {
            int rowIx = Index.resolveIndexArg(arg1, srcRowIndex, srcColumnIndex);
            if (!reference.isColumn()) {
                if (!reference.isRow()) {
                    return ErrorEval.REF_INVALID;
                }
                columnIx = rowIx;
                rowIx = 0;
            }
            return Index.getValueFromArea(reference, rowIx, columnIx, arrayMode);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        return this.evaluateX(srcRowIndex, srcColumnIndex, arg0, arg1, arg2, false);
    }

    public ValueEval evaluateX(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2, boolean arrayMode) {
        TwoDEval reference = Index.convertFirstArg(arg0);
        try {
            int columnIx = Index.resolveIndexArg(arg2, srcRowIndex, srcColumnIndex);
            int rowIx = Index.resolveIndexArg(arg1, srcRowIndex, srcColumnIndex);
            return Index.getValueFromArea(reference, rowIx, columnIx, arrayMode);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2, ValueEval arg3) {
        return this.evaluateX(srcRowIndex, srcColumnIndex, arg0, arg1, arg2, arg3, false);
    }

    public ValueEval evaluateX(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2, ValueEval arg3, boolean arrayMode) {
        throw new RuntimeException("Incomplete code - don't know how to support the 'area_num' parameter yet)");
    }

    private static TwoDEval convertFirstArg(ValueEval arg0) {
        ValueEval firstArg = arg0;
        if (firstArg instanceof RefEval) {
            return ((RefEval)firstArg).offset(0, 0, 0, 0);
        }
        if (firstArg instanceof TwoDEval) {
            return (TwoDEval)firstArg;
        }
        throw new RuntimeException("Incomplete code - cannot handle first arg of type (" + firstArg.getClass().getName() + ")");
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        return this.evaluateX(args, srcRowIndex, srcColumnIndex, false);
    }

    public ValueEval evaluateX(ValueEval[] args, int srcRowIndex, int srcColumnIndex, boolean arrayMode) {
        switch (args.length) {
            case 2: {
                return this.evaluateX(srcRowIndex, srcColumnIndex, args[0], args[1], arrayMode);
            }
            case 3: {
                return this.evaluateX(srcRowIndex, srcColumnIndex, args[0], args[1], args[2], arrayMode);
            }
            case 4: {
                return this.evaluateX(srcRowIndex, srcColumnIndex, args[0], args[1], args[2], args[3], arrayMode);
            }
        }
        return ErrorEval.VALUE_INVALID;
    }

    private static ValueEval getValueFromArea(TwoDEval ae, int pRowIx, int pColumnIx, boolean arrayMode) throws EvaluationException {
        int relLastColIx;
        int relFirstColIx;
        int relLastRowIx;
        int relFirstRowIx;
        assert (pRowIx >= 0);
        assert (pColumnIx >= 0);
        int width = ae.getWidth();
        int height = ae.getHeight();
        boolean tryArray = false;
        if (arrayMode || ae instanceof ArrayEval) {
            tryArray = true;
        }
        if (tryArray && (pRowIx == 0 && !ae.isRow() && pColumnIx <= width || pColumnIx == 0 && !ae.isColumn() && pRowIx <= height) && (pRowIx != 0 || pColumnIx != 0)) {
            ValueEval[][] result;
            if (pRowIx == 0) {
                result = new ValueEval[ae.getHeight()][1];
                for (int r = 0; r < ae.getHeight(); ++r) {
                    result[r][0] = ae.getValue(r, pColumnIx - 1);
                }
            } else {
                result = new ValueEval[1][ae.getWidth()];
                for (int c = 0; c < ae.getWidth(); ++c) {
                    result[0][c] = ae.getValue(pRowIx - 1, c);
                }
            }
            return new ArrayEval(result);
        }
        if (pRowIx == 0) {
            relFirstRowIx = 0;
            relLastRowIx = height - 1;
        } else {
            int rowIx;
            if (pRowIx > height) {
                throw new EvaluationException(ErrorEval.REF_INVALID);
            }
            relFirstRowIx = rowIx = pRowIx - 1;
            relLastRowIx = rowIx;
        }
        if (pColumnIx == 0) {
            relFirstColIx = 0;
            relLastColIx = width - 1;
        } else {
            int columnIx;
            if (pColumnIx > width) {
                throw new EvaluationException(ErrorEval.REF_INVALID);
            }
            relFirstColIx = columnIx = pColumnIx - 1;
            relLastColIx = columnIx;
        }
        if (ae instanceof ArrayEval) {
            ArrayEval a = (ArrayEval)ae;
            return a.offset(relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
        }
        AreaEval x = (AreaEval)ae;
        return x.offset(relFirstRowIx, relLastRowIx, relFirstColIx, relLastColIx);
    }

    private static int resolveIndexArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ev = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        if (ev == MissingArgEval.instance) {
            return 0;
        }
        if (ev == BlankEval.instance) {
            return 0;
        }
        int result = OperandResolver.coerceValueToInt(ev);
        if (result < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return result;
    }

    @Override
    public boolean supportArray(int paramIndex) {
        return paramIndex == 0;
    }

    @Override
    public ValueEval evaluateInArrayFormula(ValueEval[] args, int row, int column) {
        return this.evaluateX(args, row, column, true);
    }
}

