/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.constant.ErrorConstant;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.ArrayPtg;
import org.apache.poi.ss.util.NumberToTextConverter;

public final class ArrayEval
implements TwoDEval {
    private final ValueEval[][] _values;
    private byte componentError = 0;

    public ArrayEval(ArrayPtg ptg) {
        if (ptg == null) {
            throw new IllegalArgumentException("ArrayPtg should not be null");
        }
        Object[][] tokenValues = ptg.getTokenArrayValues();
        int nRows = tokenValues.length;
        int nCols = tokenValues[0].length;
        ValueEval[][] values = new ValueEval[nRows][nCols];
        for (int r = 0; r < nRows; ++r) {
            Object[] tokenRow = tokenValues[r];
            ValueEval[] row = values[r];
            for (int c = 0; c < nCols; ++c) {
                row[c] = ArrayEval.constructEval(tokenRow[c]);
            }
        }
        this._values = values;
    }

    public ArrayEval(ValueEval[][] values) {
        if (values == null) {
            throw new IllegalArgumentException("null is not allowed");
        }
        int nRows = values.length;
        int nCols = values[0].length;
        for (int r = 0; r < nRows; ++r) {
            ValueEval[] row = values[r];
            for (int c = 0; c < nCols; ++c) {
                this.validateValueEval(row[c]);
            }
        }
        this._values = values;
    }

    private void validateValueEval(ValueEval valueEval) {
        if (valueEval instanceof NumberEval) {
            return;
        }
        if (valueEval instanceof StringEval) {
            return;
        }
        if (valueEval instanceof BoolEval) {
            return;
        }
        if (valueEval instanceof ErrorEval) {
            return;
        }
        if (valueEval == null) {
            return;
        }
        if (valueEval instanceof RefEval) {
            throw new IllegalArgumentException("Array elements cannot be of type RefEval");
        }
        if (valueEval instanceof AreaEval) {
            throw new IllegalArgumentException("Array elements cannot be of type AreaEval");
        }
        throw new IllegalArgumentException("Unexpected eval type (" + valueEval.getClass().getSimpleName() + ").");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(" [");
        sb.append("{");
        for (int r = 0; r < this._values.length; ++r) {
            if (r > 0) {
                sb.append(";");
            }
            for (int c = 0; c < this._values[r].length; ++c) {
                if (c > 0) {
                    sb.append(",");
                }
                ValueEval o = this._values[r][c];
                sb.append(ArrayEval.getConstantText(o));
            }
        }
        sb.append("}]");
        return sb.toString();
    }

    public ValueEval[][] getArrayValues() {
        return this._values;
    }

    @Override
    public ValueEval getValue(int row, int col) {
        return this._values[row][col];
    }

    private static ValueEval constructEval(Object o) {
        if (o == null) {
            throw new RuntimeException("Array item cannot be null");
        }
        if (o instanceof String) {
            return new StringEval((String)o);
        }
        if (o instanceof Double) {
            return new NumberEval((Double)o);
        }
        if (o instanceof Boolean) {
            return BoolEval.valueOf((Boolean)o);
        }
        if (o instanceof ErrorConstant) {
            return ErrorEval.valueOf(((ErrorConstant)o).getErrorCode());
        }
        throw new IllegalArgumentException("Unexpected constant class (" + o.getClass());
    }

    private static String getConstantText(Object o) {
        if (o == null) {
            return "Error - null";
        }
        if (o instanceof StringEval) {
            return "\"" + ((StringEval)o).getStringValue() + "\"";
        }
        if (o instanceof NumberEval) {
            return NumberToTextConverter.toText(((NumberEval)o).getNumberValue());
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "TRUE" : "FALSE";
        }
        if (o instanceof ErrorEval) {
            return ErrorEval.getText(((ErrorEval)o).getErrorCode());
        }
        throw new IllegalArgumentException("Unexpected constant class (" + o.getClass().getName() + ")");
    }

    public List<ValueEval> getArrayAsEval() {
        ArrayList<ValueEval> l = new ArrayList<ValueEval>();
        for (int r = 0; r < this._values.length; ++r) {
            ValueEval[] row = this._values[r];
            for (int c = 0; c < row.length; ++c) {
                l.add(row[c]);
            }
        }
        return l;
    }

    @Override
    public int getHeight() {
        return this._values.length;
    }

    @Override
    public int getWidth() {
        return this._values[0].length;
    }

    @Override
    public boolean isRow() {
        return this._values.length == 1;
    }

    @Override
    public boolean isColumn() {
        return this._values[0].length == 1;
    }

    public BooleanContent checkBooleanContent() {
        try {
            BoolEval first = (BoolEval)this._values[0][0];
            for (int i = 0; i < this._values.length; ++i) {
                for (int j = 0; j < this._values[i].length; ++j) {
                    if (!first.equals(this._values[i][j])) continue;
                    return BooleanContent.MIXED;
                }
            }
            if (first.getBooleanValue()) {
                return BooleanContent.ONLY_TRUE;
            }
            return BooleanContent.ONLY_FALSE;
        }
        catch (Exception e) {
            return BooleanContent.MIXED;
        }
    }

    public byte getComponentError() {
        return this.componentError;
    }

    public void setComponentError(byte componentError) {
        this.componentError = componentError;
    }

    public ArrayEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        if (relFirstRowIx < 0 || relFirstRowIx > relLastRowIx || relLastRowIx >= this.getHeight() || relFirstColIx < 0 || relFirstColIx > relLastColIx || relLastColIx >= this.getWidth()) {
            throw new IllegalArgumentException("Irregular params: " + relFirstRowIx + ";" + relLastRowIx + ";" + relFirstColIx + ";" + relLastRowIx);
        }
        ValueEval[][] result = new ValueEval[relLastRowIx - relFirstRowIx + 1][relLastColIx - relFirstColIx + 1];
        for (int r = relFirstRowIx; r <= relLastRowIx; ++r) {
            for (int c = relFirstColIx; c <= relLastColIx; ++c) {
                result[r - relFirstRowIx][c - relFirstColIx] = this._values[r][c];
            }
        }
        return new ArrayEval(result);
    }

    @Override
    public TwoDEval getColumn(int columnIndex) {
        return null;
    }

    @Override
    public TwoDEval getRow(int rowIndex) {
        return null;
    }

    @Override
    public boolean isSubTotal(int rowIndex, int columnIndex) {
        return false;
    }

    public static enum BooleanContent {
        ONLY_FALSE,
        ONLY_TRUE,
        MIXED;

    }
}

