/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFEvaluationCell;
import org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.ArrayEval;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.IStabilityClassifier;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.ArrayFormulaEvaluatorHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class HSSFFormulaEvaluator
implements FormulaEvaluator {
    private WorkbookEvaluator _bookEvaluator;
    private HSSFWorkbook _book;

    public HSSFFormulaEvaluator(HSSFSheet sheet, HSSFWorkbook workbook) {
        this(workbook);
        this._book = workbook;
    }

    public HSSFFormulaEvaluator(HSSFWorkbook workbook) {
        this(workbook, null);
        this._book = workbook;
    }

    public HSSFFormulaEvaluator(HSSFWorkbook workbook, IStabilityClassifier stabilityClassifier) {
        this(workbook, stabilityClassifier, null);
    }

    private HSSFFormulaEvaluator(HSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this._bookEvaluator = new WorkbookEvaluator(HSSFEvaluationWorkbook.create(workbook), stabilityClassifier, udfFinder);
    }

    public static HSSFFormulaEvaluator create(HSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        return new HSSFFormulaEvaluator(workbook, stabilityClassifier, udfFinder);
    }

    public static void setupEnvironment(String[] workbookNames, HSSFFormulaEvaluator[] evaluators) {
        WorkbookEvaluator[] wbEvals = new WorkbookEvaluator[evaluators.length];
        for (int i = 0; i < wbEvals.length; ++i) {
            wbEvals[i] = evaluators[i]._bookEvaluator;
        }
        CollaboratingWorkbooksEnvironment.setup(workbookNames, wbEvals);
    }

    public void setCurrentRow(HSSFRow row) {
    }

    @Override
    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    public void notifyUpdateCell(HSSFCell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell(cell));
    }

    @Override
    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    public void notifyDeleteCell(HSSFCell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell(cell));
    }

    @Override
    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    @Override
    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    @Override
    public CellValue evaluate(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError(cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    @Override
    public int evaluateFormulaCell(Cell cell) {
        CellValue cv;
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        if (cell.isPartOfArrayFormulaGroup()) {
            CellValue[][] cvs = this.evaluateFormulaCellArrayValues((HSSFCell)cell);
            int rowIndex = cell.getRowIndex() - cell.getArrayFormulaRange().getFirstRow();
            int colIndex = cell.getColumnIndex() - cell.getArrayFormulaRange().getFirstColumn();
            CellValue[][] values = this.setCellValues(cell, cvs);
            cv = values[rowIndex][colIndex];
        } else {
            cv = this.evaluateFormulaCellValue(cell);
            HSSFFormulaEvaluator.setCellValue(cell, cv);
        }
        return cv.getCellType();
    }

    @Override
    public HSSFCell evaluateInCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        HSSFCell result = (HSSFCell)cell;
        if (cell.getCellType() == 2) {
            if (cell.isPartOfArrayFormulaGroup()) {
                CellValue[][] cvs = this.evaluateFormulaCellArrayValues((HSSFCell)cell);
                this.setCellValues(cell, cvs);
                this.setCellsTypes(cell, cvs);
            } else {
                CellValue cv = this.evaluateFormulaCellValue(cell);
                HSSFFormulaEvaluator.setCellValue(cell, cv);
                HSSFFormulaEvaluator.setCellType(cell, cv);
            }
        }
        return result;
    }

    private static void setCellType(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(cellType);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
    }

    private static void setCellValue(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 4: {
                cell.setCellValue(cv.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cv.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cv.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue(new HSSFRichTextString(cv.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
            }
        }
    }

    private void setCellsTypes(Cell cell, CellValue[][] cvs) {
        CellRangeAddress range = cell.getArrayFormulaRange();
        int rowStart = range.getFirstRow();
        int colStart = range.getFirstColumn();
        Sheet sheet = cell.getSheet();
        for (int i = rowStart; i <= range.getLastRow(); ++i) {
            for (int j = colStart; j <= range.getLastColumn(); ++j) {
                Row row = sheet.getRow(i);
                Cell c = row.getCell(j);
                if (i - rowStart >= cvs.length || j - colStart >= cvs[i - rowStart].length) continue;
                HSSFFormulaEvaluator.setCellType(c, cvs[i - rowStart][j - colStart]);
            }
        }
    }

    private CellValue[][] setCellValues(Cell cell, CellValue[][] cvs) {
        CellRangeAddress range = cell.getArrayFormulaRange();
        int rowStart = range.getFirstRow();
        int colStart = range.getFirstColumn();
        Sheet sheet = cell.getSheet();
        CellValue[][] answer = ArrayFormulaEvaluatorHelper.transformToRange(cvs, range);
        for (int i = rowStart; i <= range.getLastRow(); ++i) {
            for (int j = colStart; j <= range.getLastColumn(); ++j) {
                Cell c;
                Row row = sheet.getRow(i);
                if (row == null) {
                    row = sheet.createRow(i);
                }
                if ((c = row.getCell(j)) == null) {
                    c = row.createCell(j);
                }
                CellValue cellValue = answer[i - rowStart][j - colStart];
                HSSFFormulaEvaluator.setCellValue(c, cellValue);
            }
        }
        return answer;
    }

    public static void evaluateAllFormulaCells(HSSFWorkbook wb) {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(wb, new HSSFFormulaEvaluator(wb));
    }

    public static void evaluateAllFormulaCells(Workbook wb) {
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        HSSFFormulaEvaluator.evaluateAllFormulaCells(wb, evaluator);
    }

    private static void evaluateAllFormulaCells(Workbook wb, FormulaEvaluator evaluator) {
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            Sheet sheet = wb.getSheetAt(i);
            for (Row r : sheet) {
                for (Cell c : r) {
                    if (c.getCellType() != 2) continue;
                    evaluator.evaluateFormulaCell(c);
                }
            }
        }
    }

    @Override
    public void evaluateAll() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(this._book, this);
    }

    private CellValue evaluateFormulaCellValue(Cell cell) {
        ValueEval eval = this._bookEvaluator.evaluate(new HSSFEvaluationCell((HSSFCell)cell));
        if (eval instanceof ArrayEval) {
            eval = cell.isPartOfArrayFormulaGroup() ? ArrayFormulaEvaluatorHelper.dereferenceValue((ArrayEval)eval, cell) : ((ArrayEval)eval).getValue(0, 0);
        }
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            StringEval ne = (StringEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }

    public void setIgnoreMissingWorkbooks(boolean ignore) {
        this._bookEvaluator.setIgnoreMissingWorkbooks(ignore);
    }

    private CellValue[][] evaluateFormulaCellArrayValues(HSSFCell cell) {
        ValueEval eval = this._bookEvaluator.evaluate(new HSSFEvaluationCell(cell));
        if (eval instanceof ArrayEval) {
            ArrayEval ae = (ArrayEval)eval;
            int rowCount = ae.getHeight();
            int ColCount = ae.getWidth();
            CellValue[][] answer = new CellValue[rowCount][ColCount];
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < ColCount; ++j) {
                    ValueEval val = ae.getValue(i, j);
                    answer[i][j] = ArrayFormulaEvaluatorHelper.evalToCellValue(val);
                }
            }
            return answer;
        }
        CellValue[][] answer = new CellValue[1][1];
        answer[0][0] = ArrayFormulaEvaluatorHelper.evalToCellValue(eval);
        return answer;
    }
}

