/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class TextSpecInfoAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected TextSpecInfoAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.TextSpecInfoAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public void setTextSize(int size) {
        LittleEndian.putInt(this._data, 0, size);
    }

    public void reset(int size) {
        this._data = new byte[10];
        LittleEndian.putInt(this._data, 0, size);
        LittleEndian.putInt(this._data, 4, 1);
        LittleEndian.putShort(this._data, 8, (short)0);
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    public int getCharactersCovered() {
        int covered = 0;
        TextSpecInfoRun[] runs = this.getTextSpecInfoRuns();
        for (int i = 0; i < runs.length; ++i) {
            covered += runs[i].len;
        }
        return covered;
    }

    public TextSpecInfoRun[] getTextSpecInfoRuns() {
        ArrayList<TextSpecInfoRun> lst = new ArrayList<TextSpecInfoRun>();
        int pos = 0;
        int[] bits = new int[]{1, 0, 2};
        while (pos < this._data.length) {
            TextSpecInfoRun run = new TextSpecInfoRun();
            run.len = LittleEndian.getInt(this._data, pos);
            run.mask = LittleEndian.getInt(this._data, pos += 4);
            pos += 4;
            block6: for (int i = 0; i < bits.length; ++i) {
                if ((run.mask & 1 << bits[i]) == 0) continue;
                switch (bits[i]) {
                    case 0: {
                        run.spellInfo = LittleEndian.getShort(this._data, pos);
                        pos += 2;
                        continue block6;
                    }
                    case 1: {
                        run.langId = LittleEndian.getShort(this._data, pos);
                        pos += 2;
                        continue block6;
                    }
                    case 2: {
                        run.altLangId = LittleEndian.getShort(this._data, pos);
                        pos += 2;
                    }
                }
            }
            lst.add(run);
        }
        return lst.toArray(new TextSpecInfoRun[lst.size()]);
    }

    public static class TextSpecInfoRun {
        protected int len;
        protected int mask;
        protected short spellInfo = (short)-1;
        protected short langId = (short)-1;
        protected short altLangId = (short)-1;

        public short getSpellInfo() {
            return this.spellInfo;
        }

        public short getLangId() {
            return this.spellInfo;
        }

        public short getAltLangId() {
            return this.altLangId;
        }

        public int length() {
            return this.len;
        }
    }
}

