/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.openl.rules.maven.BaseOpenLMojo;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class VerifyMojo
extends BaseOpenLMojo {
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Deprecated
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true, required=true)
    private List<org.apache.maven.artifact.Artifact> pluginArtifacts;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;

    @Override
    void execute(String sourcePath, boolean hasDependencies) throws Exception {
        String pathDeployment = this.project.getAttachedArtifacts().stream().filter(artifact -> "deployment".equals(artifact.getClassifier())).findFirst().orElseGet(() -> ((MavenProject)this.project).getArtifact()).getFile().getPath();
        HashMap<String, File> openlJars = new HashMap<String, File>();
        openlJars.putAll(this.getJars("org.openl.rules:org.openl.rules.ruleservice.ws"));
        openlJars.putAll(this.getTransitiveDependencies());
        for (Dependency dep : this.plugin.getPlugin().getDependencies()) {
            openlJars.putAll(this.getJars(VerifyMojo.versionlessKey(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier())));
        }
        openlJars.remove("org.apache.logging.log4j:log4j-core");
        openlJars.remove("org.apache.logging.log4j:log4j-slf4j2-impl");
        ClassWorld world = new ClassWorld();
        ClassRealm jettyClassLoader = world.newRealm("jetty");
        for (File x : this.getJars("org.eclipse.jetty:jetty-annotations").values()) {
            jettyClassLoader.addURL(x.toURI().toURL());
        }
        jettyClassLoader.importFrom((ClassLoader)this.plugin.getClassRealm(), "org.slf4j");
        jettyClassLoader.addURL(this.plugin.getPluginArtifact().getFile().toURI().toURL());
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)jettyClassLoader);
            Class appClass = jettyClassLoader.loadClass("org.openl.rules.maven.AppServer");
            Method checkMethod = appClass.getDeclaredMethod("check", String.class, Collection.class, String.class);
            checkMethod.invoke(null, pathDeployment, openlJars.values(), this.outputDirectory.getPath());
            this.info(String.format("Verification is passed for '%s:%s' artifact.", this.project.getGroupId(), this.project.getArtifactId()), new Object[0]);
        }
        catch (Exception e) {
            throw new MojoFailureException(String.format("Verification is failed for '%s:%s' artifact.", this.project.getGroupId(), this.project.getArtifactId()), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
            world.disposeRealm("jetty");
        }
    }

    private Map<String, File> getJars(String artifactId) throws DependencyResolutionException {
        Artifact artifact = this.pluginArtifacts.stream().filter(x -> VerifyMojo.versionlessKey(x.getGroupId(), x.getArtifactId(), x.getClassifier()).equals(artifactId)).map(RepositoryUtils::toArtifact).findFirst().get();
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new org.eclipse.aether.graph.Dependency(artifact, "runtime"));
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        List openlDependencies = this.repositorySystem.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
        HashMap<String, File> result = new HashMap<String, File>(openlDependencies.size());
        for (ArtifactResult x2 : openlDependencies) {
            Artifact a = x2.getArtifact();
            result.put(VerifyMojo.versionlessKey(a.getGroupId(), a.getArtifactId(), a.getClassifier()), a.getFile());
        }
        return result;
    }

    private Map<String, File> getTransitiveDependencies() {
        Set pluginDependencies = this.plugin.getDependencies().stream().map(d -> VerifyMojo.versionlessKey(d.getGroupId(), d.getArtifactId(), null)).collect(Collectors.toSet());
        Set<String> allowedDependencies = this.getAllowedDependencies();
        return this.getDependentNonOpenLProjects().stream().filter(artifact -> {
            if (VerifyMojo.isOpenLCoreDependency(artifact.getGroupId())) {
                this.debug("SKIP : ", artifact);
                return false;
            }
            return true;
        }).filter(artifact -> {
            List dependencyTrail = artifact.getDependencyTrail();
            if (dependencyTrail.size() < 2) {
                this.debug("SKIP : ", artifact, " (by dependency depth)");
                return false;
            }
            if (VerifyMojo.skipOpenLCoreDependency(dependencyTrail)) {
                this.debug("SKIP : ", artifact, " (transitive dependency from OpenL or SLF4j dependencies)");
                return false;
            }
            return true;
        }).filter(a -> !pluginDependencies.contains(VerifyMojo.versionlessKey(a.getGroupId(), a.getArtifactId(), a.getClassifier()))).filter(artifact -> {
            String tr = (String)artifact.getDependencyTrail().get(1);
            String key = tr.substring(0, tr.indexOf(58, tr.indexOf(58) + 1));
            return allowedDependencies.contains(key);
        }).collect(Collectors.toMap(d -> VerifyMojo.versionlessKey(d.getGroupId(), d.getArtifactId(), d.getClassifier()), org.apache.maven.artifact.Artifact::getFile));
    }

    private Set<String> getAllowedDependencies() {
        return this.project.getDependencies().stream().filter(dep -> {
            if (VerifyMojo.skipToProcess(dep.getScope(), dep.getGroupId())) {
                this.debug("SKIP : ", dep);
                return false;
            }
            return true;
        }).map(d -> VerifyMojo.versionlessKey(d.getGroupId(), d.getArtifactId(), d.getClassifier())).collect(Collectors.toSet());
    }

    private static String versionlessKey(String groupId, String artifactId, String classifier) {
        if (classifier == null) {
            return groupId + ":" + artifactId;
        }
        return groupId + ":" + artifactId + ":" + classifier;
    }

    private static boolean skipToProcess(String scope, String group) {
        return !"provided".equals(scope) || VerifyMojo.isOpenLCoreDependency(group);
    }

    @Override
    boolean isDisabled() {
        return this.skipTests || this.skipITs;
    }

    @Override
    String getHeader() {
        return "OPENL VERIFY";
    }
}

