/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openl.CompiledOpenClass;
import org.openl.OpenClassUtil;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.ResolvedDependency;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.rules.maven.BaseOpenLMojo;
import org.openl.rules.maven.ReportFormat;
import org.openl.rules.project.instantiation.AbstractDependencyManager;
import org.openl.rules.project.instantiation.RulesInstantiationException;
import org.openl.rules.project.instantiation.SimpleProjectEngineFactory;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ProjectResolver;
import org.openl.rules.project.resolving.ProjectResolvingException;
import org.openl.rules.testmethod.BaseTestUnit;
import org.openl.rules.testmethod.ITestResultBuilder;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.ProjectHelper;
import org.openl.rules.testmethod.TestRunner;
import org.openl.rules.testmethod.TestStatus;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestSuiteExecutor;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnit;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.result.ComparedResult;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public final class TestMojo
extends BaseOpenLMojo {
    private static final String FAILURE = "<<< FAILURE";
    private static final String ERROR = "<<< ERROR";
    private static final int MAX_MODULES_IN_QUEUE = 10;
    @Parameter(property="skipTests")
    private boolean skipTests;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../openl")
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/openl-test-reports")
    private File reportsDirectory;
    @Parameter(defaultValue="junit4")
    private ReportFormat[] reportsFormat;
    @Parameter(defaultValue="auto")
    private String threadCount;
    @Parameter(defaultValue="false")
    private boolean singleModuleMode;
    @Parameter(defaultValue="0")
    private int maxModulesInMemory;
    @Parameter
    private Map<String, Object> externalParameters;
    @Parameter(defaultValue="${project.testClasspathElements}", readonly=true, required=true)
    private List<String> classpath;
    private TestRunner testRunner;

    @Override
    public void execute(String sourcePath, boolean hasDependencies) throws Exception {
        Summary summary = this.runAllTests(sourcePath, hasDependencies);
        this.info("", new Object[0]);
        this.info("Results:", new Object[0]);
        if (summary.getFailedTests() > 0) {
            this.info("", new Object[0]);
            this.info("Failed Tests:", new Object[0]);
            for (String failure : summary.getSummaryFailures()) {
                this.info("  ", failure);
            }
        }
        if (summary.getErrors() > 0) {
            this.info("", new Object[0]);
            this.info("Tests in error:", new Object[0]);
            for (String error : summary.getSummaryErrors()) {
                this.info("  ", error);
            }
        }
        this.info("", new Object[0]);
        this.info("Total tests run: ", summary.getRunTests(), ", Failures: ", summary.getFailedTests(), ", Errors: ", summary.getErrors());
        this.info("", new Object[0]);
        if (summary.getFailedTests() > 0 || summary.getErrors() > 0) {
            throw new MojoFailureException("There are errors in the OpenL tests.");
        }
        if (summary.isHasCompilationErrors()) {
            throw new MojoFailureException("There are compilation errors in the OpenL tests.");
        }
    }

    private Summary runAllTests(String sourcePath, boolean hasDependencies) throws IOException, RulesInstantiationException, ProjectResolvingException {
        String testSourcePath = sourcePath;
        String mainSourcePath = null;
        File testDir = this.testSourceDirectory.getCanonicalFile();
        if (testDir.isDirectory() && ProjectResolver.getInstance().isRulesProject(testDir) != null) {
            mainSourcePath = sourcePath;
            try {
                testSourcePath = testDir.getCanonicalPath();
            }
            catch (Exception e) {
                this.warn("The path to OpenL test directory cannot be converted to canonical form.", new Object[0]);
                testSourcePath = testDir.getPath();
            }
        }
        return this.singleModuleMode || this.maxModulesInMemory > 0 ? this.executeModuleByModule(testSourcePath, mainSourcePath, hasDependencies) : this.executeAllAtOnce(testSourcePath, mainSourcePath, hasDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Summary executeAllAtOnce(String testSourcePath, String mainSourcePath, boolean hasDependencies) throws MalformedURLException, RulesInstantiationException, ProjectResolvingException {
        Summary summary;
        URL[] urls = this.toURLs(this.classpath);
        URLClassLoader classLoader = null;
        try {
            classLoader = new URLClassLoader(urls, SimpleProjectEngineFactory.class.getClassLoader());
            SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder builder = new SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder();
            if (hasDependencies) {
                builder.setWorkspace(this.workspaceFolder.getPath());
            }
            if (mainSourcePath != null) {
                builder.setProjectDependencies(new String[]{mainSourcePath});
            }
            SimpleProjectEngineFactory factory = builder.setProject(testSourcePath).setClassLoader((ClassLoader)classLoader).setExecutionMode(false).setExternalParameters(this.externalParameters).build();
            CompiledOpenClass openLRules = factory.getCompiledOpenClass();
            summary = this.executeTests(openLRules);
        }
        catch (Throwable throwable) {
            OpenClassUtil.releaseClassLoader(classLoader);
            throw throwable;
        }
        OpenClassUtil.releaseClassLoader((ClassLoader)classLoader);
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Summary executeModuleByModule(String testSourcePath, String mainSourcePath, boolean hasDependencies) throws MalformedURLException, ProjectResolvingException {
        ProjectDescriptor pd = ProjectResolver.getInstance().resolve(new File(testSourcePath));
        if (pd == null) {
            throw new ProjectResolvingException("Failed to resolve project. Defined location is not an OpenL project.");
        }
        int runTests = 0;
        int failedTests = 0;
        int errors = 0;
        ArrayList<String> summaryFailures = new ArrayList<String>();
        ArrayList<String> summaryErrors = new ArrayList<String>();
        boolean hasCompilationErrors = false;
        ArrayList<Module> modules = new ArrayList<Module>(pd.getModules());
        modules.sort(Comparator.comparing(Module::getName));
        URL[] urls = this.toURLs(this.classpath);
        URLClassLoader classLoader = new URLClassLoader(urls, SimpleProjectEngineFactory.class.getClassLoader());
        SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder builder = new SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder();
        if (mainSourcePath != null) {
            builder.setProjectDependencies(new String[]{mainSourcePath});
        }
        if (hasDependencies) {
            builder.setWorkspace(this.workspaceFolder.getPath());
        }
        SimpleProjectEngineFactory factory = builder.setProject(testSourcePath).setClassLoader((ClassLoader)classLoader).setExecutionMode(false).setExternalParameters(this.externalParameters).build();
        ArrayDeque<ResolvedDependency> queueToReset = new ArrayDeque<ResolvedDependency>();
        for (Module module : modules) {
            ResolvedDependency dependency = AbstractDependencyManager.buildResolvedDependency((Module)module);
            try {
                CompiledOpenClass compiledOpenClass;
                this.info("", new Object[0]);
                this.info("Searching tests in module '", module.getName(), "'...");
                try {
                    CompiledDependency compiledDependency = factory.getDependencyManager().loadDependency(dependency);
                    compiledOpenClass = compiledDependency.getCompiledOpenClass();
                }
                catch (OpenLCompilationException e) {
                    LinkedHashSet<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
                    for (OpenLMessage openLMessage : OpenLMessagesUtils.newErrorMessages((Throwable)e)) {
                        String message = String.format("Failed to load module '%s': %s", module.getName(), openLMessage.getSummary());
                        messages.add(new OpenLMessage(message, Severity.ERROR));
                    }
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    try {
                        compiledOpenClass = new CompiledOpenClass((IOpenClass)NullOpenClass.the, messages);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
                Summary summary = this.executeTests(compiledOpenClass);
                runTests += summary.getRunTests();
                failedTests += summary.getFailedTests();
                errors += summary.getErrors();
                summaryFailures.addAll(summary.getSummaryFailures());
                summaryErrors.addAll(summary.getSummaryErrors());
                hasCompilationErrors |= summary.isHasCompilationErrors();
            }
            finally {
                queueToReset.add(dependency);
                while (queueToReset.size() > this.maxModulesInMemory) {
                    queueToReset.poll();
                }
                factory.getDependencyManager().resetOthers(queueToReset.toArray(new ResolvedDependency[0]));
            }
        }
        OpenClassUtil.releaseClassLoader((ClassLoader)classLoader);
        return new Summary(runTests, failedTests, errors, summaryFailures, summaryErrors, hasCompilationErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Summary executeTests(CompiledOpenClass openLRules) {
        TestRunner testRunner = this.getTestRunner();
        IOpenClass openClass = openLRules.getOpenClassWithErrors();
        if (openLRules.hasErrors()) {
            this.error("", new Object[0]);
            this.error("There are compilation errors. It can affect test execution.", new Object[0]);
            Collection errorMessages = OpenLMessagesUtils.filterMessagesBySeverity((Collection)openLRules.getAllMessages(), (Severity)Severity.ERROR);
            int i = 0;
            for (OpenLMessage message : errorMessages) {
                String location = message.getSourceLocation() == null ? "" : " at " + message.getSourceLocation();
                this.error(i + 1 + ". '", message.getSummary(), "'", location);
                ++i;
            }
            this.error("", new Object[0]);
        }
        int runTests = 0;
        int failedTests = 0;
        int errors = 0;
        ArrayList<String> summaryFailures = new ArrayList<String>();
        ArrayList<String> summaryErrors = new ArrayList<String>();
        TestSuiteExecutor testSuiteExecutor = this.createTestSuiteExecutor();
        try {
            TestSuiteMethod[] tests;
            for (TestSuiteMethod test : tests = ProjectHelper.allTesters((IOpenClass)openClass)) {
                String moduleName = test.getModuleName();
                try {
                    TestUnitsResults result;
                    String moduleInfo = moduleName == null ? "" : String.format(" from module '%s'", moduleName);
                    this.info("Running ", String.format("'%s'", test.getName()), moduleInfo, "...");
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(openLRules.getClassLoader());
                        result = testSuiteExecutor == null ? new TestSuite(test, testRunner).invokeSequentially(openClass, 1) : new TestSuite(test, testRunner).invokeParallel(testSuiteExecutor, openClass, 1);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                    this.writeReport(result);
                    int suitTests = result.getNumberOfTestUnits();
                    int suitFailures = result.getNumberOfAssertionFailures();
                    int suitErrors = result.getNumberOfErrors();
                    this.info("Tests run: ", suitTests, ", Failures: ", suitFailures, ", Errors: ", suitErrors, ". Time elapsed: ", this.formatTime(result.getExecutionTime()), " sec.", result.getNumberOfFailures() > 0 ? " <<< FAILURE" : "");
                    if (result.getNumberOfFailures() > 0) {
                        this.showFailures(test, result, summaryFailures, summaryErrors);
                    }
                    runTests += suitTests;
                    failedTests += suitFailures;
                    errors += suitErrors;
                }
                catch (Exception e) {
                    this.error(e);
                    ++errors;
                    Object modulePrefix = moduleName == null ? "" : moduleName + ".";
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
                    if (cause == null) {
                        cause = e;
                    }
                    summaryErrors.add((String)modulePrefix + test.getName() + " " + cause.getClass().getName());
                }
            }
            Summary summary = new Summary(runTests, failedTests, errors, summaryFailures, summaryErrors, openLRules.hasErrors());
            return summary;
        }
        finally {
            if (testSuiteExecutor != null) {
                testSuiteExecutor.destroy();
            }
        }
    }

    private TestRunner getTestRunner() {
        if (this.testRunner == null) {
            TestRunner runner = new TestRunner((ITestResultBuilder)BaseTestUnit.Builder.getInstance());
            for (ReportFormat reportFormat : this.reportsFormat) {
                if (reportFormat != ReportFormat.xlsx) continue;
                runner = new TestRunner((ITestResultBuilder)TestUnit.Builder.getInstance());
                break;
            }
            this.testRunner = runner;
        }
        return this.testRunner;
    }

    private void writeReport(TestUnitsResults result) throws Exception {
        for (ReportFormat reporter : this.reportsFormat) {
            reporter.write(this.reportsDirectory, result);
        }
    }

    private void showFailures(TestSuiteMethod test, TestUnitsResults result, List<String> summaryFailures, List<String> summaryErrors) {
        int num = 1;
        String moduleName = test.getModuleName();
        Object modulePrefix = moduleName == null ? "" : moduleName + ".";
        for (ITestUnit testUnit : result.getTestUnits()) {
            TestStatus status = testUnit.getResultStatus();
            if (status != TestStatus.TR_OK) {
                String failureType = status == TestStatus.TR_NEQ ? FAILURE : ERROR;
                String description = testUnit.getDescription();
                this.info("  Test case: #", num, "No Description".equals(description) ? "" : " (" + description + ")", ". Time elapsed: ", this.formatTime(testUnit.getExecutionTime()), " sec. ", failureType);
                if (status == TestStatus.TR_NEQ) {
                    StringBuilder summaryBuilder = new StringBuilder((String)modulePrefix + test.getName() + "#" + num);
                    List comparisonResults = testUnit.getComparisonResults();
                    int rowNum = 0;
                    for (ComparedResult comparisonResult : comparisonResults) {
                        if (comparisonResult.getStatus() == TestStatus.TR_OK) continue;
                        String fieldName = comparisonResult.getFieldName();
                        String expectedValue = this.toString(comparisonResult.getExpectedValue());
                        String actualValue = this.toString(comparisonResult.getActualValue());
                        if (fieldName == null || "this".equals(fieldName)) {
                            this.info("    Expected: <" + expectedValue + "> but was: <" + actualValue + ">", new Object[0]);
                            summaryBuilder.append(" expected: <").append(expectedValue).append("> but was <").append(actualValue).append(">");
                        } else {
                            if (rowNum > 0) {
                                summaryBuilder.append(",");
                            }
                            this.info("    Field " + fieldName + " expected: <" + expectedValue + "> but was: <" + actualValue + ">", new Object[0]);
                            summaryBuilder.append(" field ").append(fieldName).append(" expected: <").append(expectedValue).append("> but was <").append(actualValue).append(">");
                        }
                        ++rowNum;
                    }
                    summaryFailures.add(summaryBuilder.toString());
                } else {
                    Throwable error = (Throwable)testUnit.getActualResult();
                    this.info("  Error: ", error, "\n", ExceptionUtils.getStackTrace((Throwable)error));
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)error);
                    if (cause == null) {
                        cause = error;
                    }
                    summaryErrors.add((String)modulePrefix + test.getName() + "#" + num + " " + cause.getClass().getName());
                }
            }
            ++num;
        }
        this.info("", new Object[0]);
    }

    @Override
    String getHeader() {
        return "OPENL TESTS";
    }

    @Override
    boolean isDisabled() {
        return this.skipTests;
    }

    private String formatTime(long nanoseconds) {
        double time = (double)nanoseconds / 1.0E9;
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        df.applyPattern("#.###");
        return time < 0.001 ? "< 0.001" : df.format(time);
    }

    private String toString(Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value instanceof Object[]) {
                return Arrays.deepToString((Object[])value);
            }
            String string = Arrays.deepToString(new Object[]{value});
            return string.substring(1, string.length() - 1);
        }
        return Objects.toString(value);
    }

    private TestSuiteExecutor createTestSuiteExecutor() {
        int threads;
        switch (this.threadCount) {
            case "none": {
                return null;
            }
            case "auto": {
                threads = Runtime.getRuntime().availableProcessors() + 2;
                break;
            }
            default: {
                if (this.threadCount.matches("\\d+")) {
                    threads = Integer.parseInt(this.threadCount);
                    break;
                }
                if (this.threadCount.matches("\\d[\\d.]*[cC]")) {
                    float multiplier = Float.parseFloat(this.threadCount.substring(0, this.threadCount.length() - 1));
                    threads = (int)(multiplier * (float)Runtime.getRuntime().availableProcessors());
                    break;
                }
                throw new IllegalArgumentException(String.format("Incorrect thread count '%s'", this.threadCount));
            }
        }
        this.info("Run tests using ", threads, " threads.");
        return new TestSuiteExecutor(threads);
    }

    private static class Summary {
        private final int runTests;
        private final int failedTests;
        private final int errors;
        private final List<String> summaryFailures;
        private final List<String> summaryErrors;
        private final boolean hasCompilationErrors;

        public Summary(int runTests, int failedTests, int errors, List<String> summaryFailures, List<String> summaryErrors, boolean hasCompilationErrors) {
            this.runTests = runTests;
            this.failedTests = failedTests;
            this.errors = errors;
            this.summaryFailures = Collections.unmodifiableList(summaryFailures);
            this.summaryErrors = Collections.unmodifiableList(summaryErrors);
            this.hasCompilationErrors = hasCompilationErrors;
        }

        public int getRunTests() {
            return this.runTests;
        }

        public int getFailedTests() {
            return this.failedTests;
        }

        public int getErrors() {
            return this.errors;
        }

        public List<String> getSummaryFailures() {
            return this.summaryFailures;
        }

        public List<String> getSummaryErrors() {
            return this.summaryErrors;
        }

        public boolean isHasCompilationErrors() {
            return this.hasCompilationErrors;
        }
    }
}

