/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JCodeModelException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JMethod;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.objectweb.asm.ClassWriter;
import org.openl.CompiledOpenClass;
import org.openl.OpenClassUtil;
import org.openl.dependency.CompiledDependency;
import org.openl.dependency.DependencyType;
import org.openl.dependency.ResolvedDependency;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.message.Severity;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.maven.BaseOpenLMojo;
import org.openl.rules.project.instantiation.SimpleProjectEngineFactory;
import org.openl.rules.ruleservice.core.RuleServiceOpenLServiceInstantiationHelper;
import org.openl.rules.ruleservice.publish.common.MethodUtils;
import org.openl.syntax.code.Dependency;
import org.openl.syntax.code.IDependency;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.NullOpenClass;
import org.openl.util.CollectionUtils;
import org.openl.util.FileUtils;
import org.openl.util.StringUtils;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public final class GenerateMojo
extends BaseOpenLMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> classpath;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> sourceRoots;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private String classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/openl")
    private File outputDirectory;
    @Parameter
    private String superInterface;
    @Parameter
    private String interfaceClass;
    @Parameter
    private String moduleName;
    @Parameter
    private boolean isProvideRuntimeContext;
    @Parameter
    private boolean isProvideVariations;
    @Parameter
    private boolean generateSpreadsheetResultBeans;
    @Parameter
    private Map<String, Object> externalParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String sourcePath, boolean hasDependencies) throws Exception {
        if (this.outputDirectory.isDirectory()) {
            this.info("Cleaning up '", this.outputDirectory, "' directory...");
            FileUtils.delete((File)this.outputDirectory);
        }
        ClassLoader classLoader = null;
        try {
            CompiledOpenClass compiledOpenClass;
            classLoader = this.composeClassLoader();
            SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder builder = new SimpleProjectEngineFactory.SimpleProjectEngineFactoryBuilder();
            if (hasDependencies) {
                builder.setWorkspace(this.workspaceFolder.getPath());
            }
            SimpleProjectEngineFactory factory = builder.setProject(sourcePath).setClassLoader(classLoader).setProvideRuntimeContext(this.isProvideRuntimeContext).setProvideVariations(this.isProvideVariations).setExecutionMode(true).setExternalParameters(this.externalParameters).build();
            if (StringUtils.isNotEmpty((CharSequence)this.moduleName) && this.interfaceClass == null) {
                try {
                    Collection resolvedDependencies = factory.getDependencyManager().resolveDependency((IDependency)new Dependency(DependencyType.MODULE, new IdentifierNode(null, null, this.moduleName, null)), false);
                    CompiledDependency compiledDependency = factory.getDependencyManager().loadDependency((ResolvedDependency)resolvedDependencies.iterator().next());
                    compiledOpenClass = compiledDependency.getCompiledOpenClass();
                }
                catch (OpenLCompilationException e) {
                    LinkedHashSet<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
                    for (OpenLMessage openLMessage : OpenLMessagesUtils.newErrorMessages((Throwable)e)) {
                        String message = String.format("Failed to load module '%s': %s", this.moduleName, openLMessage.getSummary());
                        messages.add(new OpenLMessage(message, Severity.ERROR));
                    }
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    try {
                        compiledOpenClass = new CompiledOpenClass((IOpenClass)NullOpenClass.the, messages);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
            } else {
                compiledOpenClass = factory.getCompiledOpenClass();
            }
            this.writeJavaBeans(compiledOpenClass.getTypes());
            if (this.generateSpreadsheetResultBeans && compiledOpenClass.getOpenClass() instanceof XlsModuleOpenClass) {
                this.writeCustomSpreadsheetResultBeans((XlsModuleOpenClass)compiledOpenClass.getOpenClass());
            }
            if (this.interfaceClass != null) {
                Class interfaceClass = factory.getInterfaceClass();
                this.writeInterface(interfaceClass, factory.newInstance());
                this.project.addCompileSourceRoot(this.outputDirectory.getPath());
            }
        }
        finally {
            OpenClassUtil.releaseClassLoader((ClassLoader)classLoader);
        }
    }

    private ClassLoader composeClassLoader() throws Exception {
        this.info("Composing the classloader for the following sources:", new Object[0]);
        for (String dir : this.sourceRoots) {
            this.info("  # source roots > ", dir);
        }
        URL[] urls = this.toURLs(this.dependencyClasspath(this.classpath));
        return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                String className = name.replace('.', '/');
                String file = className.concat(".java");
                for (String dir : GenerateMojo.this.sourceRoots) {
                    if (!new File(dir, file).isFile()) continue;
                    GenerateMojo.this.debug("  # FOUND > ", dir, "/", file);
                    byte[] bytes = GenerateMojo.generateStubClass(className);
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
                GenerateMojo.this.debug("  > ", file);
                return super.findClass(name);
            }
        };
    }

    private List<String> dependencyClasspath(List<String> classpath) {
        ArrayList<String> dependencyClasspath = new ArrayList<String>(classpath);
        dependencyClasspath.remove(this.classesDirectory);
        return dependencyClasspath;
    }

    @Override
    String getHeader() {
        return "OPENL JAVA SOURCES GENERATION";
    }

    private void writeJavaBeans(Collection<IOpenClass> types) throws IOException {
        if (CollectionUtils.isNotEmpty(types)) {
            for (IOpenClass openClass : types) {
                if (!(openClass instanceof DatatypeOpenClass) || ((DatatypeOpenClass)openClass).getBytecode() == null) continue;
                Class datatypeClass = openClass.getInstanceClass();
                String dataType = datatypeClass.getName();
                this.info("Java Bean for Datatype: " + dataType, new Object[0]);
                Path filePath = Paths.get(this.classesDirectory, dataType.replace('.', '/') + ".class");
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, ((DatatypeOpenClass)openClass).getBytecode(), new OpenOption[0]);
            }
        }
    }

    private void writeCustomSpreadsheetResultBeans(CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass, Set<IOpenClass> writtenSpreadsheetResultOpenClasses) throws IOException {
        if (customSpreadsheetResultOpenClass.isGenerateBeanClass() && !writtenSpreadsheetResultOpenClasses.contains(customSpreadsheetResultOpenClass)) {
            Class cls = customSpreadsheetResultOpenClass.getBeanClass();
            this.info("Java Bean for Spreadsheet Result: " + cls.getName(), new Object[0]);
            Path filePath = Paths.get(this.classesDirectory, cls.getName().replace('.', '/') + ".class");
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.write(filePath, customSpreadsheetResultOpenClass.getBeanClassByteCode(), new OpenOption[0]);
            writtenSpreadsheetResultOpenClasses.add((IOpenClass)customSpreadsheetResultOpenClass);
            for (IOpenField openField : customSpreadsheetResultOpenClass.getFields()) {
                if (openField.getType() instanceof CustomSpreadsheetResultOpenClass) {
                    CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass1 = (CustomSpreadsheetResultOpenClass)openField.getType();
                    this.writeCustomSpreadsheetResultBeans(customSpreadsheetResultOpenClass1, writtenSpreadsheetResultOpenClasses);
                    continue;
                }
                if (!(openField.getType() instanceof SpreadsheetResultOpenClass)) continue;
                SpreadsheetResultOpenClass spreadsheetResultOpenClass = (SpreadsheetResultOpenClass)openField.getType();
                this.writeCustomSpreadsheetResultBeans(spreadsheetResultOpenClass.toCustomSpreadsheetResultOpenClass(), writtenSpreadsheetResultOpenClasses);
            }
        }
    }

    private void writeCustomSpreadsheetResultBeans(XlsModuleOpenClass xlsModuleOpenClass) throws IOException {
        if (xlsModuleOpenClass != null) {
            HashSet<IOpenClass> writtenSpreadsheetResultOpenClasses = new HashSet<IOpenClass>();
            for (IOpenClass openClass : xlsModuleOpenClass.getTypes()) {
                if (!(openClass instanceof CustomSpreadsheetResultOpenClass)) continue;
                CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = (CustomSpreadsheetResultOpenClass)openClass;
                this.writeCustomSpreadsheetResultBeans(customSpreadsheetResultOpenClass, writtenSpreadsheetResultOpenClasses);
            }
            if (xlsModuleOpenClass.getSpreadsheetResultOpenClassWithResolvedFieldTypes() != null) {
                this.writeCustomSpreadsheetResultBeans(xlsModuleOpenClass.getSpreadsheetResultOpenClassWithResolvedFieldTypes().toCustomSpreadsheetResultOpenClass(), writtenSpreadsheetResultOpenClasses);
            }
        }
    }

    private void writeInterface(Class<?> clazz, Object service) throws IOException, JCodeModelException {
        Method[] methods;
        this.info("Interface: " + this.interfaceClass, new Object[0]);
        JCodeModel model = new JCodeModel();
        CodeHelper helper = new CodeHelper();
        JDefinedClass java = model._class(this.interfaceClass, EClassType.INTERFACE);
        Object[] interfaces = StringUtils.split((String)this.superInterface, (char)',');
        if (CollectionUtils.isNotEmpty((Object[])interfaces)) {
            for (Object s : interfaces) {
                java._extends(helper.get((String)s));
            }
        }
        for (Method method : methods = clazz.getMethods()) {
            String name = method.getName();
            Class<?> returnType = method.getReturnType();
            this.debug("   method: ", returnType, "   ", name, "()");
            JMethod jm = java.method(0, (AbstractJType)helper.get(returnType), name);
            IOpenMember openMember = RuleServiceOpenLServiceInstantiationHelper.getOpenMember((Method)method, (Object)service);
            String[] argNames = MethodUtils.getParameterNames((IOpenMember)openMember, (Method)method, (boolean)this.isProvideRuntimeContext, (boolean)this.isProvideVariations);
            Class<?>[] argTypes = method.getParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> argType = argTypes[i];
                String argName = argNames[i];
                this.debug("      arg:     ", argName, "   ", argType);
                jm.param((AbstractJType)helper.get(argType), argName);
            }
        }
        this.outputDirectory.mkdirs();
        model.build(this.outputDirectory, (PrintStream)null);
    }

    private static byte[] generateStubClass(String className) {
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(52, 33, className, null, "java/lang/Object", null);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static class CodeHelper {
        JCodeModel model = new JCodeModel();

        private CodeHelper() {
        }

        AbstractJClass get(Class<?> clazz) throws JCodeModelException {
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                AbstractJClass arrayType = this.get(componentType);
                return arrayType.array();
            }
            String clazzName = clazz.getName();
            EClassType eClassType = clazz.isInterface() ? EClassType.INTERFACE : EClassType.CLASS;
            return this.get(clazzName, eClassType);
        }

        AbstractJClass get(String clazzName) throws JCodeModelException {
            return this.get(clazzName, EClassType.INTERFACE);
        }

        private AbstractJClass get(String clazzName, EClassType eClassType) throws JCodeModelException {
            JDefinedClass jArgType = this.model._getClass(clazzName);
            if (jArgType == null) {
                jArgType = this.model._class(clazzName, eClassType);
            }
            return jArgType;
        }
    }
}

