/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openl.util.CollectionUtils;
import org.openl.util.ZipUtils;

abstract class BaseOpenLMojo
extends AbstractMojo {
    private static final String SEPARATOR = "--------------------------------------------------";
    private static final Collection<String> OPENL_FILES = Arrays.asList("rules.xml", "rules-deploy.xml");
    @Parameter(defaultValue="${project.build.sourceDirectory}/../openl")
    private File sourceDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/openl-workspace", required=true)
    protected File workspaceFolder;

    BaseOpenLMojo() {
    }

    String getSourceDirectory() {
        String path;
        try {
            path = this.sourceDirectory.getCanonicalPath();
        }
        catch (Exception e) {
            this.warn("The path to OpenL source directory cannot be converted in canonical form.", new Object[0]);
            path = this.sourceDirectory.getPath();
        }
        this.info("OpenL source directory: ", path);
        if (!this.sourceDirectory.isDirectory() || CollectionUtils.isEmpty((Object[])this.sourceDirectory.list())) {
            this.warn("OpenL source directory is empty.", new Object[0]);
        }
        return path;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isDisabled()) {
            return;
        }
        this.info(SEPARATOR, new Object[0]);
        this.info(this.getHeader(), new Object[0]);
        this.info(SEPARATOR, new Object[0]);
        try {
            boolean hasDependencies;
            Set<Artifact> dependencies = this.getDependentOpenLProjects();
            boolean bl = hasDependencies = !dependencies.isEmpty();
            if (hasDependencies) {
                this.debug("Has ", dependencies.size(), " dependencies");
                for (Artifact artifact : dependencies) {
                    this.debug("Extract dependency ", artifact.getArtifactId());
                    File projectFolder = new File(this.workspaceFolder, artifact.getArtifactId());
                    if (projectFolder.exists()) continue;
                    ZipUtils.extractAll((File)artifact.getFile(), (File)projectFolder);
                }
            }
            String openlRoot = this.getSourceDirectory();
            this.execute(openlRoot, hasDependencies);
        }
        catch (MojoFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoFailureException("Execution failure.", (Throwable)ex);
        }
        finally {
            this.info(SEPARATOR, new Object[0]);
        }
    }

    abstract void execute(String var1, boolean var2) throws Exception;

    boolean isDisabled() {
        return false;
    }

    String getHeader() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    URL[] toURLs(List<String> files) throws MalformedURLException {
        this.debug("Converting file paths to URLs...", new Object[0]);
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (String file : files) {
            this.debug("   > ", file);
            urls.add(new File(file).toURI().toURL());
        }
        return urls.toArray(new URL[0]);
    }

    void info(CharSequence message, Object ... args) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(this.getMessage(message, args));
        }
    }

    void warn(CharSequence message, Object ... args) {
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn(this.getMessage(message, args));
        }
    }

    void error(CharSequence message, Object ... args) {
        if (this.getLog().isErrorEnabled()) {
            this.getLog().error(this.getMessage(message, args));
        }
    }

    void error(Exception ex) {
        if (this.getLog().isErrorEnabled()) {
            this.getLog().error((Throwable)ex);
        }
    }

    void debug(CharSequence message, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(this.getMessage(message, args));
        }
    }

    private CharSequence getMessage(CharSequence message, Object[] args) {
        if (CollectionUtils.isEmpty((Object[])args)) {
            return message;
        }
        StringBuilder sb = new StringBuilder(message);
        for (Object obj : args) {
            sb.append(obj);
        }
        return sb;
    }

    protected Set<Artifact> getDependentOpenLProjects() {
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            File file = artifact.getFile();
            if (!ZipUtils.contains((File)file, OPENL_FILES::contains)) continue;
            dependencies.add(artifact);
            this.debug("OpenL artifact : ", artifact);
        }
        return dependencies;
    }

    protected Set<Artifact> getDependentNonOpenLProjects() {
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            File file = artifact.getFile();
            if (ZipUtils.contains((File)file, OPENL_FILES::contains)) continue;
            dependencies.add(artifact);
            this.debug("Non OpenL artifact : ", artifact);
        }
        return dependencies;
    }

    static boolean skipOpenLCoreDependency(List<String> dependencyTrail) {
        for (int i = 1; i < dependencyTrail.size() - 1; ++i) {
            String dependency = dependencyTrail.get(i);
            if (!dependency.startsWith("org.openl.rules:") && !dependency.startsWith("org.openl:") && !dependency.startsWith("org.slf4j:")) continue;
            return true;
        }
        return false;
    }

    static boolean isOpenLCoreDependency(String group) {
        return "org.openl.rules".equals(group) || "org.openl".equals(group) || "org.slf4j".equals(group);
    }
}

