/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.openl.domain.IDomain;
import org.openl.domain.IType;

public class DateRangeDomain
implements IDomain<Date> {
    private final Calendar min = new GregorianCalendar();
    private final Calendar max = new GregorianCalendar();
    private static final long ONE_HOUR = 3600000L;

    public DateRangeDomain(Date min, Date max) {
        this.setMin(min);
        this.setMax(max);
    }

    public Date getMin() {
        return this.min.getTime();
    }

    public Date getMax() {
        return this.max.getTime();
    }

    public void setMin(Date min) {
        this.min.setTime(DateRangeDomain.truncate(min));
    }

    public void setMax(Date max) {
        this.max.setTime(DateRangeDomain.truncate(max));
    }

    private static Date truncate(Date min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(min);
        Date date = cal.getTime();
        long time = date.getTime();
        time -= (long)cal.get(14);
        time -= (long)(cal.get(13) * 1000);
        if (date.getTime() != (time -= (long)(cal.get(12) * 1000 * 60))) {
            date.setTime(time);
            cal.setTime(date);
        }
        cal.set(11, 0);
        return cal.getTime();
    }

    @Override
    public Iterator<Date> iterator() {
        return new DateIterator();
    }

    public static long daysBetween(Calendar d1, Calendar d2) {
        return (d2.getTimeInMillis() - d1.getTimeInMillis() + 3600000L) / 86400000L;
    }

    public int size() {
        return (int)DateRangeDomain.daysBetween(this.min, this.max) + 1;
    }

    @Override
    public IType getElementType() {
        return null;
    }

    @Override
    public boolean selectObject(Date obj) {
        return obj.before(this.max.getTime()) && obj.after(this.min.getTime());
    }

    public int getIndex(Date value) {
        if (value.after(this.getMax())) {
            return -1;
        }
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(value);
        return (int)DateRangeDomain.daysBetween(this.min, date);
    }

    public Date getValue(int index) {
        if (index >= this.size()) {
            return null;
        }
        Calendar date = (Calendar)this.min.clone();
        date.add(5, index);
        return date.getTime();
    }

    public String toString() {
        return "[" + this.getMin() + ";" + this.getMax() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRangeDomain dates = (DateRangeDomain)o;
        if (!this.min.equals(dates.min)) {
            return false;
        }
        return this.max.equals(dates.max);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    private class DateIterator
    implements Iterator<Date> {
        private final Calendar current;

        DateIterator() {
            this.current = (Calendar)DateRangeDomain.this.min.clone();
            this.current.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.current.before(DateRangeDomain.this.max);
        }

        @Override
        public Date next() {
            this.current.add(5, 1);
            return this.current.getTime();
        }

        @Override
        public void remove() {
        }
    }
}

