/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.Executor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.openjfx.JavaFXBaseMojo;
import org.openjfx.model.RuntimePathOption;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class JavaFXRunMojo
extends JavaFXBaseMojo {
    @Parameter(property="javafx.executable", defaultValue="java")
    private String executable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (this.executable == null) {
            throw new MojoExecutionException("The parameter 'executable' is missing or invalid");
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        try {
            this.handleWorkingDirectory();
            Map<String, String> enviro = this.handleSystemEnvVariables();
            CommandLine commandLine = this.getExecutablePath(this.executable, enviro, this.workingDirectory);
            boolean usingOldJDK = JavaFXRunMojo.isTargetUsingJava8(commandLine);
            List<String> commandArguments = this.createCommandArguments(usingOldJDK);
            String[] args = commandArguments.toArray(new String[commandArguments.size()]);
            commandLine.addArguments(args, false);
            this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
            DefaultExecutor exec = new DefaultExecutor();
            exec.setWorkingDirectory(this.workingDirectory);
            try {
                int resultCode;
                block14: {
                    block13: {
                        if (this.outputFile == null) break block13;
                        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                            this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                        }
                        FileOutputStream outputStream = null;
                        try {
                            outputStream = new FileOutputStream(this.outputFile);
                            resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, outputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(outputStream);
                            throw throwable;
                        }
                        IOUtil.close((OutputStream)outputStream);
                        break block14;
                    }
                    resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, System.out, System.err);
                }
                if (resultCode != 0) {
                    String message = "Result of " + commandLine.toString() + " execution is: '" + resultCode + "'.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
            }
            catch (ExecuteException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                e.printStackTrace();
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private List<String> createCommandArguments(boolean oldJDK) throws MojoExecutionException {
        ArrayList<String> commandArguments = new ArrayList<String>();
        this.preparePaths(JavaFXRunMojo.getParent(Paths.get(this.executable, new String[0]), 2));
        if (this.options != null) {
            this.options.stream().filter(Objects::nonNull).filter(String.class::isInstance).map(String.class::cast).map(this::splitComplexArgumentString).flatMap(Collection::stream).forEach(commandArguments::add);
        }
        if (!oldJDK && (this.runtimePathOption == RuntimePathOption.MODULEPATH || this.modulepathElements != null && !this.modulepathElements.isEmpty())) {
            commandArguments.add("--module-path");
            commandArguments.add(StringUtils.join(this.modulepathElements.iterator(), (String)File.pathSeparator));
            commandArguments.add("--add-modules");
            commandArguments.add(this.createAddModulesString(this.moduleDescriptor, this.pathElements));
        }
        if (this.classpathElements != null && !this.classpathElements.isEmpty()) {
            commandArguments.add("-classpath");
            String classpath = "";
            if (oldJDK || this.runtimePathOption == RuntimePathOption.CLASSPATH) {
                classpath = this.project.getBuild().getOutputDirectory() + File.pathSeparator;
            }
            classpath = classpath + StringUtils.join(this.classpathElements.iterator(), (String)File.pathSeparator);
            commandArguments.add(classpath);
        }
        if (this.mainClass != null) {
            if (this.moduleDescriptor != null) {
                commandArguments.add("--module");
            }
            commandArguments.add(this.createMainClassString(this.mainClass, this.moduleDescriptor, this.runtimePathOption));
        }
        if (this.commandlineArgs != null) {
            this.splitComplexArgumentString(this.commandlineArgs).forEach(commandArguments::add);
        }
        return commandArguments;
    }

    private String createAddModulesString(JavaModuleDescriptor moduleDescriptor, Map<String, JavaModuleDescriptor> pathElements) {
        if (moduleDescriptor == null) {
            return pathElements.values().stream().filter(Objects::nonNull).map(JavaModuleDescriptor::name).filter(Objects::nonNull).filter(module -> module.startsWith("javafx") && !module.endsWith("Empty")).collect(Collectors.joining(","));
        }
        return moduleDescriptor.name();
    }

    private List<String> splitComplexArgumentString(String argumentString) {
        char[] strArr = argumentString.trim().toCharArray();
        ArrayList<String> splitedArgs = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int expectedSeparator = 32;
        for (int i = 0; i < strArr.length; ++i) {
            int item = strArr[i];
            if (item == expectedSeparator || expectedSeparator == 32 && Pattern.matches("\\s", String.valueOf((char)item))) {
                if (expectedSeparator == 34 || expectedSeparator == 39) {
                    sb.append((char)item);
                    expectedSeparator = 32;
                } else if (expectedSeparator == 32 && sb.length() > 0) {
                    splitedArgs.add(sb.toString());
                    sb.delete(0, sb.length());
                }
            } else {
                if (expectedSeparator == 32 && (item == 34 || item == 39)) {
                    expectedSeparator = item;
                }
                sb.append((char)item);
            }
            if (i != strArr.length - 1 || sb.length() <= 0) continue;
            splitedArgs.add(sb.toString());
        }
        return splitedArgs;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setCommandlineArgs(String commandlineArgs) {
        this.commandlineArgs = commandlineArgs;
    }

    List<String> splitComplexArgumentStringAdapter(String cliOptions) {
        return this.splitComplexArgumentString(cliOptions);
    }
}

