/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.headless;

import com.sun.glass.ui.Timer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HeadlessTimer
extends Timer {
    private static ScheduledThreadPoolExecutor scheduler;
    private ScheduledFuture<?> task;

    HeadlessTimer(Runnable runnable) {
        super(runnable);
    }

    @Override
    protected long _start(Runnable runnable) {
        throw new RuntimeException("vsync timer not supported");
    }

    @Override
    protected long _start(Runnable runnable2, int n) {
        if (scheduler == null) {
            scheduler = new ScheduledThreadPoolExecutor(1, runnable -> {
                Thread thread = new Thread(runnable, "Headless Timer");
                thread.setDaemon(true);
                return thread;
            });
        }
        this.task = scheduler.scheduleAtFixedRate(runnable2, 0L, n, TimeUnit.MILLISECONDS);
        return 1L;
    }

    @Override
    protected void _stop(long l) {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
    }

    @Override
    protected void _pause(long l) {
    }

    @Override
    protected void _resume(long l) {
    }
}

