/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ToolBarBehavior;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.WindowEvent;

public class ToolBarSkin
extends SkinBase<ToolBar> {
    private Pane box;
    private Pane overflowBox;
    private ToolBarOverflowMenu overflowMenu;
    private boolean overflow = false;
    private int overflowNodeIndex = Integer.MAX_VALUE;
    private double previousWidth = 0.0;
    private double previousHeight = 0.0;
    private double savedPrefWidth = 0.0;
    private double savedPrefHeight = 0.0;
    private boolean needsUpdate = false;
    private final ParentTraversalEngine engine;
    private final BehaviorBase<ToolBar> behavior;
    private ListChangeListener<Node> itemsListener;
    private DoubleProperty spacing;
    private ObjectProperty<Pos> boxAlignment;

    public ToolBarSkin(final ToolBar toolBar) {
        super(toolBar);
        this.behavior = new ToolBarBehavior(toolBar);
        this.initialize();
        this.registerChangeListener((ObservableValue<?>)toolBar.orientationProperty(), observableValue -> this.initialize());
        this.engine = new ParentTraversalEngine((Parent)this.getSkinnable(), new Algorithm(){
            final /* synthetic */ ToolBarSkin this$0;
            {
                this.this$0 = toolBarSkin;
            }

            private Node selectPrev(int n, TraversalContext traversalContext) {
                for (int i = n; i >= 0; --i) {
                    Node node;
                    Node node2 = (Node)this.this$0.box.getChildren().get(i);
                    if (node2.isDisabled() || !NodeHelper.isTreeShowing((Node)node2)) continue;
                    if (node2 instanceof Parent && (node = traversalContext.selectLastInParent((Parent)node2)) != null) {
                        return node;
                    }
                    if (!node2.isFocusTraversable()) continue;
                    return node2;
                }
                return null;
            }

            private Node selectNext(int n, TraversalContext traversalContext) {
                int n2 = this.this$0.box.getChildren().size();
                for (int i = n; i < n2; ++i) {
                    Node node;
                    Node node2 = (Node)this.this$0.box.getChildren().get(i);
                    if (node2.isDisabled() || !NodeHelper.isTreeShowing((Node)node2)) continue;
                    if (node2.isFocusTraversable()) {
                        return node2;
                    }
                    if (!(node2 instanceof Parent) || (node = traversalContext.selectFirstInParent((Parent)node2)) == null) continue;
                    return node;
                }
                return null;
            }

            public Node select(Node node, Direction direction, TraversalContext traversalContext) {
                Parent parent;
                int n;
                direction = direction.getDirectionForNodeOrientation(toolBar.getEffectiveNodeOrientation());
                ObservableList observableList = this.this$0.box.getChildren();
                if (node == this.this$0.overflowMenu) {
                    if (direction.isForward()) {
                        return null;
                    }
                    Node node2 = this.selectPrev(observableList.size() - 1, traversalContext);
                    if (node2 != null) {
                        return node2;
                    }
                }
                if ((n = observableList.indexOf((Object)node)) < 0) {
                    parent = node.getParent();
                    while (!observableList.contains((Object)parent)) {
                        if (parent == null) {
                            return null;
                        }
                        parent = parent.getParent();
                    }
                    Node node3 = traversalContext.selectInSubtree(parent, node, direction);
                    if (node3 != null) {
                        return node3;
                    }
                    n = observableList.indexOf((Object)parent);
                    if (direction == Direction.NEXT) {
                        direction = Direction.NEXT_IN_LINE;
                    }
                }
                if (n >= 0) {
                    if (direction.isForward()) {
                        parent = this.selectNext(n + 1, traversalContext);
                        if (parent != null) {
                            return parent;
                        }
                        if (this.this$0.overflow) {
                            this.this$0.overflowMenu.requestFocus();
                            return this.this$0.overflowMenu;
                        }
                    } else {
                        parent = this.selectPrev(n - 1, traversalContext);
                        if (parent != null) {
                            return parent;
                        }
                    }
                }
                return null;
            }

            public Node selectFirst(TraversalContext traversalContext) {
                Node node = this.selectNext(0, traversalContext);
                if (node != null) {
                    return node;
                }
                if (this.this$0.overflow) {
                    return this.this$0.overflowMenu;
                }
                return null;
            }

            public Node selectLast(TraversalContext traversalContext) {
                if (this.this$0.overflow) {
                    return this.this$0.overflowMenu;
                }
                return this.selectPrev(this.this$0.box.getChildren().size() - 1, traversalContext);
            }
        });
        ParentHelper.setTraversalEngine((Parent)this.getSkinnable(), (ParentTraversalEngine)this.engine);
        this.registerChangeListener((ObservableValue<?>)toolBar.focusedProperty(), observableValue -> {
            if (((ToolBar)this.getSkinnable()).isFocused()) {
                if (!this.box.getChildren().isEmpty()) {
                    ((Node)this.box.getChildren().get(0)).requestFocus();
                } else {
                    this.overflowMenu.requestFocus();
                }
            }
        });
        this.itemsListener = change -> {
            while (change.next()) {
                for (Node node : change.getRemoved()) {
                    this.box.getChildren().remove((Object)node);
                    this.overflowBox.getChildren().remove((Object)node);
                }
                this.box.getChildren().addAll((Collection)change.getAddedSubList());
            }
            this.needsUpdate = true;
            ((ToolBar)this.getSkinnable()).requestLayout();
        };
        toolBar.getItems().addListener(this.itemsListener);
    }

    private double snapSpacing(double d) {
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.snapSpaceY(d);
        }
        return this.snapSpaceX(d);
    }

    private final void setSpacing(double d) {
        this.spacingProperty().set(this.snapSpacing(d));
    }

    private final double getSpacing() {
        return this.spacing == null ? 0.0 : this.snapSpacing(this.spacing.get());
    }

    private final DoubleProperty spacingProperty() {
        if (this.spacing == null) {
            this.spacing = new StyleableDoubleProperty(){

                protected void invalidated() {
                    double d = this.get();
                    if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        ((VBox)ToolBarSkin.this.box).setSpacing(d);
                    } else {
                        ((HBox)ToolBarSkin.this.box).setSpacing(d);
                    }
                }

                public Object getBean() {
                    return ToolBarSkin.this;
                }

                public String getName() {
                    return "spacing";
                }

                public CssMetaData<ToolBar, Number> getCssMetaData() {
                    return StyleableProperties.SPACING;
                }
            };
        }
        return this.spacing;
    }

    private final void setBoxAlignment(Pos pos) {
        this.boxAlignmentProperty().set((Object)pos);
    }

    private final Pos getBoxAlignment() {
        return this.boxAlignment == null ? Pos.TOP_LEFT : (Pos)this.boxAlignment.get();
    }

    private final ObjectProperty<Pos> boxAlignmentProperty() {
        if (this.boxAlignment == null) {
            this.boxAlignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                public void invalidated() {
                    Pos pos = (Pos)this.get();
                    if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        ((VBox)ToolBarSkin.this.box).setAlignment(pos);
                    } else {
                        ((HBox)ToolBarSkin.this.box).setAlignment(pos);
                    }
                }

                public Object getBean() {
                    return ToolBarSkin.this;
                }

                public String getName() {
                    return "boxAlignment";
                }

                public CssMetaData<ToolBar, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }
            };
        }
        return this.boxAlignment;
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((ToolBar)this.getSkinnable()).getItems().removeListener(this.itemsListener);
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        return toolBar.getOrientation() == Orientation.VERTICAL ? this.computePrefWidth(-1.0, d2, d3, d4, d5) : this.snapSizeX(this.overflowMenu.prefWidth(-1.0)) + d5 + d3;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        return toolBar.getOrientation() == Orientation.VERTICAL ? this.snapSizeY(this.overflowMenu.prefHeight(-1.0)) + d2 + d4 : this.computePrefHeight(-1.0, d2, d3, d4, d5);
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        if (toolBar.getOrientation() == Orientation.HORIZONTAL) {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d6 += this.snapSizeX(node.prefWidth(-1.0)) + this.getSpacing();
            }
            d6 -= this.getSpacing();
        } else {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d6 = Math.max(d6, this.snapSizeX(node.prefWidth(-1.0)));
            }
            if (toolBar.getItems().size() > 0) {
                this.savedPrefWidth = d6;
            } else {
                d6 = this.savedPrefWidth;
            }
        }
        return d5 + d6 + d3;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        if (toolBar.getOrientation() == Orientation.VERTICAL) {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d6 += this.snapSizeY(node.prefHeight(-1.0)) + this.getSpacing();
            }
            d6 -= this.getSpacing();
        } else {
            for (Node node : toolBar.getItems()) {
                if (!node.isManaged()) continue;
                d6 = Math.max(d6, this.snapSizeY(node.prefHeight(-1.0)));
            }
            if (toolBar.getItems().size() > 0) {
                this.savedPrefHeight = d6;
            } else {
                d6 = this.savedPrefHeight;
            }
        }
        return d2 + d6 + d4;
    }

    @Override
    protected double computeMaxWidth(double d, double d2, double d3, double d4, double d5) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.snapSizeX(((ToolBar)this.getSkinnable()).prefWidth(-1.0)) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        return ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : this.snapSizeY(((ToolBar)this.getSkinnable()).prefHeight(-1.0));
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        double d5 = this.getToolbarLength(toolBar);
        if (toolBar.getOrientation() == Orientation.VERTICAL) {
            if (this.snapSizeY(toolBar.getHeight()) != this.previousHeight || this.needsUpdate) {
                ((VBox)this.box).setSpacing(this.getSpacing());
                ((VBox)this.box).setAlignment(this.getBoxAlignment());
                this.previousHeight = this.snapSizeY(toolBar.getHeight());
                this.addNodesToToolBar();
            } else {
                this.organizeOverflow(d5);
            }
        } else if (this.snapSizeX(toolBar.getWidth()) != this.previousWidth || this.needsUpdate) {
            ((HBox)this.box).setSpacing(this.getSpacing());
            ((HBox)this.box).setAlignment(this.getBoxAlignment());
            this.previousWidth = this.snapSizeX(toolBar.getWidth());
            this.addNodesToToolBar();
        } else {
            this.organizeOverflow(d5);
        }
        this.needsUpdate = false;
        double d6 = d3;
        double d7 = d4;
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            d7 -= this.overflow ? this.snapSizeY(this.overflowMenu.prefHeight(-1.0)) : 0.0;
        } else {
            d6 -= this.overflow ? this.snapSizeX(this.overflowMenu.prefWidth(-1.0)) : 0.0;
        }
        this.box.resize(d6, d7);
        this.positionInArea((Node)this.box, d, d2, d6, d7, 0.0, HPos.CENTER, VPos.CENTER);
        if (this.overflow) {
            double d8 = this.snapSizeX(this.overflowMenu.prefWidth(-1.0));
            double d9 = this.snapSizeY(this.overflowMenu.prefHeight(-1.0));
            double d10 = d;
            double d11 = d;
            if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                HPos hPos;
                if (d6 == 0.0) {
                    d6 = this.savedPrefWidth;
                }
                d10 = HPos.LEFT.equals((Object)(hPos = ((VBox)this.box).getAlignment().getHpos())) ? d + Math.abs((d6 - d8) / 2.0) : (HPos.RIGHT.equals((Object)hPos) ? this.snapSizeX(toolBar.getWidth()) - this.snappedRightInset() - d6 + Math.abs((d6 - d8) / 2.0) : d + Math.abs((this.snapSizeX(toolBar.getWidth()) - d + this.snappedRightInset() - d8) / 2.0));
                d11 = this.snapSizeY(toolBar.getHeight()) - d9 - d2;
            } else {
                VPos vPos;
                if (d7 == 0.0) {
                    d7 = this.savedPrefHeight;
                }
                d11 = VPos.TOP.equals((Object)(vPos = ((HBox)this.box).getAlignment().getVpos())) ? d2 + Math.abs((d7 - d9) / 2.0) : (VPos.BOTTOM.equals((Object)vPos) ? this.snapSizeY(toolBar.getHeight()) - this.snappedBottomInset() - d7 + Math.abs((d7 - d9) / 2.0) : d2 + Math.abs((d7 - d9) / 2.0));
                d10 = this.snapSizeX(toolBar.getWidth()) - d8 - this.snappedRightInset();
            }
            this.overflowMenu.resize(d8, d9);
            this.positionInArea((Node)this.overflowMenu, d10, d11, d8, d9, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    private void initialize() {
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            this.box = new VBox();
            this.overflowBox = new VBox();
        } else {
            this.box = new HBox();
            this.overflowBox = new HBox();
        }
        this.box.getStyleClass().add((Object)"container");
        this.box.getChildren().addAll(((ToolBar)this.getSkinnable()).getItems());
        this.overflowBox.idProperty().bind((ObservableValue)this.box.idProperty());
        Bindings.bindContent((List)this.overflowBox.getStyleClass(), (ObservableList)this.box.getStyleClass());
        Bindings.bindContent((List)this.overflowBox.getStylesheets(), (ObservableList)this.box.getStylesheets());
        this.box.getPseudoClassStates().addListener(change -> {
            if (change.wasAdded()) {
                this.overflowBox.pseudoClassStateChanged((PseudoClass)change.getElementAdded(), true);
            } else if (change.wasRemoved()) {
                this.overflowBox.pseudoClassStateChanged((PseudoClass)change.getElementRemoved(), false);
            }
        });
        this.overflowBox.setManaged(false);
        this.overflowBox.setVisible(false);
        this.overflowMenu = new ToolBarOverflowMenu((ObservableList<Node>)this.overflowBox.getChildren());
        this.overflowMenu.setVisible(false);
        this.overflowMenu.setManaged(false);
        this.getChildren().clear();
        this.getChildren().add((Object)this.box);
        this.getChildren().add((Object)this.overflowBox);
        this.getChildren().add((Object)this.overflowMenu);
        this.previousWidth = 0.0;
        this.previousHeight = 0.0;
        this.savedPrefWidth = 0.0;
        this.savedPrefHeight = 0.0;
        this.needsUpdate = true;
        ((ToolBar)this.getSkinnable()).requestLayout();
    }

    private void organizeOverflow(double d) {
        Node node;
        int n = this.getOverflowNodeIndex(d);
        if (n < ((ToolBar)this.getSkinnable()).getItems().size()) {
            d = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (d -= this.snapSizeY(this.overflowMenu.prefHeight(-1.0))) : (d -= this.snapSizeX(this.overflowMenu.prefWidth(-1.0)));
            n = this.getOverflowNodeIndex(d -= this.getSpacing());
        }
        if (!this.needsUpdate && n == this.overflowNodeIndex) {
            return;
        }
        ObservableList<Node> observableList = ((ToolBar)this.getSkinnable()).getItems();
        this.box.getChildren().clear();
        this.overflowBox.getChildren().clear();
        for (int i = 0; i < observableList.size(); ++i) {
            Node node2 = (Node)observableList.get(i);
            node2.getStyleClass().remove((Object)"menu-item");
            node2.getStyleClass().remove((Object)"custom-menu-item");
            if (i < n) {
                this.box.getChildren().add((Object)node2);
                continue;
            }
            this.overflowBox.getChildren().add((Object)node2);
            if (!node2.isFocused()) continue;
            if (!this.box.getChildren().isEmpty()) {
                Node node3 = this.engine.selectLast();
                if (node3 == null) continue;
                node3.requestFocus();
                continue;
            }
            this.overflowMenu.requestFocus();
        }
        this.overflow = !this.overflowBox.getChildren().isEmpty();
        this.overflowNodeIndex = n;
        if (!this.overflow && this.overflowMenu.isFocused() && (node = this.engine.selectLast()) != null) {
            node.requestFocus();
        }
        this.overflowMenu.setVisible(this.overflow);
        this.overflowMenu.setManaged(this.overflow);
    }

    private void addNodesToToolBar() {
        ToolBar toolBar = (ToolBar)this.getSkinnable();
        double d = this.getToolbarLength(toolBar);
        this.overflowNodeIndex = Integer.MAX_VALUE;
        this.organizeOverflow(d);
    }

    private double getToolbarLength(ToolBar toolBar) {
        if (((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.snapSizeY(this.snapSizeY(toolBar.getHeight()) - this.snappedTopInset() - this.snappedBottomInset() + this.getSpacing());
        }
        return this.snapSizeX(this.snapSizeX(toolBar.getWidth()) - this.snappedLeftInset() - this.snappedRightInset() + this.getSpacing());
    }

    private int getOverflowNodeIndex(double d) {
        ObservableList<Node> observableList = ((ToolBar)this.getSkinnable()).getItems();
        int n = observableList.size();
        double d2 = 0.0;
        for (int i = 0; i < observableList.size(); ++i) {
            Node node = (Node)observableList.get(i);
            if (node.isManaged()) {
                d2 = ((ToolBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (d2 += this.snapSizeY(node.prefHeight(-1.0)) + this.getSpacing()) : (d2 += this.snapSizeX(node.prefWidth(-1.0)) + this.getSpacing());
            }
            if (!(d2 > d)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToolBarSkin.getClassCssMetaData();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case OVERFLOW_BUTTON: {
                return this.overflowMenu;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case SHOW_MENU: {
                this.overflowMenu.fire();
                break;
            }
            default: {
                super.executeAccessibleAction(accessibleAction, objectArray);
            }
        }
    }

    class ToolBarOverflowMenu
    extends StackPane {
        private StackPane downArrow;
        private ContextMenu popup;
        private ObservableList<Node> overflowItems;

        public ToolBarOverflowMenu(ObservableList<Node> observableList) {
            this.getStyleClass().setAll((Object[])new String[]{"tool-bar-overflow-button"});
            this.setAccessibleRole(AccessibleRole.BUTTON);
            this.setAccessibleText(ControlResources.getString("Accessibility.title.ToolBar.OverflowButton"));
            this.setFocusTraversable(true);
            this.overflowItems = observableList;
            this.downArrow = new StackPane();
            this.downArrow.getStyleClass().setAll((Object[])new String[]{"arrow"});
            this.downArrow.setOnMousePressed(mouseEvent -> this.fire());
            this.setOnKeyPressed(keyEvent -> {
                if (KeyCode.SPACE.equals((Object)keyEvent.getCode())) {
                    if (!this.popup.isShowing()) {
                        this.popup.getItems().clear();
                        this.popup.getItems().addAll(this.createMenuItems());
                        this.popup.show((Node)this.downArrow, Side.BOTTOM, 0.0, 0.0);
                    }
                    keyEvent.consume();
                } else if (KeyCode.ESCAPE.equals((Object)keyEvent.getCode())) {
                    if (this.popup.isShowing()) {
                        this.popup.hide();
                    }
                    keyEvent.consume();
                } else if (KeyCode.ENTER.equals((Object)keyEvent.getCode())) {
                    this.fire();
                    keyEvent.consume();
                }
            });
            this.visibleProperty().addListener((observableValue, bl, bl2) -> {
                if (bl2.booleanValue() && ToolBarSkin.this.box.getChildren().isEmpty()) {
                    this.setFocusTraversable(true);
                }
            });
            this.popup = new ContextMenu();
            this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, windowEvent -> {
                this.overflowItems.clear();
                for (Node node : ((ToolBar)ToolBarSkin.this.getSkinnable()).getItems()) {
                    if (ToolBarSkin.this.box.getChildren().contains((Object)node)) continue;
                    this.overflowItems.add((Object)node);
                }
            });
            this.setVisible(false);
            this.setManaged(false);
            this.getChildren().add((Object)this.downArrow);
        }

        private void fire() {
            if (this.popup.isShowing()) {
                this.popup.hide();
            } else {
                this.popup.getItems().clear();
                this.popup.getItems().addAll(this.createMenuItems());
                this.popup.show((Node)this.downArrow, Side.BOTTOM, 0.0, 0.0);
            }
        }

        private List<MenuItem> createMenuItems() {
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            for (Node node : this.overflowItems) {
                String string;
                if (node instanceof Separator) {
                    arrayList.add(new SeparatorMenuItem());
                    continue;
                }
                CustomMenuItem customMenuItem = new CustomMenuItem(node);
                switch (string = node.getTypeSelector()) {
                    case "Button": 
                    case "Hyperlink": 
                    case "Label": {
                        customMenuItem.setHideOnClick(true);
                        break;
                    }
                    default: {
                        customMenuItem.setHideOnClick(false);
                    }
                }
                arrayList.add(customMenuItem);
            }
            return arrayList;
        }

        protected double computePrefWidth(double d) {
            return this.snappedLeftInset() + this.snappedRightInset();
        }

        protected double computePrefHeight(double d) {
            return this.snappedTopInset() + this.snappedBottomInset();
        }

        protected void layoutChildren() {
            double d = this.snapSizeX(this.downArrow.prefWidth(-1.0));
            double d2 = this.snapSizeY(this.downArrow.prefHeight(-1.0));
            double d3 = (this.snapSizeX(this.getWidth()) - d) / 2.0;
            double d4 = (this.snapSizeY(this.getHeight()) - d2) / 2.0;
            if (((ToolBar)ToolBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                this.downArrow.setRotate(0.0);
            }
            this.downArrow.resize(d, d2);
            this.positionInArea((Node)this.downArrow, d3, d4, d, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }

        public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
            switch (accessibleAction) {
                case FIRE: {
                    this.fire();
                    break;
                }
                default: {
                    super.executeAccessibleAction(accessibleAction, new Object[0]);
                }
            }
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<ToolBar, Number> SPACING = new CssMetaData<ToolBar, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

            public boolean isSettable(ToolBar toolBar) {
                ToolBarSkin toolBarSkin = (ToolBarSkin)toolBar.getSkin();
                return toolBarSkin.spacing == null || !toolBarSkin.spacing.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ToolBar toolBar) {
                ToolBarSkin toolBarSkin = (ToolBarSkin)toolBar.getSkin();
                return (StyleableProperty)toolBarSkin.spacingProperty();
            }
        };
        private static final CssMetaData<ToolBar, Pos> ALIGNMENT = new CssMetaData<ToolBar, Pos>("-fx-alignment", (StyleConverter)new EnumConverter(Pos.class), Pos.TOP_LEFT){

            public boolean isSettable(ToolBar toolBar) {
                ToolBarSkin toolBarSkin = (ToolBarSkin)toolBar.getSkin();
                return toolBarSkin.boxAlignment == null || !toolBarSkin.boxAlignment.isBound();
            }

            public StyleableProperty<Pos> getStyleableProperty(ToolBar toolBar) {
                ToolBarSkin toolBarSkin = (ToolBarSkin)toolBar.getSkin();
                return (StyleableProperty)toolBarSkin.boxAlignmentProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(SkinBase.getClassCssMetaData());
            String string = ALIGNMENT.getProperty();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                CssMetaData cssMetaData = (CssMetaData)arrayList.get(i);
                if (!string.equals(cssMetaData.getProperty())) continue;
                arrayList.remove(cssMetaData);
            }
            arrayList.add(SPACING);
            arrayList.add(ALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

