/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ContextMenuContent;
import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.behavior.MenuButtonBehavior;
import javafx.event.ActionEvent;
import javafx.event.EventTarget;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.MenuButton;
import javafx.scene.control.skin.MenuButtonSkinBase;
import javafx.stage.WindowEvent;

public class MenuButtonSkin
extends MenuButtonSkinBase<MenuButton> {
    static final String AUTOHIDE = "autoHide";
    private final MenuButtonBehavior behavior;

    public MenuButtonSkin(MenuButton menuButton) {
        super(menuButton);
        this.behavior = new MenuButtonBehavior(menuButton);
        this.popup.setOnAutoHide(event -> {
            MenuButton menuButton = (MenuButton)this.getSkinnable();
            if (!menuButton.getProperties().containsKey((Object)AUTOHIDE)) {
                menuButton.getProperties().put((Object)AUTOHIDE, (Object)Boolean.TRUE);
            }
        });
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        listenerHelper.addEventHandler((EventTarget)this.popup, WindowEvent.WINDOW_SHOWN, windowEvent -> {
            if (this.requestFocusOnFirstMenuItem) {
                this.requestFocusOnFirstMenuItem();
                this.requestFocusOnFirstMenuItem = false;
            } else {
                ContextMenuContent contextMenuContent = (ContextMenuContent)this.popup.getSkin().getNode();
                if (contextMenuContent != null) {
                    contextMenuContent.requestFocus();
                }
            }
        });
        listenerHelper.addEventHandler((EventTarget)menuButton, ActionEvent.ACTION, actionEvent -> menuButton.show());
        this.label.setLabelFor((Node)menuButton);
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        this.popup.setOnAutoHide(null);
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    MenuButtonBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case MNEMONIC: {
                return this.label.queryAccessibleAttribute(AccessibleAttribute.MNEMONIC, new Object[0]);
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

