/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.collections.TrackableObservableList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ContextMenuSkin;
import javafx.stage.PopupWindow;
import javafx.stage.Window;

@IDProperty(value="id")
public class ContextMenu
extends PopupControl {
    private boolean showRelativeToWindow = false;
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        protected void invalidated() {
            ContextMenu.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return ContextMenu.this;
        }

        public String getName() {
            return "onAction";
        }
    };
    private final ObservableList<MenuItem> items = new TrackableObservableList<MenuItem>(){

        protected void onChanged(ListChangeListener.Change<MenuItem> change) {
            while (change.next()) {
                for (MenuItem menuItem : change.getRemoved()) {
                    menuItem.setParentPopup(null);
                }
                for (MenuItem menuItem : change.getAddedSubList()) {
                    if (menuItem.getParentPopup() != null) {
                        menuItem.getParentPopup().getItems().remove((Object)menuItem);
                    }
                    menuItem.setParentPopup(ContextMenu.this);
                }
            }
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "context-menu";

    public ContextMenu() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAutoHide(true);
        this.setConsumeAutoHidingEvents(false);
    }

    public ContextMenu(MenuItem ... menuItemArray) {
        this();
        this.items.addAll((Object[])menuItemArray);
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    public void show(Node node, Side side, double d, double d2) {
        if (node == null) {
            return;
        }
        if (this.getItems().size() == 0) {
            return;
        }
        this.getScene().setNodeOrientation(node.getEffectiveNodeOrientation());
        this.setAnchorLocation(this.getAnchorLocation(side, node.getEffectiveNodeOrientation()));
        Bounds bounds = node.localToScreen(node.getLayoutBounds());
        double d3 = this.getXBySide(bounds, side, node.getEffectiveNodeOrientation()) + d;
        double d4 = this.getYBySide(bounds, side) + d2;
        this.doShow(node, d3, d4);
    }

    private PopupWindow.AnchorLocation getAnchorLocation(Side side, NodeOrientation nodeOrientation) {
        if (nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            switch (side) {
                case TOP: {
                    return PopupWindow.AnchorLocation.CONTENT_BOTTOM_RIGHT;
                }
                case RIGHT: {
                    return PopupWindow.AnchorLocation.CONTENT_TOP_RIGHT;
                }
                case BOTTOM: {
                    return PopupWindow.AnchorLocation.CONTENT_TOP_RIGHT;
                }
                case LEFT: {
                    return PopupWindow.AnchorLocation.CONTENT_TOP_LEFT;
                }
            }
        } else {
            switch (side) {
                case TOP: {
                    return PopupWindow.AnchorLocation.CONTENT_BOTTOM_LEFT;
                }
                case RIGHT: {
                    return PopupWindow.AnchorLocation.CONTENT_TOP_LEFT;
                }
                case BOTTOM: {
                    return PopupWindow.AnchorLocation.CONTENT_TOP_LEFT;
                }
                case LEFT: {
                    return PopupWindow.AnchorLocation.CONTENT_TOP_RIGHT;
                }
            }
        }
        return PopupWindow.AnchorLocation.CONTENT_TOP_LEFT;
    }

    private double getXBySide(Bounds bounds, Side side, NodeOrientation nodeOrientation) {
        if (nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            if (side == Side.RIGHT) {
                return bounds.getMinX();
            }
            return bounds.getMaxX();
        }
        if (side == Side.RIGHT) {
            return bounds.getMaxX();
        }
        return bounds.getMinX();
    }

    private double getYBySide(Bounds bounds, Side side) {
        if (side == Side.BOTTOM) {
            return bounds.getMaxY();
        }
        return bounds.getMinY();
    }

    public void show(Node node, double d, double d2) {
        if (node == null) {
            return;
        }
        if (this.getItems().size() == 0) {
            return;
        }
        this.getScene().setNodeOrientation(node.getEffectiveNodeOrientation());
        this.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_LEFT);
        this.doShow(node, d, d2);
    }

    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        Event.fireEvent((EventTarget)this, (Event)new Event(Menu.ON_HIDING));
        super.hide();
        Event.fireEvent((EventTarget)this, (Event)new Event(Menu.ON_HIDDEN));
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ContextMenuSkin(this);
    }

    final boolean isShowRelativeToWindow() {
        return this.showRelativeToWindow;
    }

    final void setShowRelativeToWindow(boolean bl) {
        this.showRelativeToWindow = bl;
    }

    private void doShow(Node node, double d, double d2) {
        Event.fireEvent((EventTarget)this, (Event)new Event(Menu.ON_SHOWING));
        if (this.isShowRelativeToWindow()) {
            Window window;
            Scene scene = node == null ? null : node.getScene();
            Window window2 = window = scene == null ? null : scene.getWindow();
            if (window == null) {
                return;
            }
            super.show(window, d, d2);
        } else {
            super.show(node, d, d2);
        }
        Event.fireEvent((EventTarget)this, (Event)new Event(Menu.ON_SHOWN));
    }
}

