/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.jfr.internal;

import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.rjmx.common.services.jfr.internal.OpenTypeConverter;

public final class RecordingDescriptorV2
implements IRecordingDescriptor {
    private static final String KEY_NAME = "name";
    private static final String KEY_ID = "id";
    private static final String KEY_START_TIME = "startTime";
    private static final String KEY_STOP_TIME = "stopTime";
    private static final String KEY_STATE = "state";
    private static final String KEY_MAX_AGE = "maxAge";
    private static final String KEY_MAX_SIZE = "maxSize";
    private static final String KEY_TO_DISK = "toDisk";
    private static final String KEY_DESTINATION = "destination";
    private static final String KEY_DURATION = "duration";
    private final String serverId;
    private final long id;
    private final String name;
    private final IRecordingDescriptor.RecordingState state;
    private final IQuantity startTime;
    private final IQuantity stopTime;
    private final IQuantity duration;
    private final IQuantity maxAge;
    private final IQuantity maxSize;
    private final boolean toDisk;
    private final String destination;

    public RecordingDescriptorV2(String serverId, CompositeData data) {
        this.serverId = serverId;
        this.id = (Long)data.get(KEY_ID);
        this.name = (String)data.get(KEY_NAME);
        this.state = RecordingDescriptorV2.decideState((String)data.get(KEY_STATE));
        this.startTime = UnitLookup.EPOCH_MS.quantity((Number)((Long)data.get(KEY_START_TIME)));
        this.stopTime = UnitLookup.EPOCH_MS.quantity((Number)((Long)data.get(KEY_STOP_TIME)));
        this.duration = OpenTypeConverter.inGuessedUnit((IQuantity)UnitLookup.SECOND.quantity((Number)((Long)data.get(KEY_DURATION))));
        this.maxAge = OpenTypeConverter.inGuessedUnit((IQuantity)UnitLookup.SECOND.quantity((Number)((Long)data.get(KEY_MAX_AGE))));
        this.maxSize = OpenTypeConverter.inGuessedUnit((IQuantity)UnitLookup.BYTE.quantity((Number)((Long)data.get(KEY_MAX_SIZE))));
        this.toDisk = (Boolean)data.get(KEY_TO_DISK);
        this.destination = (String)data.get(KEY_DESTINATION);
    }

    private static IRecordingDescriptor.RecordingState decideState(String state) {
        if ("NEW".equals(state)) {
            return IRecordingDescriptor.RecordingState.CREATED;
        }
        if ("RUNNING".equals(state) || "DELAYED".equals(state) || "STARTING".equals(state)) {
            return IRecordingDescriptor.RecordingState.RUNNING;
        }
        if ("STOPPED".equals(state)) {
            return IRecordingDescriptor.RecordingState.STOPPED;
        }
        if ("STOPPING".equals(state)) {
            return IRecordingDescriptor.RecordingState.STOPPING;
        }
        return IRecordingDescriptor.RecordingState.STOPPED;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IRecordingDescriptor.RecordingState getState() {
        return this.state;
    }

    public Map<String, ?> getOptions() {
        return null;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof RecordingDescriptorV2) {
            RecordingDescriptorV2 that = (RecordingDescriptorV2)o;
            return that.id == this.id && that.serverId.equals(this.serverId);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id ^ this.serverId.hashCode();
    }

    public String toString() {
        return "RecordingDescriptor@" + this.serverId + "[" + this.getName() + "(" + this.getId() + "), " + this.getState() + ", " + this.getOptions() + "]";
    }

    public IQuantity getDataStartTime() {
        return this.startTime;
    }

    public IQuantity getDataEndTime() {
        return this.stopTime;
    }

    public IQuantity getStartTime() {
        return this.startTime;
    }

    public IQuantity getDuration() {
        return this.duration;
    }

    public boolean isContinuous() {
        return this.duration == null || this.duration.doubleValue() == 0.0;
    }

    public boolean getToDisk() {
        return this.toDisk;
    }

    public IQuantity getMaxAge() {
        return this.maxAge;
    }

    public IQuantity getMaxSize() {
        return this.maxSize;
    }

    public String getDestination() {
        return this.destination;
    }
}

