/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.internal;

import org.openjdk.jmc.rjmx.common.ISyntheticNotification;
import org.openjdk.jmc.rjmx.common.subscription.MRI;

public class SyntheticNotificationEntry {
    private ISyntheticNotification notification;
    private final MRI descriptor;
    private final String description;
    private final String type;
    private final String message;

    public SyntheticNotificationEntry(ISyntheticNotification notification, MRI descriptor, String description, String type, String message) {
        this.notification = notification;
        this.descriptor = descriptor;
        this.description = description;
        this.type = type;
        this.message = message;
    }

    public void setNotification(ISyntheticNotification notification) {
        this.notification = notification;
    }

    public ISyntheticNotification getNotification() {
        return this.notification;
    }

    public String getName() {
        return this.descriptor.getQualifiedName();
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public MRI getNotificationDescriptor() {
        return this.descriptor;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getName() + "[" + this.type + "]";
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyntheticNotificationEntry other = (SyntheticNotificationEntry)obj;
        return !(this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor));
    }
}

