/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.shotdetector;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.pixel.statistics.HistogramModel;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.video.Video;
import org.openimaj.video.processing.shotdetector.VideoShotDetector;

@Reference(type=ReferenceType.Inproceedings, author={"{S}teiner, {T}homas", "{V}erborgh, {R}uben", "{G}abarr{'o} {V}all{'e}s, {J}oaquim", "{T}roncy, {R}apha{\"e}l", "{H}ausenblas, {M}ichael", "{V}an de {W}alle, {R}ik", "{B}rousseau, {A}rnaud"}, title="{E}nabling on-the-fly video shot detection on {Y}ou{T}ube", year="2012", booktitle="{WWW} 2012, 21st {I}nternational {W}orld {W}ide {W}eb {C}onference {D}eveloper's {T}rack, {A}pril 16-20, 2012, {L}yon, {F}rance", url="http://www.eurecom.fr/publication/3676", month="04", customData={"address", "{L}yon, {FRANCE}"})
public class LocalHistogramVideoShotDetector
extends VideoShotDetector<MBFImage> {
    private final HistogramModel histogramModel = new HistogramModel(new int[]{4, 4, 4});
    private double[][][] lastHistogram = null;
    private int nGridElements = 20;
    private final double pcMostSimilar = 0.1;
    private final double pcMostDissimilar = 0.1;
    private final double boostFactor = 1.1;
    private final double limitingFactor = 0.9;

    public LocalHistogramVideoShotDetector(int nGridElements) {
        this.nGridElements = nGridElements;
        this.lastHistogram = new double[this.nGridElements][this.nGridElements][];
        this.threshold = 0.2;
    }

    public LocalHistogramVideoShotDetector(Video<MBFImage> video, int nGridElements) {
        super(video);
        this.nGridElements = nGridElements;
        this.lastHistogram = new double[nGridElements][nGridElements][];
        this.threshold = 0.2;
    }

    @Override
    protected double getInterframeDistance(MBFImage frame) {
        double[][] avgHisto = new double[this.nGridElements][this.nGridElements];
        int gw = frame.getWidth() / this.nGridElements;
        int gh = frame.getHeight() / this.nGridElements;
        for (int y = 0; y < this.nGridElements; ++y) {
            for (int x = 0; x < this.nGridElements; ++x) {
                MBFImage img = (MBFImage)frame.extractROI(x * gw, y * gh, gw, gh);
                this.histogramModel.estimateModel(new MBFImage[]{img});
                double[] histogram = this.histogramModel.histogram.asDoubleVector();
                if (this.lastHistogram[y][x] != null) {
                    double dist;
                    avgHisto[y][x] = dist = DoubleFVComparison.EUCLIDEAN.compare(histogram, this.lastHistogram[y][x]);
                }
                this.lastHistogram[y][x] = histogram;
            }
        }
        double[] flattenedAvgHisto = ArrayUtils.reshape((double[][])avgHisto);
        int[] indices = new int[this.nGridElements * this.nGridElements];
        ArrayUtils.parallelQuicksortDescending((double[])flattenedAvgHisto, (int[])ArrayUtils.fill((int[])indices));
        double[][] similarDissimilar = new double[this.nGridElements][this.nGridElements];
        for (int index = 0; index < indices.length; ++index) {
            double factor = 1.0;
            double d = index;
            double d2 = this.nGridElements * this.nGridElements;
            ((Object)((Object)this)).getClass();
            if (d < d2 * 0.1) {
                factor = this.limitingFactor;
            } else {
                double d3 = index;
                double d4 = this.nGridElements * this.nGridElements;
                ((Object)((Object)this)).getClass();
                factor = d3 >= d4 * (1.0 - 0.1) ? this.boostFactor : 1.0;
            }
            int y = indices[index] / this.nGridElements;
            int x = indices[index] % this.nGridElements;
            similarDissimilar[y][x] = factor;
        }
        for (int y = 0; y < this.nGridElements; ++y) {
            for (int x = 0; x < this.nGridElements; ++x) {
                double[] dArray = avgHisto[y];
                int n = x;
                dArray[n] = dArray[n] * similarDissimilar[y][x];
            }
        }
        flattenedAvgHisto = ArrayUtils.reshape((double[][])avgHisto);
        double avgDist = ArrayUtils.sumValues((double[])flattenedAvgHisto);
        ArrayUtils.subtract((double[])flattenedAvgHisto, (double)(avgDist /= (double)(this.nGridElements * this.nGridElements)));
        double stdDev = Math.sqrt(ArrayUtils.sumValuesSquared((double[])flattenedAvgHisto) / (double)(this.nGridElements * this.nGridElements));
        return stdDev;
    }

    protected void drawBoxes(MBFImage img, double[][] sim) {
        int gw = img.getWidth() / this.nGridElements;
        int gh = img.getHeight() / this.nGridElements;
        for (int y = 0; y < this.nGridElements; ++y) {
            for (int x = 0; x < this.nGridElements; ++x) {
                Float[] c = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
                c = sim[y][x] == this.boostFactor ? RGBColour.RED : (sim[y][x] == this.limitingFactor ? RGBColour.BLUE : RGBColour.BLACK);
                img.drawShape((Shape)new Rectangle((float)(x * gw), (float)(y * gh), (float)gw, (float)gh), (Object)c);
            }
        }
    }
}

