/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.hog;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.analysis.algorithm.histogram.binning.SpatialBinningStrategy;
import org.openimaj.image.feature.dense.gradient.HOG;
import org.openimaj.image.feature.dense.gradient.binning.FlexibleHOGStrategy;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.statistics.distribution.Histogram;
import org.openimaj.util.pair.ObjectDoublePair;

public class Test {
    public static void main(String[] args) throws IOException {
        FImage img = ImageUtilities.readF((URL)new URL("http://www.di.ens.fr/willow/teaching/recvis10/final_project/detection/car-img1.png"));
        HOG h = new HOG((SpatialBinningStrategy)new FlexibleHOGStrategy(8, 8, 2));
        h.analyseImage(img);
        Rectangle r = new Rectangle(47.0f, 92.0f, 30.0f, 30.0f);
        Histogram f = h.getFeatureVector(r).clone();
        img.drawShape((Shape)r, (Object)Float.valueOf(1.0f));
        DisplayUtilities.display((Image)img);
        FImage img2 = ImageUtilities.readF((URL)new URL("http://www.di.ens.fr/willow/teaching/recvis10/final_project/detection/car-img3.png"));
        h.analyseImage(img2);
        ArrayList<ObjectDoublePair> data = new ArrayList<ObjectDoublePair>();
        for (int y = 0; y < img2.height - 30; ++y) {
            for (int x = 0; x < img2.width - 30; ++x) {
                Rectangle rr = new Rectangle((float)x, (float)y, 30.0f, 30.0f);
                Histogram ff = h.getFeatureVector(rr);
                double c = DoubleFVComparison.EUCLIDEAN.compare((DoubleFV)f, (DoubleFV)ff);
                data.add(ObjectDoublePair.pair((Object)rr, (double)c));
            }
        }
        Collections.sort(data, new Comparator<ObjectDoublePair<Rectangle>>(){

            @Override
            public int compare(ObjectDoublePair<Rectangle> o1, ObjectDoublePair<Rectangle> o2) {
                return Double.compare(o1.second, o2.second);
            }
        });
        for (int i = 0; i < 10; ++i) {
            img2.drawShape((Shape)((ObjectDoublePair)data.get((int)i)).first, (Object)Float.valueOf(1.0f));
        }
        DisplayUtilities.display((Image)img2);
    }
}

