/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.hog;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.objectdetection.AbstractMultiScaleObjectDetector;
import org.openimaj.image.objectdetection.hog.HOGClassifier;
import org.openimaj.math.geometry.shape.Rectangle;

public class HOGDetector
extends AbstractMultiScaleObjectDetector<FImage, Rectangle> {
    protected float scaleFactor = 1.2f;
    protected HOGClassifier classifier;
    double threshold = 0.5;

    public HOGDetector(HOGClassifier classifier, float scaleFactor) {
        this.classifier = classifier;
        this.scaleFactor = scaleFactor;
    }

    public HOGDetector(HOGClassifier classifier) {
        this.classifier = classifier;
    }

    @Override
    public List<Rectangle> detect(FImage image) {
        ArrayList<Rectangle> results = new ArrayList<Rectangle>();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        this.classifier.prepare(image);
        int nFactors = 0;
        int startFactor = 0;
        float factor = 1.0f;
        while (factor * (float)this.classifier.width < (float)imageWidth && factor * (float)this.classifier.height < (float)imageHeight) {
            float width = factor * (float)this.classifier.width;
            float height = factor * (float)this.classifier.height;
            if (width < (float)this.minSize || height < (float)this.minSize) {
                ++startFactor;
            }
            if (this.maxSize > 0 && (width > (float)this.maxSize || height > (float)this.maxSize)) break;
            ++nFactors;
            factor *= this.scaleFactor;
        }
        factor = (float)Math.pow(this.scaleFactor, startFactor);
        for (int scaleStep = startFactor; scaleStep < nFactors; ++scaleStep) {
            float ystep = 8.0f * factor;
            int windowWidth = (int)(factor * (float)this.classifier.width);
            int windowHeight = (int)(factor * (float)this.classifier.height);
            int startX = (int)(this.roi == null ? 0.0f : Math.max(0.0f, this.roi.x));
            int startY = (int)(this.roi == null ? 0.0f : Math.max(0.0f, this.roi.y));
            int stopX = Math.round((this.roi == null ? (float)imageWidth : Math.min((float)imageWidth, this.roi.x + this.roi.width)) - (float)windowWidth);
            int stopY = Math.round((this.roi == null ? (float)imageHeight : Math.min((float)imageHeight, this.roi.y + this.roi.height)) - (float)windowHeight);
            this.detectAtScale(startX, stopX, startY, stopY, ystep, windowWidth, windowHeight, results);
            factor *= this.scaleFactor;
        }
        return results;
    }

    protected void detectAtScale(int startX, int stopX, int startY, int stopY, float ystep, int windowWidth, int windowHeight, List<Rectangle> results) {
        Rectangle current = new Rectangle();
        int iy = startY;
        while (iy < stopY) {
            int ix = startX;
            while (ix < stopX) {
                current.x = ix;
                current.y = iy;
                current.width = windowWidth;
                current.height = windowHeight;
                if (this.classifier.classify(current) > this.threshold) {
                    results.add(current.clone());
                }
                ix = (int)((float)ix + ystep);
            }
            iy = (int)((float)iy + ystep);
        }
    }
}

