/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.objectdetection.ObjectDetector;
import org.openimaj.image.objectdetection.TransformedDetection;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class RotationSimulationObjectDetector<IMAGE extends Image<PIXEL, IMAGE>, PIXEL, DETECTED_OBJECT>
implements ObjectDetector<IMAGE, TransformedDetection<DETECTED_OBJECT>> {
    private ObjectDetector<IMAGE, DETECTED_OBJECT> detector;
    private Rectangle roi;
    private float scalefactor = 1.0f;
    private float[] simulationAngles;

    public RotationSimulationObjectDetector(ObjectDetector<IMAGE, DETECTED_OBJECT> detector, int numRotations) {
        this.detector = detector;
        this.simulationAngles = this.computeAngles(numRotations);
    }

    public RotationSimulationObjectDetector(ObjectDetector<IMAGE, DETECTED_OBJECT> detector, int numRotations, float scalefactor) {
        this(detector, numRotations);
        this.scalefactor = scalefactor;
    }

    public RotationSimulationObjectDetector(ObjectDetector<IMAGE, DETECTED_OBJECT> detector, float[] simulationAngles, float scalefactor) {
        this.detector = detector;
        this.simulationAngles = simulationAngles;
        this.scalefactor = scalefactor;
    }

    private float[] computeAngles(int numRotations) {
        float[] angles = new float[numRotations];
        for (int i = 1; i < numRotations; ++i) {
            angles[i] = (float)((double)(2 * i) * Math.PI / (double)numRotations);
        }
        return angles;
    }

    @Override
    public List<TransformedDetection<DETECTED_OBJECT>> detect(IMAGE image) {
        Matrix scale;
        ArrayList<TransformedDetection<DETECTED_OBJECT>> results = new ArrayList<TransformedDetection<DETECTED_OBJECT>>();
        if (this.scalefactor != 1.0f) {
            image = ((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)new ResizeProcessor(this.scalefactor));
            scale = TransformUtilities.scaleMatrix((double)this.scalefactor, (double)this.scalefactor);
        } else {
            scale = Matrix.identity((int)3, (int)3);
        }
        for (float angle : this.simulationAngles) {
            if (angle == 0.0f) {
                this.detectObjects(image, scale, results);
                continue;
            }
            Matrix matrix = TransformUtilities.rotationMatrix((double)angle);
            Image rimg = ProjectionProcessor.project(image, (Matrix)matrix);
            Rectangle actualBounds = image.getBounds();
            Shape transformedActualBounds = actualBounds.transform(matrix);
            double tminX = transformedActualBounds.minX();
            double tminY = transformedActualBounds.minY();
            int minc = (int)Math.floor(tminX);
            int minr = (int)Math.floor(tminY);
            matrix.set(0, 2, (double)(-minc));
            matrix.set(1, 2, (double)(-minr));
            this.detectObjects(rimg, matrix.times(scale), results);
        }
        return results;
    }

    private void detectObjects(IMAGE image, Matrix transform, List<TransformedDetection<DETECTED_OBJECT>> results) {
        List<DETECTED_OBJECT> detections;
        if (this.roi != null) {
            Rectangle troi = this.roi.transform(transform).calculateRegularBoundingBox();
            this.detector.setROI(troi);
        }
        if ((detections = this.detector.detect(image)) == null) {
            return;
        }
        for (DETECTED_OBJECT o : detections) {
            results.add(new TransformedDetection<DETECTED_OBJECT>(o, transform.inverse()));
        }
    }

    @Override
    public void setROI(Rectangle roi) {
        this.roi = roi;
    }

    public ObjectDetector<IMAGE, DETECTED_OBJECT> getInnerDetector() {
        return this.detector;
    }
}

