/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.engine.MersenneTwister;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.lsh.functions.IntHashFunction;
import org.openimaj.lsh.functions.IntHashFunctionFactory;
import org.openimaj.util.array.SparseIntArray;

@Reference(type=ReferenceType.Inproceedings, author={"Datar, Mayur", "Immorlica, Nicole", "Indyk, Piotr", "Mirrokni, Vahab S."}, title="Locality-sensitive hashing scheme based on p-stable distributions", year="2004", booktitle="Proceedings of the twentieth annual symposium on Computational geometry", pages={"253", "", "262"}, url="http://doi.acm.org/10.1145/997817.997857", publisher="ACM", series="SCG '04")
public abstract class IntPStableFactory
extends IntHashFunctionFactory {
    double w;

    public IntPStableFactory(int ndims, MersenneTwister rng, double w) {
        super(ndims, rng);
        this.w = w;
    }

    protected abstract class PStableFunction
    extends IntHashFunction {
        protected double[] r;
        protected double b;

        PStableFunction(MersenneTwister rng) {
            super(rng);
        }

        public final int computeHashCode(int[] point) {
            double val = 0.0;
            for (int i = 0; i < point.length; ++i) {
                val += (double)point[i] * this.r[i];
            }
            val = (val + this.b) / IntPStableFactory.this.w;
            return (int)Math.floor(val);
        }

        @Override
        public int computeHashCode(SparseIntArray array) {
            double val = 0.0;
            for (SparseIntArray.Entry e : array.entries()) {
                val += (double)e.value * this.r[e.index];
            }
            val = (val + this.b) / IntPStableFactory.this.w;
            return (int)Math.floor(val);
        }
    }
}

