/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataSource;
import org.openimaj.io.IOUtils;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.knn.ByteNearestNeighbours;
import org.openimaj.knn.ByteNearestNeighboursExact;
import org.openimaj.knn.IncrementalNearestNeighbours;
import org.openimaj.knn.pq.ByteProductQuantiser;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

@Reference(type=ReferenceType.Article, author={"Jegou, Herve", "Douze, Matthijs", "Schmid, Cordelia"}, title="Product Quantization for Nearest Neighbor Search", year="2011", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"117", "", "128"}, url="http://dx.doi.org/10.1109/TPAMI.2010.57", month="January", number="1", publisher="IEEE Computer Society", volume="33", customData={"issn", "0162-8828", "numpages", "12", "doi", "10.1109/TPAMI.2010.57", "acmid", "1916695", "address", "Washington, DC, USA", "keywords", "High-dimensional indexing, High-dimensional indexing, image indexing, very large databases, approximate search., approximate search., image indexing, very large databases"})
public class IncrementalByteADCNearestNeighbours
extends ByteNearestNeighbours
implements IncrementalNearestNeighbours<byte[], float[], IntFloatPair>,
ReadWriteableBinary {
    protected ByteProductQuantiser pq;
    protected int ndims;
    protected List<byte[]> data;

    protected IncrementalByteADCNearestNeighbours() {
    }

    public IncrementalByteADCNearestNeighbours(ByteProductQuantiser pq, byte[][] dataPoints) {
        this.pq = pq;
        this.ndims = dataPoints[0].length;
        this.data = new ArrayList<byte[]>(dataPoints.length);
        for (int i = 0; i < dataPoints.length; ++i) {
            this.data.add(pq.quantise(dataPoints[i]));
        }
    }

    public IncrementalByteADCNearestNeighbours(ByteProductQuantiser pq, List<byte[]> dataPoints) {
        this.pq = pq;
        this.ndims = dataPoints.get(0).length;
        int size = dataPoints.size();
        this.data = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            this.data.add(pq.quantise(dataPoints.get(i)));
        }
    }

    public IncrementalByteADCNearestNeighbours(ByteProductQuantiser pq, DataSource<byte[]> dataPoints) {
        this.pq = pq;
        this.ndims = ((byte[])dataPoints.getData(0)).length;
        int size = dataPoints.size();
        this.data = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            this.data.add(pq.quantise((byte[])dataPoints.getData(i)));
        }
    }

    public IncrementalByteADCNearestNeighbours(ByteProductQuantiser pq, int ndims) {
        this.pq = pq;
        this.ndims = ndims;
        this.data = new ArrayList<byte[]>();
    }

    public IncrementalByteADCNearestNeighbours(ByteProductQuantiser pq, int ndims, int nitems) {
        this.pq = pq;
        this.ndims = ndims;
        this.data = new ArrayList<byte[]>(nitems);
    }

    @Override
    public int[] addAll(List<byte[]> d) {
        int[] indexes = new int[d.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.add(d.get(i));
        }
        return indexes;
    }

    @Override
    public int add(byte[] o) {
        int ret = this.data.size();
        this.data.add(this.pq.quantise(o));
        return ret;
    }

    @Override
    public int numDimensions() {
        return this.ndims;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public void readBinary(DataInput in) throws IOException {
        this.pq = (ByteProductQuantiser)IOUtils.read((DataInput)in);
        this.ndims = in.readInt();
        int size = in.readInt();
        int dim = this.pq.assigners.length;
        this.data = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            byte[] bytes = new byte[dim];
            in.readFully(bytes);
            this.data.add(bytes);
        }
    }

    public byte[] binaryHeader() {
        return "IByteADCNN".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        IOUtils.write((Object)this.pq, (DataOutput)out);
        out.writeInt(this.ndims);
        int size = this.data.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.write(this.data.get(i));
        }
    }

    public void searchNN(byte[][] qus, int[] indices, float[] distances) {
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(byte[][] qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.data.size());
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public void searchNN(List<byte[]> qus, int[] indices, float[] distances) {
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(List<byte[]> qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.data.size());
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public List<IntFloatPair> searchKNN(byte[] query, int K) {
        K = Math.min(K, this.data.size());
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list);
    }

    @Override
    public IntFloatPair searchNN(byte[] query) {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list).get(0);
    }

    private List<IntFloatPair> search(byte[] query, BoundedPriorityQueue<IntFloatPair> queue, List<IntFloatPair> results) {
        IntFloatPair wp = null;
        for (IntFloatPair p : results) {
            p.second = Float.MAX_VALUE;
            p.first = -1;
            wp = (IntFloatPair)queue.offerItem((Object)p);
        }
        this.computeDistances(query, queue, wp);
        return queue.toOrderedListDestructive();
    }

    protected void computeDistances(byte[] fullQuery, BoundedPriorityQueue<IntFloatPair> queue, IntFloatPair wp) {
        float[][] distances = new float[this.pq.assigners.length][];
        int from = 0;
        for (int j = 0; j < this.pq.assigners.length; ++j) {
            ByteNearestNeighboursExact nn = this.pq.assigners[j];
            int to = ((ByteNearestNeighbours)nn).numDimensions();
            int K = nn.size();
            byte[][] qus = new byte[][]{Arrays.copyOfRange(fullQuery, from, from + to)};
            int[][] idx = new int[1][K];
            float[][] dst = new float[1][K];
            nn.searchKNN((DATA[])qus, K, idx, (DISTANCES[])dst);
            distances[j] = new float[K];
            for (int k = 0; k < K; ++k) {
                distances[j][idx[0][k]] = dst[0][k];
            }
            from += to;
        }
        int size = this.data.size();
        for (int i = 0; i < size; ++i) {
            wp.first = i;
            wp.second = 0.0f;
            for (int j = 0; j < this.pq.assigners.length; ++j) {
                int centroid = this.data.get(i)[j] + 128;
                wp.second += distances[j][centroid];
            }
            wp = (IntFloatPair)queue.offerItem((Object)wp);
        }
    }
}

