/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.threshold;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.AverageBoxFilter;
import org.openimaj.image.processing.threshold.AbstractLocalThreshold;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class AdaptiveLocalThresholdMean
extends AbstractLocalThreshold {
    float offset;

    public AdaptiveLocalThresholdMean(int size) {
        super(size);
    }

    public AdaptiveLocalThresholdMean(int size_x, int size_y) {
        super(size_x, size_y);
    }

    public AdaptiveLocalThresholdMean(int size, float offset) {
        this(size, size, offset);
    }

    public AdaptiveLocalThresholdMean(int size_x, int size_y, float offset) {
        super(size_x, size_y);
        this.offset = offset;
    }

    public void processImage(FImage image) {
        FImage tmp = (FImage)image.process((SinglebandImageProcessor)new AverageBoxFilter(this.sizeX, this.sizeY));
        float[][] tpix = tmp.pixels;
        float[][] ipix = image.pixels;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                tpix[y][x] = ipix[y][x] < tpix[y][x] - this.offset ? 0.0f : 1.0f;
            }
        }
        image.internalAssign(tmp);
    }
}

