/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize.filters;

import org.openimaj.image.processing.resize.ResizeFilterFunction;

public class MitchellFilter
implements ResizeFilterFunction {
    public static ResizeFilterFunction INSTANCE = new MitchellFilter();

    @Override
    public double getSupport() {
        return 2.0;
    }

    @Override
    public double filter(double t) {
        double C = 0.3333333333333333;
        double B = 0.3333333333333333;
        double tt = t * t;
        if (t < 0.0) {
            t = -t;
        }
        if (t < 1.0) {
            t = (12.0 - 9.0 * B - 6.0 * C) * (t * tt) + (-18.0 + 12.0 * B + 6.0 * C) * tt + (6.0 - 2.0 * B);
            return t / 6.0;
        }
        if (t < 2.0) {
            t = (-1.0 * B - 6.0 * C) * (t * tt) + (6.0 * B + 30.0 * C) * tt + (-12.0 * B - 48.0 * C) * t + (8.0 * B + 24.0 * C);
            return t / 6.0;
        }
        return 0.0;
    }
}

