/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize.filters;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.processing.resize.ResizeFilterFunction;

@Reference(author={"R. B. Blackman", "J. W. Tukey"}, title="Particular Pairs of Windows", type=ReferenceType.Inbook, year="1959", booktitle=" In The Measurement of Power Spectra, From the Point of View of Communications Engineering", publisher="Dover", pages={"98", "99"})
public class BlackmanFilter
implements ResizeFilterFunction {
    private static double blackman(double t) {
        return 0.42 + 0.5 * Math.cos(Math.PI * t) + 0.08 * Math.cos(Math.PI * 2 * t);
    }

    @Override
    public final double filter(double t) {
        return BlackmanFilter.blackman(t);
    }

    @Override
    public final double getSupport() {
        return 1.0;
    }
}

