/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.morphology;

import java.util.HashSet;
import java.util.Set;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.morphology.StructuringElement;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

public class Erode
implements ConnectedComponentProcessor,
KernelProcessor<Float, FImage> {
    protected StructuringElement element;
    protected int cx;
    protected int cy;
    protected int sw;
    protected int sh;

    public Erode(StructuringElement se) {
        this.element = se;
        int[] sz = se.size();
        this.sw = sz[0];
        this.sh = sz[1];
        this.cx = this.sw / 2;
        this.cy = this.sh / 2;
    }

    public Erode() {
        this(StructuringElement.BOX);
    }

    public void process(ConnectedComponent cc) {
        HashSet<Pixel> retain = new HashSet<Pixel>();
        Set pixels = cc.getPixels();
        int[] se_size = this.element.size();
        Rectangle cc_bb = cc.calculateRegularBoundingBox();
        int j = (int)(cc_bb.y - (float)se_size[1]);
        while ((float)j <= cc_bb.y + (float)se_size[1] + cc_bb.height) {
            int i = (int)(cc_bb.x - (float)se_size[0]);
            while ((float)i <= cc_bb.x + (float)se_size[0] + cc_bb.width) {
                Pixel p = new Pixel(i, j);
                if (this.element.matches(p, pixels)) {
                    retain.add(p);
                }
                ++i;
            }
            ++j;
        }
        cc.getPixels().retainAll(retain);
    }

    public int getKernelHeight() {
        return this.sh;
    }

    public int getKernelWidth() {
        return this.sw;
    }

    public Float processKernel(FImage patch) {
        int py;
        int px;
        int count = 0;
        for (Pixel p : this.element.positive) {
            px = this.cx - p.x;
            py = this.cy - p.y;
            if (px < 0 || py < 0 || px >= this.sw || py >= this.sh || patch.pixels[py][px] != 1.0f) continue;
            ++count;
        }
        for (Pixel p : this.element.negative) {
            px = this.cx - p.x;
            py = this.cy - p.y;
            if (px < 0 || py < 0 || px >= this.sw || py >= this.sh || patch.pixels[py][px] != 0.0f) continue;
            ++count;
        }
        return Float.valueOf(count == this.element.positive.size() + this.element.negative.size() ? patch.pixels[this.cy][this.cx] : 0.0f);
    }

    public static void erode(FImage img, int times) {
        Erode e = new Erode();
        for (int i = 0; i < times; ++i) {
            img.processInplace((KernelProcessor)e);
        }
    }
}

