/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.algorithm;

import java.util.HashSet;
import java.util.Set;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;

public class FilterSupport {
    public static final Set<Pixel> CROSS_3x3 = new HashSet<Pixel>();
    public static final Set<Pixel> BLOCK_3x3;

    public static final Set<Pixel> createBlockSupport(int width, int height) {
        HashSet<Pixel> indices = new HashSet<Pixel>(width * height);
        int startX = -width / 2;
        int startY = -height / 2;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                indices.add(new Pixel(startX + x, startY + y));
            }
        }
        return indices;
    }

    public static final boolean isBlockSupport(Set<Pixel> support) {
        int sh;
        int sw = FilterSupport.getSupportWidth(support);
        return sw * (sh = FilterSupport.getSupportHeight(support)) == support.size() && FilterSupport.isCentred(support);
    }

    private static boolean isCentred(Set<Pixel> support) {
        ConnectedComponent cc = new ConnectedComponent(support);
        Pixel cp = cc.calculateCentroidPixel();
        return cp.x == 0 && cp.y == 0;
    }

    public static final int getSupportWidth(Set<Pixel> support) {
        int min = Integer.MAX_VALUE;
        int max = -2147483647;
        for (Pixel p : support) {
            min = Math.min(min, p.x);
            max = Math.max(max, p.x);
        }
        return max - min + 1;
    }

    public static final int getSupportHeight(Set<Pixel> support) {
        int min = Integer.MAX_VALUE;
        int max = -2147483647;
        for (Pixel p : support) {
            min = Math.min(min, p.y);
            max = Math.max(max, p.y);
        }
        return max - min + 1;
    }

    static {
        CROSS_3x3.add(new Pixel(0, -1));
        CROSS_3x3.add(new Pixel(-1, 0));
        CROSS_3x3.add(new Pixel(0, 0));
        CROSS_3x3.add(new Pixel(1, 0));
        CROSS_3x3.add(new Pixel(0, 1));
        BLOCK_3x3 = FilterSupport.createBlockSupport(3, 3);
    }
}

